/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.guide.elements;

import org.lwjgl.opengl.GL11;
import sonar.logistics.client.LogisticsColours;
import sonar.logistics.client.gui.GuiGuide;
import sonar.logistics.guide.IGuidePage;
import sonar.logistics.guide.IGuidePageElement;
import sonar.logistics.guide.Logistics3DRenderer;

public class Element3DRenderer
implements IGuidePageElement {
    public Logistics3DRenderer render;
    public int page;
    public static double rotate = 180.0;
    public static double rotateY = 0.0;
    public double scale;
    public int x;
    public int y;
    public int width;
    public int height;
    public static boolean canRotate = true;

    public static void reset() {
        rotate = 180.0;
        rotateY = 0.0;
        canRotate = true;
    }

    public Element3DRenderer(Logistics3DRenderer render, int page, double scale, int x, int y, int width, int height) {
        this.render = render;
        this.page = page;
        this.scale = scale;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Override
    public int getDisplayPage() {
        return this.page;
    }

    @Override
    public int[] getSizing() {
        return new int[]{this.x, this.y, this.width, this.height};
    }

    @Override
    public void drawElement(GuiGuide gui, int x, int y, int page, int mouseX, int mouseY) {
    }

    @Override
    public void drawForegroundElement(GuiGuide gui, int x, int y, int page, int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + this.width / 2), (double)(y + this.height / 2), (double)640.0);
        GL11.glRotated((double)(-25.0 + rotateY), (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)rotate, (double)0.0, (double)1.0, (double)0.0);
        GL11.glScaled((double)this.scale, (double)(-this.scale), (double)this.scale);
        this.render.renderInGui();
        if (canRotate && (rotate += 0.25) == 360.0) {
            rotate = 0.0;
        }
        GL11.glPopMatrix();
    }

    @Override
    public void drawBackgroundElement(GuiGuide gui, int x, int y, int page, int mouseX, int mouseY) {
        GuiGuide.drawTransparentRect((int)x, (int)y, (int)(x + this.width), (int)(y + this.height), (int)LogisticsColours.blue_overlay.getRGB());
    }

    @Override
    public boolean mouseClicked(GuiGuide gui, IGuidePage page, int x, int y, int button) {
        return false;
    }
}

