/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.helpers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.ISlottedPart;
import mcmultipart.multipart.MultipartHelper;
import mcmultipart.multipart.PartSlot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.core.api.utils.BlockCoords;
import sonar.core.utils.Pair;
import sonar.core.utils.SonarValidation;
import sonar.logistics.PL2;
import sonar.logistics.api.PL2API;
import sonar.logistics.api.networks.EmptyLogisticsNetwork;
import sonar.logistics.api.networks.ILogisticsNetwork;
import sonar.logistics.api.render.RenderInfoProperties;
import sonar.logistics.api.tiles.IConnectable;
import sonar.logistics.api.tiles.INetworkTile;
import sonar.logistics.api.tiles.cable.CableRenderType;
import sonar.logistics.api.tiles.cable.ConnectableType;
import sonar.logistics.api.tiles.cable.IDataCable;
import sonar.logistics.api.tiles.displays.ConnectedDisplay;
import sonar.logistics.api.tiles.displays.IDisplay;
import sonar.logistics.api.tiles.displays.ILargeDisplay;
import sonar.logistics.api.tiles.readers.IInfoProvider;
import sonar.logistics.api.viewers.ILogicListenable;
import sonar.logistics.api.wrappers.CablingWrapper;
import sonar.logistics.common.multiparts.SidedPart;
import sonar.logistics.common.multiparts.displays.DataCablePart;

public class CableHelper
extends CablingWrapper {
    public static CableRenderType checkBlockInDirection(DataCablePart cable, EnumFacing dir) {
        IMultipartContainer container = cable.getContainer();
        if (container != null) {
            if (cable.isBlocked[dir.ordinal()]) {
                return CableRenderType.NONE;
            }
            ISlottedPart part = container.getPartInSlot(PartSlot.getFaceSlot((EnumFacing)dir));
            if (part == null) {
                part = (IMultipart)PL2API.getCableHelper().getDisplayScreen(cable.getCoords(), dir);
            }
            if (part != null && part instanceof INetworkTile) {
                INetworkTile tile;
                if (part instanceof SidedPart) {
                    SidedPart sided = (SidedPart)part;
                    if (sided.getMultipart().heightMax == 0.375) {
                        return CableRenderType.NONE;
                    }
                    if (sided.getMultipart().heightMax == 0.25) {
                        return CableRenderType.HALF;
                    }
                }
                if ((tile = (INetworkTile)part).canConnect(dir.func_176734_d()).canShowConnection()) {
                    return CableRenderType.INTERNAL;
                }
            }
            Pair<ConnectableType, Integer> connection = CableHelper.getConnectionType(cable, container.getWorldIn(), container.getPosIn(), dir, cable.getConnectableType());
            return !cable.canConnectOnSide(cable.registryID, dir, false) || !((ConnectableType)((Object)connection.a)).canConnect(cable.getConnectableType()) ? CableRenderType.NONE : CableRenderType.CABLE;
        }
        return CableRenderType.NONE;
    }

    public static double[] getPos(IDisplay display, RenderInfoProperties renderInfo) {
        ConnectedDisplay connected;
        if (display instanceof ConnectedDisplay && (connected = (ConnectedDisplay)display).getTopLeftScreen() != null && connected.getTopLeftScreen().getCoords() != null) {
            BlockPos leftPos = connected.getTopLeftScreen().getCoords().getBlockPos();
            double[] translation = renderInfo.getTranslation();
            switch (display.getCableFace()) {
                case DOWN: {
                    break;
                }
                case EAST: {
                    break;
                }
                case NORTH: {
                    return new double[]{(double)leftPos.func_177958_n() - translation[0], (double)leftPos.func_177956_o() - translation[1], leftPos.func_177952_p()};
                }
                case SOUTH: {
                    break;
                }
                case UP: {
                    break;
                }
                case WEST: {
                    break;
                }
            }
        }
        return new double[]{display.getCoords().getX(), display.getCoords().getY(), display.getCoords().getZ()};
    }

    public static int getSlot(IDisplay display, RenderInfoProperties renderInfo, Vec3d hitVec, int xSize, int ySize) {
        double[] pos = CableHelper.getPos(display, renderInfo);
        int maxH = (int)Math.ceil(renderInfo.getScaling()[0]);
        int minH = 0;
        int maxY = (int)Math.ceil(renderInfo.getScaling()[1]);
        boolean minY = false;
        int hSlots = Math.max(1, Math.round(maxH - minH) * xSize);
        int yPos = (int)((1.0 - (hitVec.field_72448_b - pos[1])) * Math.ceil(display.getDisplayType().height * (double)ySize));
        int hPos = 0;
        switch (display.getCableFace()) {
            case DOWN: {
                switch (display.getRotation()) {
                    case EAST: {
                        hPos = (int)(((double)(maxH - minH) - (hitVec.field_72449_c - pos[2])) * (double)xSize);
                        yPos = (int)(((double)(maxH - minH) - (hitVec.field_72450_a - pos[0])) * 2.0);
                        return yPos * hSlots + hPos;
                    }
                    case NORTH: {
                        hPos = (int)(((double)(maxH - minH) - (hitVec.field_72450_a - pos[0])) * (double)xSize);
                        yPos = (int)(((double)minH + (hitVec.field_72449_c - pos[2])) * 2.0);
                        return yPos * hSlots + hPos;
                    }
                    case SOUTH: {
                        hPos = (int)(((double)minH + (hitVec.field_72450_a - pos[0])) * (double)xSize);
                        yPos = (int)(((double)(maxH - minH) - (hitVec.field_72449_c - pos[2])) * 2.0);
                        return yPos * hSlots + hPos;
                    }
                    case WEST: {
                        hPos = (int)(((double)minH + (hitVec.field_72449_c - pos[2])) * (double)xSize);
                        yPos = (int)(((double)minH + (hitVec.field_72450_a - pos[0])) * 2.0);
                        return yPos * hSlots + hPos;
                    }
                }
                break;
            }
            case EAST: {
                hPos = (int)(((double)(1 + minH) - (hitVec.field_72449_c - pos[2])) * (double)xSize);
                return yPos * hSlots + hPos;
            }
            case NORTH: {
                hPos = (int)((1.0 - (hitVec.field_72450_a - pos[0])) * (double)xSize);
                return yPos * hSlots + hPos;
            }
            case SOUTH: {
                hPos = (int)(((double)(maxH - minH) + (hitVec.field_72450_a - pos[0])) * (double)xSize);
                return yPos * hSlots + hPos - maxH * 2;
            }
            case UP: {
                switch (display.getRotation()) {
                    case EAST: {
                        hPos = (int)(((double)(maxH - minH) - (hitVec.field_72449_c - pos[2])) * (double)xSize);
                        yPos = (int)(((double)minH + (hitVec.field_72450_a - pos[0])) * 2.0);
                        return yPos * hSlots + hPos;
                    }
                    case NORTH: {
                        hPos = (int)(((double)(maxH - minH) - (hitVec.field_72450_a - pos[0])) * (double)xSize);
                        yPos = (int)(((double)maxH - (hitVec.field_72449_c - pos[2])) * 2.0);
                        return yPos * hSlots + hPos;
                    }
                    case SOUTH: {
                        hPos = (int)(((double)(maxH - minH) + (hitVec.field_72450_a - pos[0])) * (double)xSize);
                        yPos = (int)(((double)minH + (hitVec.field_72449_c - pos[2])) * 2.0);
                        return yPos * hSlots + hPos - maxH * 2;
                    }
                    case WEST: {
                        hPos = (int)(((double)(maxH - minH) + (hitVec.field_72449_c - pos[2])) * (double)xSize);
                        yPos = (int)(((double)minH - (hitVec.field_72450_a - pos[0])) * 2.0);
                        return yPos * hSlots + hPos;
                    }
                }
                break;
            }
            case WEST: {
                hPos = (int)(((double)(maxH - minH) + (hitVec.field_72449_c - pos[2])) * (double)xSize);
                return yPos * hSlots + hPos - maxH * 2;
            }
        }
        return -1;
    }

    public static int getListSlot(IDisplay display, RenderInfoProperties renderInfo, Vec3d hitVec, double elementSize, double spacing, int maxPageSize) {
        double[] pos = CableHelper.getPos(display, renderInfo);
        int maxH = (int)Math.ceil(renderInfo.getScaling()[0]);
        int minH = 0;
        int maxY = (int)Math.ceil(renderInfo.getScaling()[1]);
        boolean minY = false;
        boolean hSlots = true;
        double yClick = (1.0 - (hitVec.field_72448_b - pos[1])) * Math.ceil(display.getDisplayType().height);
        block0 : switch (display.getCableFace()) {
            case DOWN: {
                switch (display.getRotation()) {
                    case EAST: {
                        yClick = ((double)(maxH - minH) - (hitVec.field_72450_a - pos[0])) * 2.0;
                        break block0;
                    }
                    case NORTH: {
                        yClick = ((double)minH + (hitVec.field_72449_c - pos[2])) * 2.0;
                        break block0;
                    }
                    case SOUTH: {
                        yClick = ((double)(maxH - minH) - (hitVec.field_72449_c - pos[2])) * 2.0;
                        break block0;
                    }
                    case WEST: {
                        yClick = ((double)minH + (hitVec.field_72450_a - pos[0])) * 2.0;
                        break block0;
                    }
                }
                break;
            }
            case UP: {
                switch (display.getRotation()) {
                    case EAST: {
                        yClick = ((double)minH + (hitVec.field_72450_a - pos[0])) * 2.0;
                        break block0;
                    }
                    case NORTH: {
                        yClick = ((double)maxH - (hitVec.field_72449_c - pos[2])) * 2.0;
                        break block0;
                    }
                    case SOUTH: {
                        yClick = ((double)minH + (hitVec.field_72449_c - pos[2])) * 2.0;
                        break block0;
                    }
                    case WEST: {
                        yClick = ((double)minH - (hitVec.field_72450_a - pos[0])) * 2.0;
                        break block0;
                    }
                }
                break;
            }
        }
        for (int i = 0; i < maxPageSize; ++i) {
            double yStart = (double)i * elementSize + Math.max(0.0, (double)(i - 1) * spacing) + 0.0625;
            double yEnd = yStart + elementSize;
            if (!(yClick > yStart) || !(yClick < yEnd)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public IDataCable getCableFromCoords(BlockCoords coords) {
        ISlottedPart part;
        IMultipartContainer container;
        if (coords.getWorld() != null && (container = MultipartHelper.getPartContainer((IBlockAccess)coords.getWorld(), (BlockPos)coords.getBlockPos())) != null && (part = container.getPartInSlot(PartSlot.CENTER)) != null && part instanceof IDataCable) {
            return (IDataCable)part;
        }
        return null;
    }

    @Override
    public INetworkTile getMultipart(BlockCoords coords, EnumFacing face) {
        ISlottedPart part;
        IMultipartContainer container;
        if (coords.getWorld() != null && (container = MultipartHelper.getPartContainer((IBlockAccess)coords.getWorld(), (BlockPos)coords.getBlockPos())) != null && (part = container.getPartInSlot(PartSlot.getFaceSlot((EnumFacing)face))) instanceof INetworkTile) {
            return (INetworkTile)part;
        }
        return null;
    }

    @Override
    public IDisplay getDisplayScreen(BlockCoords coords, EnumFacing face) {
        IMultipartContainer container;
        if (coords.getWorld() != null && (container = MultipartHelper.getPartContainer((IBlockAccess)coords.getWorld(), (BlockPos)coords.getBlockPos())) != null) {
            return this.getDisplayScreen(container, face);
        }
        return null;
    }

    @Override
    public ILargeDisplay getDisplayScreen(BlockCoords coords, int registryID) {
        IMultipartContainer container;
        if (coords.getWorld() != null && (container = MultipartHelper.getPartContainer((IBlockAccess)coords.getWorld(), (BlockPos)coords.getBlockPos())) != null) {
            return this.getDisplayScreen(container, registryID);
        }
        return null;
    }

    public IDisplay getDisplayScreen(IMultipartContainer container, EnumFacing face) {
        for (IMultipart part : container.getParts()) {
            IDisplay display;
            if (part == null || !(part instanceof IDisplay) || (display = (IDisplay)part).getCableFace() != face) continue;
            return display;
        }
        return null;
    }

    public ILargeDisplay getDisplayScreen(IMultipartContainer container, int registryID) {
        for (IMultipart part : container.getParts()) {
            ILargeDisplay display;
            if (part == null || !(part instanceof ILargeDisplay) || (display = (ILargeDisplay)part).getRegistryID() != registryID) continue;
            return display;
        }
        return null;
    }

    public static List<INetworkTile> getConnectedTiles(DataCablePart cable) {
        return CableHelper.getConnectedTiles(cable, (SonarValidation)new SonarValidation.CLASS(INetworkTile.class));
    }

    public static <T> List<T> getConnectedTiles(DataCablePart cable, Class<T> type) {
        return CableHelper.getConnectedTiles(cable, (SonarValidation)new SonarValidation.CLASS(type));
    }

    public static List getConnectedTilesOfTypes(DataCablePart cable, Class ... type) {
        return CableHelper.getConnectedTiles(cable, (SonarValidation)new SonarValidation.CLASSLIST(type));
    }

    public static <T> List<T> getConnectedTiles(DataCablePart cable, SonarValidation validate) {
        ArrayList logicTiles = Lists.newArrayList();
        for (IMultipart part : cable.getContainer().getParts()) {
            SidedPart sided;
            if (!validate.isValid((Object)part) || part instanceof SidedPart && !cable.canConnectOnSide((sided = (SidedPart)part).getNetworkID(), sided.getCableFace(), true)) continue;
            logicTiles.add(part);
        }
        for (EnumFacing face : EnumFacing.values()) {
            if (!cable.canConnectOnSide(cable.registryID, face, false)) continue;
            BlockCoords offset = BlockCoords.translateCoords((BlockCoords)cable.getCoords(), (EnumFacing)face.func_176734_d());
            INetworkTile tile = PL2API.getCableHelper().getMultipart(offset, face);
            if (!validate.isValid((Object)tile) || !tile.canConnect(face).canConnect()) continue;
            logicTiles.add(tile);
        }
        return logicTiles;
    }

    public static List<IInfoProvider> getLocalMonitors(DataCablePart cable) {
        ArrayList logicTiles = Lists.newArrayList();
        for (EnumFacing face : EnumFacing.values()) {
            if (!cable.canConnectOnSide(cable.getRegistryID(), face.func_176734_d(), false)) continue;
            BlockCoords offset = BlockCoords.translateCoords((BlockCoords)cable.getCoords(), (EnumFacing)face.func_176734_d());
            INetworkTile tile = PL2API.getCableHelper().getMultipart(offset, face);
            if (!(tile instanceof IInfoProvider)) continue;
            logicTiles.add((IInfoProvider)tile);
        }
        return logicTiles;
    }

    @Override
    public ILogisticsNetwork getNetwork(TileEntity tile, EnumFacing dir) {
        ILogisticsNetwork cache;
        Pair<ConnectableType, Integer> connection = PL2.getDisplayManager().getConnectionType((ILargeDisplay)null, tile.func_145831_w(), tile.func_174877_v(), dir, ConnectableType.CONNECTABLE);
        if (connection.a != ConnectableType.NONE && (Integer)connection.b != -1 && (cache = PL2.instance.networkManager.getNetwork((Integer)connection.b)) != null) {
            return cache;
        }
        return EmptyLogisticsNetwork.INSTANCE;
    }

    @Override
    public ILogisticsNetwork getNetwork(int registryID) {
        return PL2.instance.networkManager.getNetwork(registryID);
    }

    public static ILogicListenable getMonitorFromIdentity(int identity, boolean isRemote) {
        for (ILogicListenable monitor : Maps.newHashMap(PL2.getInfoManager(isRemote).getMonitors()).values()) {
            if (monitor.getIdentity() == -1 || monitor.getIdentity() != identity) continue;
            return monitor;
        }
        return null;
    }

    public static <T extends IConnectable> Pair<ConnectableType, Integer> getConnectionType(T source, World world, BlockPos pos, EnumFacing dir, ConnectableType cableType) {
        BlockPos offset = pos.func_177972_a(dir);
        IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)world, (BlockPos)offset);
        if (container != null) {
            return CableHelper.getConnectionType(source, container, dir, cableType);
        }
        TileEntity tile = world.func_175625_s(offset);
        if (tile != null) {
            return CableHelper.getConnectionTypeFromObject(source, tile, dir, cableType);
        }
        return new Pair((Object)ConnectableType.NONE, (Object)-1);
    }

    public static <T extends IConnectable> Pair<ConnectableType, Integer> getConnectionType(T source, IMultipartContainer container, EnumFacing dir, ConnectableType cableType) {
        ISlottedPart part = container.getPartInSlot(PartSlot.getFaceSlot((EnumFacing)dir.func_176734_d()));
        if (part != null) {
            return CableHelper.getConnectionTypeFromObject(source, part, dir, cableType);
        }
        ISlottedPart centre = container.getPartInSlot(PartSlot.CENTER);
        if (centre != null && centre instanceof IDataCable) {
            return CableHelper.getConnectionTypeFromObject(source, centre, dir, cableType);
        }
        return new Pair((Object)ConnectableType.NONE, (Object)-1);
    }

    public static <T extends IConnectable> Pair<ConnectableType, Integer> getConnectionTypeFromObject(T source, Object connection, EnumFacing dir, ConnectableType cableType) {
        if (connection instanceof IDataCable) {
            IDataCable cable = (IDataCable)connection;
            if (cable.getConnectableType().canConnect(cableType)) {
                return cable.canConnectOnSide(cable.getRegistryID(), dir.func_176734_d(), false) ? new Pair((Object)cable.getConnectableType(), (Object)cable.getRegistryID()) : new Pair((Object)ConnectableType.NONE, (Object)-1);
            }
        } else if (connection instanceof INetworkTile) {
            return ((INetworkTile)connection).canConnect(dir.func_176734_d()).canShowConnection() ? new Pair((Object)ConnectableType.TILE, (Object)-1) : new Pair((Object)ConnectableType.NONE, (Object)-1);
        }
        return new Pair((Object)ConnectableType.NONE, (Object)-1);
    }
}

