/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.helpers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import sonar.core.SonarCore;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.energy.ISonarEnergyHandler;
import sonar.core.api.energy.StoredEnergyStack;
import sonar.core.helpers.SonarHelper;
import sonar.core.utils.SortingDirection;
import sonar.logistics.api.tiles.readers.EnergyReader;
import sonar.logistics.api.wrappers.EnergyWrapper;
import sonar.logistics.info.types.MonitoredEnergyStack;

public class EnergyHelper
extends EnergyWrapper {
    public List<ISonarEnergyHandler> getProviders(EnergyType type) {
        ArrayList providers = Lists.newArrayList();
        List handlers = SonarCore.energyHandlers;
        for (ISonarEnergyHandler provider : handlers) {
            if (!provider.getProvidedType().getName().equals(type.getName())) continue;
            providers.add(provider);
        }
        return providers;
    }

    public static void sortEnergyList(List<MonitoredEnergyStack> info, final SortingDirection dir, final EnergyReader.SortingType type) {
        info.sort(new Comparator<MonitoredEnergyStack>(){

            @Override
            public int compare(MonitoredEnergyStack str1, MonitoredEnergyStack str2) {
                StoredEnergyStack item1 = str1.getEnergyStack();
                StoredEnergyStack item2 = str2.getEnergyStack();
                switch (type) {
                    case CAPACITY: {
                        return SonarHelper.compareWithDirection((long)item1.capacity, (long)item2.capacity, (SortingDirection)dir);
                    }
                    case INPUT: {
                        return SonarHelper.compareWithDirection((long)item1.input, (long)item2.input, (SortingDirection)dir);
                    }
                    case NAME: {
                        String modid1 = str1.getMonitoredCoords().getUnlocalizedName();
                        String modid2 = str2.getMonitoredCoords().getUnlocalizedName();
                        return SonarHelper.compareStringsWithDirection((String)modid1, (String)modid2, (SortingDirection)dir);
                    }
                    case STORED: {
                        return SonarHelper.compareWithDirection((long)item1.stored, (long)item2.stored, (SortingDirection)dir);
                    }
                    case TYPE: {
                        return SonarHelper.compareStringsWithDirection((String)item1.energyType.getName(), (String)item2.energyType.getName(), (SortingDirection)dir);
                    }
                }
                return 0;
            }
        });
    }
}

