/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.helpers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import sonar.core.SonarCore;
import sonar.core.api.SonarAPI;
import sonar.core.api.fluids.ISonarFluidHandler;
import sonar.core.api.fluids.StoredFluidStack;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.utils.ActionType;
import sonar.core.helpers.FluidHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.utils.SortingDirection;
import sonar.logistics.api.PL2API;
import sonar.logistics.api.networks.ILogisticsNetwork;
import sonar.logistics.api.tiles.nodes.BlockConnection;
import sonar.logistics.api.tiles.nodes.NodeConnection;
import sonar.logistics.api.tiles.nodes.NodeTransferMode;
import sonar.logistics.api.tiles.readers.FluidReader;
import sonar.logistics.api.utils.CacheType;
import sonar.logistics.api.wrappers.FluidWrapper;
import sonar.logistics.helpers.ItemHelper;
import sonar.logistics.helpers.NetworkHelper;
import sonar.logistics.info.types.MonitoredFluidStack;

public class FluidHelper
extends FluidWrapper {
    @Override
    public StoredFluidStack transferFluids(ILogisticsNetwork network, StoredFluidStack add, NodeTransferMode mode, ActionType action, FluidHelper.ITankFilter filter) {
        if (!FluidHelper.validStack(add)) {
            return add;
        }
        return NetworkHelper.forEachTileEntity(network, CacheType.ALL, c -> c.canTransferFluid((NodeConnection)c, add, mode), this.getTileAction(add, mode, action, filter)) ? add : null;
    }

    private BiPredicate<BlockConnection, TileEntity> getTileAction(StoredFluidStack stack, NodeTransferMode mode, ActionType action, FluidHelper.ITankFilter filter) {
        return (c, t) -> stack.setStackSize(this.transfer(mode, (TileEntity)t, stack, c.face, action)).getStackSize() != 0L;
    }

    private StoredFluidStack transfer(NodeTransferMode mode, TileEntity tile, StoredFluidStack stack, EnumFacing dir, ActionType action) {
        List handlers = SonarCore.fluidHandlers;
        for (ISonarFluidHandler handler : handlers) {
            if (!handler.canHandleFluids(tile, dir)) continue;
            StoredFluidStack copy = stack.copy().setStackSize(stack);
            stack = mode.shouldRemove() ? handler.removeStack(copy, tile, dir, action) : handler.addStack(stack, tile, dir, action);
            return stack;
        }
        return null;
    }

    public static boolean validStack(StoredFluidStack stack) {
        return stack != null && stack.getStackSize() != 0L;
    }

    public int fillCapabilityStack(ItemStack container, StoredFluidStack fill, ILogisticsNetwork network, ActionType action) {
        if (container.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            return ((IFluidHandler)container.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).fill(fill.getFullStack(), !action.shouldSimulate());
        }
        return 0;
    }

    public FluidStack drainCapabilityStack(ItemStack container, int toDrain, ILogisticsNetwork network, ActionType action) {
        if (container.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            IFluidHandler handler = (IFluidHandler)container.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            FluidStack stack = handler.getTankProperties()[0].getContents();
            if (stack != null && stack.amount >= 0) {
                StoredFluidStack add = new StoredFluidStack(stack, (long)Math.min(toDrain, stack.amount));
                StoredFluidStack added = SonarAPI.getFluidHelper().getStackToAdd((long)toDrain, add, this.transferFluids(network, add.copy(), null, ActionType.SIMULATE, null));
                if (added == null || added.stored >= 0L) {
                    return handler.drain((int)added.stored, !action.shouldSimulate());
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public void fillHeldItem(EntityPlayer player, ILogisticsNetwork cache, StoredFluidStack toFill) {
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem == null || toFill == null) {
            return;
        }
        heldItem = heldItem.func_77946_l();
        heldItem.field_77994_a = 1;
        StoredFluidStack remaining = this.transferFluids(cache, toFill.copy(), NodeTransferMode.REMOVE, ActionType.SIMULATE, null);
        StoredFluidStack removed = SonarAPI.getFluidHelper().getStackToAdd(toFill.getStackSize(), toFill, remaining);
        if (removed.stored <= 0L) {
            return;
        }
        int filled = this.fillCapabilityStack(heldItem.func_77946_l(), removed, cache, ActionType.SIMULATE);
        if (filled != 0) {
            ItemStack toAdd = heldItem.func_77946_l();
            removed = SonarAPI.getFluidHelper().getStackToAdd(toFill.getStackSize(), toFill, this.transferFluids(cache, new StoredFluidStack(toFill.getFullStack(), (long)filled, toFill.capacity), NodeTransferMode.REMOVE, ActionType.PERFORM, null));
            int fill = this.fillCapabilityStack(toAdd, removed, cache, ActionType.PERFORM);
            if (player.func_184614_ca().field_77994_a != 1) {
                player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                PL2API.getItemHelper().addStackToPlayer(new StoredItemStack(toAdd), player, false, ActionType.PERFORM);
            } else {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, toAdd);
            }
        }
    }

    @Override
    public void drainHeldItem(EntityPlayer player, ILogisticsNetwork cache, int toDrain) {
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem == null || toDrain <= 0) {
            return;
        }
        FluidStack drained = this.drainCapabilityStack(heldItem.func_77946_l(), toDrain, cache, ActionType.SIMULATE);
        if (drained != null && drained.amount > 0) {
            ItemStack toAdd = heldItem.func_77946_l();
            this.transferFluids(cache, new StoredFluidStack(this.drainCapabilityStack(toAdd, toDrain, cache, ActionType.PERFORM)), null, ActionType.PERFORM, null);
            if (heldItem.field_77994_a != 1) {
                player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                PL2API.getItemHelper().addStackToPlayer(new StoredItemStack(toAdd), player, false, ActionType.PERFORM);
            } else {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, toAdd);
            }
        }
    }

    public static void transferFluids(NodeTransferMode mode, BlockConnection filter, BlockConnection connection) {
        TileEntity filterTile = filter.coords.getTileEntity();
        TileEntity netTile = connection.coords.getTileEntity();
        if (filterTile != null && netTile != null) {
            EnumFacing dirFrom = mode.shouldRemove() ? filter.face : connection.face;
            EnumFacing dirTo = !mode.shouldRemove() ? filter.face : connection.face;
            TileEntity from = mode.shouldRemove() ? filterTile : netTile;
            TileEntity to = !mode.shouldRemove() ? filterTile : netTile;
            ItemHelper.ConnectionFilters filters = new ItemHelper.ConnectionFilters(null, filter, connection);
            SonarAPI.getFluidHelper().transferFluids(from, to, dirFrom.func_176734_d(), dirTo.func_176734_d(), (FluidHelper.ITankFilter)filters);
        }
    }

    public static void sortFluidList(ArrayList<MonitoredFluidStack> current, final SortingDirection dir, final FluidReader.SortingType type) {
        current.sort(new Comparator<MonitoredFluidStack>(){

            @Override
            public int compare(MonitoredFluidStack str1, MonitoredFluidStack str2) {
                StoredFluidStack flu1 = str1.getStoredStack();
                StoredFluidStack flu2 = str2.getStoredStack();
                int res = String.CASE_INSENSITIVE_ORDER.compare(flu1.getFullStack().getLocalizedName(), flu2.getFullStack().getLocalizedName());
                if (res == 0) {
                    res = flu1.getFullStack().getLocalizedName().compareTo(flu2.getFullStack().getLocalizedName());
                }
                return dir == SortingDirection.DOWN ? res : -res;
            }
        });
        current.sort(new Comparator<MonitoredFluidStack>(){

            @Override
            public int compare(MonitoredFluidStack str1, MonitoredFluidStack str2) {
                StoredFluidStack flu1 = str1.getStoredStack();
                StoredFluidStack flu2 = str2.getStoredStack();
                switch (type) {
                    case MODID: {
                        return SonarHelper.compareStringsWithDirection((String)flu1.getFullStack().getFluid().getBlock().getRegistryName().func_110624_b(), (String)flu2.getFullStack().getFluid().getBlock().getRegistryName().func_110624_b(), (SortingDirection)dir);
                    }
                    case NAME: {
                        break;
                    }
                    case STORED: {
                        return SonarHelper.compareWithDirection((long)flu1.stored, (long)flu2.stored, (SortingDirection)dir);
                    }
                    case TEMPERATURE: {
                        return SonarHelper.compareWithDirection((long)flu1.getFullStack().getFluid().getTemperature(), (long)flu2.getFullStack().getFluid().getTemperature(), (SortingDirection)dir);
                    }
                }
                return 0;
            }
        });
    }
}

