/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.helpers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import mcmultipart.multipart.IMultipart;
import mcmultipart.raytrace.PartMOP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.api.SonarAPI;
import sonar.core.api.fluids.StoredFluidStack;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.utils.BlockInteractionType;
import sonar.core.helpers.NBTHelper;
import sonar.core.utils.Pair;
import sonar.logistics.PL2;
import sonar.logistics.PL2ASMLoader;
import sonar.logistics.api.PL2API;
import sonar.logistics.api.filters.INodeFilter;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.IProvidableInfo;
import sonar.logistics.api.networks.ILogisticsNetwork;
import sonar.logistics.api.render.RenderInfoProperties;
import sonar.logistics.api.tiles.displays.DisplayLayout;
import sonar.logistics.api.tiles.displays.DisplayType;
import sonar.logistics.api.tiles.displays.IDisplay;
import sonar.logistics.api.tiles.displays.IScaleableDisplay;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.common.multiparts.LogisticsPart;
import sonar.logistics.connections.channels.ItemNetworkChannels;
import sonar.logistics.info.types.LogicInfo;
import sonar.logistics.network.PacketItemInteractionText;

public class InfoHelper {
    public static final String DELETE = "del";
    public static final String SYNC = "syn";
    public static final String REMOVED = "rem";
    public static final String SPECIAL = "spe";

    public static boolean isMatchingInfo(IInfo info, IInfo info2) {
        return info.isMatchingType(info2) && info.isMatchingInfo(info2);
    }

    public static boolean isIdenticalInfo(IInfo info, IInfo info2) {
        return InfoHelper.isMatchingInfo(info, info2) && info.isIdenticalInfo(info2);
    }

    public static void screenItemStackClicked(StoredItemStack itemstack, int network, BlockInteractionType type, boolean doubleClick, RenderInfoProperties renderInfo, EntityPlayer player, EnumHand hand, ItemStack stack, PartMOP hit) {
        Pair<Integer, ItemInteractionType> toRemove = InfoHelper.getItemsToRemove(type);
        if ((Integer)toRemove.a != 0 && network != -1) {
            ILogisticsNetwork cache = PL2.getNetworkManager().getNetwork(network);
            if (!cache.isValid()) {
                return;
            }
            switch ((ItemInteractionType)((Object)toRemove.b)) {
                case ADD: {
                    if (stack == null) break;
                    long changed = 0L;
                    changed = !doubleClick ? PL2API.getItemHelper().insertItemFromPlayer(player, cache, player.field_71071_by.field_70461_c) : PL2API.getItemHelper().insertInventoryFromPlayer(player, cache, player.field_71071_by.field_70461_c);
                    if (changed <= 0L) break;
                    long itemCount = PL2API.getItemHelper().getItemCount(stack, cache);
                    PL2.network.sendTo((IMessage)new PacketItemInteractionText(stack, itemCount, changed), (EntityPlayerMP)player);
                    break;
                }
                case REMOVE: {
                    IMultipart part;
                    if (itemstack == null || (part = hit.partHit) == null || !(part instanceof LogisticsPart)) break;
                    BlockPos pos = part.getPos();
                    StoredItemStack extract = PL2API.getItemHelper().extractItem(cache, itemstack.copy().setStackSize((long)((Integer)toRemove.a).intValue()));
                    if (extract == null) break;
                    pos = pos.func_177972_a(hit.field_178784_b);
                    long r = extract.stored;
                    SonarAPI.getItemHelper().spawnStoredItemStack(extract, part.getWorld(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), hit.field_178784_b);
                    long itemCount = PL2API.getItemHelper().getItemCount(itemstack.getItemStack(), cache);
                    PL2.network.sendTo((IMessage)new PacketItemInteractionText(itemstack.getItemStack(), itemCount, -r), (EntityPlayerMP)player);
                    break;
                }
            }
            ItemNetworkChannels channels = cache.getNetworkChannels(ItemNetworkChannels.class);
            if (channels != null) {
                channels.sendFullRapidUpdate();
            }
        }
    }

    public static void screenFluidStackClicked(StoredFluidStack fluidStack, int network, BlockInteractionType type, boolean doubleClick, RenderInfoProperties renderInfo, EntityPlayer player, EnumHand hand, ItemStack stack, PartMOP hit) {
        if (network != -1) {
            ILogisticsNetwork cache = PL2.getNetworkManager().getNetwork(network);
            if (!cache.isValid()) {
                return;
            }
            if (type == BlockInteractionType.RIGHT) {
                PL2API.getFluidHelper().drainHeldItem(player, cache, doubleClick ? Integer.MAX_VALUE : 1000);
            } else if (fluidStack != null && type == BlockInteractionType.LEFT) {
                PL2API.getFluidHelper().fillHeldItem(player, cache, fluidStack.copy().setStackSize(Math.min(fluidStack.stored, 1000L)));
            } else if (fluidStack != null && type == BlockInteractionType.SHIFT_LEFT) {
                PL2API.getFluidHelper().fillHeldItem(player, cache, fluidStack);
            }
            ItemNetworkChannels channels = cache.getNetworkChannels(ItemNetworkChannels.class);
            if (channels != null) {
                channels.sendFullRapidUpdate();
            }
        }
    }

    public static <T extends IInfo> NBTTagCompound writeMonitoredList(NBTTagCompound tag, boolean lastWasNull, MonitoredList<T> stacks, NBTHelper.SyncType type) {
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC})) {
            stacks.sizing.writeData(tag, NBTHelper.SyncType.SAVE);
            NBTTagList list = new NBTTagList();
            stacks.forEach(info -> {
                if (info != null && info.isValid()) {
                    list.func_74742_a((NBTBase)InfoHelper.writeInfoToNBT(new NBTTagCompound(), info, NBTHelper.SyncType.SAVE));
                }
            });
            if (list.func_74745_c() != 0) {
                tag.func_74782_a(SYNC, (NBTBase)list);
                return tag;
            }
            tag.func_74757_a(DELETE, true);
            return tag;
        }
        if (!(!type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL}) || stacks.changed.isEmpty() && stacks.removed.isEmpty())) {
            stacks.sizing.writeData(tag, NBTHelper.SyncType.DEFAULT_SYNC);
            if (stacks == null || stacks.isEmpty()) {
                if (!lastWasNull) {
                    tag.func_74757_a(DELETE, true);
                }
                return tag;
            }
            NBTTagList list = new NBTTagList();
            for (int listType = 0; listType < 2; ++listType) {
                List stackList = listType == 0 ? stacks.changed : stacks.removed;
                for (int i = 0; i < stackList.size(); ++i) {
                    IInfo info2 = (IInfo)stackList.get(i);
                    if (info2 == null || !info2.isValid()) continue;
                    NBTTagCompound compound = new NBTTagCompound();
                    compound.func_74757_a(REMOVED, listType == 1);
                    list.func_74742_a((NBTBase)InfoHelper.writeInfoToNBT(compound, info2, NBTHelper.SyncType.SAVE));
                }
            }
            if (list.func_74745_c() != 0) {
                tag.func_74782_a(SPECIAL, (NBTBase)list);
            }
        }
        return tag;
    }

    public static <T extends IInfo> MonitoredList<T> readMonitoredList(NBTTagCompound tag, MonitoredList<T> stacks, NBTHelper.SyncType type) {
        block8: {
            block7: {
                if (tag.func_74764_b(DELETE)) {
                    stacks.clear();
                    return stacks;
                }
                if (!type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC})) break block7;
                if (!tag.func_74764_b(SYNC)) {
                    return stacks;
                }
                NBTTagList list = tag.func_150295_c(SYNC, 10);
                stacks.clear();
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    stacks.add(InfoHelper.readInfoFromNBT(list.func_150305_b(i)));
                }
                break block8;
            }
            if (!type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL})) break block8;
            if (!tag.func_74764_b(SPECIAL)) {
                return stacks;
            }
            NBTTagList list = tag.func_150295_c(SPECIAL, 10);
            block1: for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound infoTag = list.func_150305_b(i);
                boolean removed = infoTag.func_74767_n(REMOVED);
                IInfo stack = InfoHelper.readInfoFromNBT(infoTag);
                for (IInfo stored : stacks) {
                    if (!stack.isMatchingType(stored) || !stack.isMatchingInfo(stored)) continue;
                    if (removed) {
                        stacks.remove(stored);
                        continue block1;
                    }
                    stored.readData(infoTag, NBTHelper.SyncType.SAVE);
                    continue block1;
                }
                stacks.add(stack);
            }
        }
        return stacks;
    }

    public static List<IProvidableInfo> sortInfoList(List<IProvidableInfo> oldInfo) {
        ArrayList providerInfo = Lists.newArrayList(oldInfo);
        Collections.sort(providerInfo, new Comparator<IProvidableInfo>(){

            @Override
            public int compare(IProvidableInfo str1, IProvidableInfo str2) {
                return Integer.compare(str1.getRegistryType().sortOrder, str2.getRegistryType().sortOrder);
            }
        });
        ArrayList sortedInfo = Lists.newArrayList();
        IInfo lastInfo = null;
        for (IProvidableInfo blockInfo : Lists.newArrayList((Iterable)providerInfo)) {
            if (blockInfo == null || blockInfo.isHeader()) continue;
            if (lastInfo == null || !lastInfo.isHeader() && !lastInfo.getRegistryType().equals((Object)blockInfo.getRegistryType())) {
                sortedInfo.add(LogicInfo.buildCategoryInfo(blockInfo.getRegistryType()));
            }
            sortedInfo.add(blockInfo);
            lastInfo = blockInfo;
        }
        return sortedInfo;
    }

    public static double[] getScaling(IDisplay display, DisplayLayout layout, int pos) {
        DisplayType type = display.getDisplayType();
        double width = type.width;
        double height = type.height;
        double scale = type.scale;
        if (display instanceof IScaleableDisplay) {
            double[] scaling = ((IScaleableDisplay)((Object)display)).getScaling();
            width = scaling[0];
            height = scaling[1];
            scale = scaling[2];
        }
        switch (layout) {
            case DUAL: {
                return new double[]{width, height / 2.0, scale};
            }
            case GRID: {
                return new double[]{width / 2.0, height / 2.0, scale / 1.5};
            }
            case LIST: {
                return new double[]{width, height / 4.0, scale / 1.5};
            }
        }
        return new double[]{width, height, scale * 1.2};
    }

    public static double[] getTranslation(IDisplay display, DisplayLayout layout, int pos) {
        DisplayType type = display.getDisplayType();
        double width = type.width;
        double height = type.height;
        double scale = type.scale;
        if (display instanceof IScaleableDisplay) {
            double[] scaling = ((IScaleableDisplay)((Object)display)).getScaling();
            width = scaling[0];
            height = scaling[1];
            scale = scaling[2];
        }
        switch (layout) {
            case DUAL: {
                return new double[]{0.0, pos == 1 ? height / 2.0 : 0.0, 0.0};
            }
            case GRID: {
                return new double[]{pos == 1 || pos == 3 ? width / 2.0 : 0.0, (double)pos > 1.0 ? height / 2.0 : 0.0, 0.0};
            }
            case LIST: {
                return new double[]{0.0, (double)pos * (height / 4.0), 0.0};
            }
        }
        return new double[]{0.0, 0.0, 0.0};
    }

    public static double[] getIntersect(IDisplay display, DisplayLayout layout, int pos) {
        DisplayType type = display.getDisplayType();
        double width = type.width;
        double height = type.height;
        double scale = type.scale;
        if (display instanceof IScaleableDisplay) {
            double[] scaling = ((IScaleableDisplay)((Object)display)).getScaling();
            width = scaling[0];
            height = scaling[1];
            scale = scaling[2];
        }
        switch (layout) {
            case DUAL: {
                return new double[]{0.0, pos == 1 ? type.height / 2.0 : 0.0, pos == 1 ? 1.0 : type.width / 2.0, pos == 1 ? 1.0 : type.height / 2.0};
            }
            case GRID: {
                return new double[]{pos == 1 || pos == 3 ? type.width / 2.0 : 0.0, pos == 1 || pos == 3 ? type.height / 2.0 : 0.0, pos == 1 || pos == 3 ? 1.0 : type.width / 2.0, pos == 1 || pos == 3 ? 1.0 : type.height / 2.0};
            }
            case LIST: {
                return new double[]{0.0, (double)pos * (type.height / 4.0), 0.0, (double)(pos + 1) * (type.height / 4.0)};
            }
        }
        return new double[]{0.0, 0.0, type.width, type.height};
    }

    public static boolean canBeClickedStandard(RenderInfoProperties renderInfo, EntityPlayer player, EnumHand hand, ItemStack stack, PartMOP hit) {
        if (renderInfo.container.getMaxCapacity() == 1) {
            return true;
        }
        IDisplay display = renderInfo.container.getDisplay();
        double[] intersect = InfoHelper.getIntersect(display, display.getLayout(), renderInfo.infoPos);
        BlockPos pos = hit.func_178782_a();
        double x = hit.field_72307_f.field_72450_a - (double)pos.func_177958_n();
        double y = hit.field_72307_f.field_72448_b - (double)pos.func_177956_o();
        return x >= intersect[0] && x <= intersect[2] && 1.0 - y >= intersect[1] && 1.0 - y <= intersect[3];
    }

    public static Pair<Integer, ItemInteractionType> getItemsToRemove(BlockInteractionType type) {
        switch (type) {
            case LEFT: {
                return new Pair((Object)1, (Object)ItemInteractionType.REMOVE);
            }
            case RIGHT: {
                return new Pair((Object)64, (Object)ItemInteractionType.ADD);
            }
            case SHIFT_LEFT: {
                return new Pair((Object)64, (Object)ItemInteractionType.REMOVE);
            }
        }
        return new Pair((Object)0, (Object)ItemInteractionType.ADD);
    }

    public static boolean hasInfoChanged(IInfo info, IInfo newInfo) {
        if (info == null && newInfo == null) {
            return false;
        }
        if (info == null && newInfo != null || info != null && newInfo == null) {
            return true;
        }
        return info.isMatchingType(newInfo) && info.isMatchingInfo(newInfo) && info.isIdenticalInfo(newInfo);
    }

    public static int getName(String name) {
        return PL2ASMLoader.infoIds.get(name);
    }

    public static Class<? extends IInfo> getInfoType(int id) {
        return PL2ASMLoader.infoClasses.get(PL2ASMLoader.infoNames.get(id));
    }

    public static NBTTagCompound writeInfoToNBT(NBTTagCompound tag, IInfo info, NBTHelper.SyncType type) {
        tag.func_74768_a("iiD", PL2ASMLoader.infoIds.get(info.getID()).intValue());
        info.writeData(tag, type);
        return tag;
    }

    public static IInfo readInfoFromNBT(NBTTagCompound tag) {
        return InfoHelper.loadInfo(tag.func_74762_e("iiD"), tag);
    }

    public static IInfo loadInfo(int id, NBTTagCompound tag) {
        return (IInfo)NBTHelper.instanceNBTSyncable(InfoHelper.getInfoType(id), (NBTTagCompound)tag);
    }

    public static INodeFilter readFilterFromNBT(NBTTagCompound tag) {
        return (INodeFilter)NBTHelper.instanceNBTSyncable(PL2ASMLoader.filterClasses.get(tag.func_74779_i("id")), (NBTTagCompound)tag);
    }

    public static NBTTagCompound writeFilterToNBT(NBTTagCompound tag, INodeFilter filter, NBTHelper.SyncType type) {
        tag.func_74778_a("id", filter.getNodeID());
        filter.writeData(tag, type);
        return tag;
    }

    public static enum ItemInteractionType {
        ADD,
        REMOVE;

    }
}

