/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.helpers;

import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;
import sonar.core.client.BlockModelsCache;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.RenderHelper;
import sonar.core.helpers.SonarHelper;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.INameableInfo;
import sonar.logistics.api.tiles.displays.DisplayType;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.info.types.LogicInfo;
import sonar.logistics.info.types.MonitoredBlockCoords;
import sonar.logistics.info.types.MonitoredItemStack;

public class InfoRenderer {
    public static final double zLevel = 0.0;
    public static final double barOffset = 0.001;
    public static final int[] rotate = new int[]{0, 0, 0, 180, 270, 90};
    public static final double[][] matrix = new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {1.0, 0.0, -1.0}, {1.0, 0.0, 0.0}, {0.0, 0.0, -1.0}};
    public static final double[][] downMatrix = new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {1.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {1.0, 1.0, 0.0}};
    public static final double[][] upMatrix = new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, -1.0}, {1.0, 1.0, -1.0}, {1.0, 0.0, -1.0}, {0.0, 1.0, -1.0}};
    public static int identifierLeft = 13;
    public static int objectLeft = 136;
    public static int kindLeft = 258;
    public static final double ITEM_SPACING = 22.7;
    public static final double FLUID_DIMENSION = 0.875;

    public static void renderNormalInfo(DisplayType type, String ... toDisplay) {
        InfoRenderer.renderNormalInfo(type, type.width, type.height, type.scale, SonarHelper.convertArray((Object[])toDisplay));
    }

    public static void renderNormalInfo(DisplayType type, List<String> toDisplay) {
        InfoRenderer.renderNormalInfo(type, type.width, type.height, type.scale, toDisplay);
    }

    public static double getYCentre(DisplayType type, double height) {
        return 0.12 * height * (0.12 * height) + 0.35 * height - 0.58;
    }

    public static void renderNormalInfo(DisplayType displayType, double width, double height, double scale, String ... toDisplay) {
        InfoRenderer.renderNormalInfo(displayType, width, height, scale, SonarHelper.convertArray((Object[])toDisplay));
    }

    public static void renderNormalInfo(DisplayType displayType, double width, double height, double scale, int colour, String ... toDisplay) {
        InfoRenderer.renderNormalInfo(displayType, width, height, scale, colour, SonarHelper.convertArray((Object[])toDisplay));
    }

    public static void renderNormalInfo(DisplayType displayType, double width, double height, double scale, List<String> toDisplay) {
        InfoRenderer.renderNormalInfo(displayType, width, height, scale, -1, toDisplay);
    }

    public static void renderNormalInfo(DisplayType displayType, double width, double height, double scale, int colour, List<String> toDisplay) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179089_o();
        float offset = (float)(12.0 / (1.0 / scale));
        double yCentre = 0.0;
        double centre = (double)toDisplay.size() / 2.0 - 0.5;
        int fontHeight = RenderHelper.fontRenderer.field_78288_b;
        for (int i = 0; i < toDisplay.size(); ++i) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.0, (double)(-1.0 + height / 2.0 + 0.26 + ((double)i == centre ? 0.0 : ((double)i < centre ? yCentre - (double)offset * -((double)i - centre) : yCentre + (double)offset * ((double)i - centre)))), (double)0.0);
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)1.0);
            String string = toDisplay.get(i);
            int length = RenderHelper.fontRenderer.func_78256_a(string);
            RenderHelper.fontRenderer.func_175065_a(string, (float)((-0.9375 + width / 2.0) / scale - (double)(length / 2)), 0.625f, colour, false);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179129_p();
        GlStateManager.func_179145_e();
    }

    public static void renderProgressBar(double width, double height, double scale, double d, double e) {
        GlStateManager.func_179132_a((boolean)true);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double minX = 0.0615;
        double minY = 0.0615;
        double maxX = width + 0.001 + 0.0625;
        double maxY = height + 0.001 + 0.0625;
        double barWidth = d * (maxX - minX) / e;
        double divide = Math.max(maxX - minX, maxY - minY);
        double minU = 0.0;
        double minV = 0.0;
        double maxU = 1.0;
        double maxV = 1.0;
        double widthnew = minU + barWidth * (maxU - minU) / 1.0;
        double heightnew = minV + (maxY - minY) * (maxV - minV) / 1.0;
        vertexbuffer.func_181662_b(minX + 0.0, maxY, 0.0).func_187315_a(minU, heightnew).func_181675_d();
        vertexbuffer.func_181662_b(minX + barWidth, maxY, 0.0).func_187315_a(widthnew, heightnew).func_181675_d();
        vertexbuffer.func_181662_b(minX + barWidth, minY + 0.0, 0.0).func_187315_a(widthnew, minV).func_181675_d();
        vertexbuffer.func_181662_b(minX + 0.0, minY + 0.0, 0.0).func_187315_a(minU, minV).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderProgressBarWithSprite(TextureAtlasSprite sprite, double width, double height, double scale, double progress, double maxProgress) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double minX = 0.0615;
        double minY = 0.0615;
        double maxX = width + 0.001 + 0.0625;
        double maxY = height + 0.001 + 0.0625;
        double barWidth = progress * (maxX - minX) / maxProgress;
        double divide = Math.max(maxX - minX, maxY - minY);
        double widthnew = (double)sprite.func_94209_e() + barWidth * (double)(sprite.func_94212_f() - sprite.func_94209_e()) / (maxX - minX);
        double heightnew = (double)sprite.func_94206_g() + (maxY - minY) * (double)(sprite.func_94210_h() - sprite.func_94206_g()) / (maxX - minX);
        vertexbuffer.func_181662_b(minX + 0.0, maxY, 0.0).func_187315_a((double)sprite.func_94209_e(), heightnew).func_181675_d();
        vertexbuffer.func_181662_b(minX + barWidth, maxY, 0.0).func_187315_a(widthnew, heightnew).func_181675_d();
        vertexbuffer.func_181662_b(minX + barWidth, minY + 0.0, 0.0).func_187315_a(widthnew, (double)sprite.func_94206_g()).func_181675_d();
        vertexbuffer.func_181662_b(minX + 0.0, minY + 0.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void rotateDisplayRendering(EnumFacing face, EnumFacing rotation, int width, int height) {
        double[] translate = matrix[face.ordinal()];
        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        switch (face) {
            case DOWN: {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                int ordinal = rotation.ordinal();
                ordinal = ordinal == 4 ? 5 : (ordinal == 5 ? 4 : ordinal);
                GL11.glRotated((double)rotate[ordinal], (double)0.0, (double)0.0, (double)1.0);
                translate = InfoRenderer.getDownMatrix(ordinal, width, height);
                break;
            }
            case UP: {
                GL11.glRotated((double)270.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)rotate[rotation.ordinal()], (double)0.0, (double)0.0, (double)1.0);
                translate = InfoRenderer.getUpMatrix(rotation.ordinal(), width, height);
                GL11.glTranslated((double)0.0, (double)0.0, (double)0.0);
                break;
            }
            default: {
                GL11.glRotated((double)rotate[face.ordinal()], (double)0.0, (double)1.0, (double)0.0);
            }
        }
        GL11.glTranslated((double)(translate[0] + 0.0625), (double)translate[1], (double)(translate[2] - 0.005));
    }

    public static double[] getDownMatrix(int i, int width, int height) {
        double[][] newMatrix = new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, width, 0.0}, {height, 0.0, 0.0}, {0.0, 0.0, 0.0}, {height, width, 0.0}};
        return newMatrix[i];
    }

    public static double[] getUpMatrix(int i, int width, int height) {
        double[][] newMatrix = new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, -1.0}, {1.0, 1.0, -1.0}, {1.0, 0.0, -1.0}, {0.0, 1.0, -1.0}};
        return newMatrix[i];
    }

    public static void renderMonitorInfoInGUI(IInfo info, int yPos, int colour) {
        if (info instanceof INameableInfo) {
            INameableInfo directInfo = (INameableInfo)info;
            if (!directInfo.isHeader() && directInfo.isValid()) {
                FontHelper.text((String)directInfo.getClientIdentifier(), (int)identifierLeft, (int)yPos, (int)colour);
                FontHelper.text((String)directInfo.getClientObject(), (int)objectLeft, (int)yPos, (int)colour);
                FontHelper.text((String)directInfo.getClientType(), (int)kindLeft, (int)yPos, (int)colour);
            } else if (directInfo instanceof LogicInfo) {
                String category = ((LogicInfo)directInfo).getRegistryType().name();
                FontHelper.text((String)(category.substring(0, 1) + category.substring(1).toLowerCase()), (int)(identifierLeft + 4), (int)yPos, (int)colour);
            }
        } else if (info instanceof MonitoredBlockCoords) {
            MonitoredBlockCoords directInfo = (MonitoredBlockCoords)info;
            FontHelper.text((String)directInfo.getCoords().toString(), (int)identifierLeft, (int)yPos, (int)colour);
        }
    }

    public static void renderInventory(MonitoredList<MonitoredItemStack> stacks, int start, int stop, int xSlots, int ySlots) {
        GlStateManager.func_179094_E();
        RenderHelper.saveBlendState();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)-0.91875, (double)-0.6875, (double)0.0);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)-0.022, (double)0.022, (double)0.01);
        RenderHelper.textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179094_E();
        for (int i = start; i < stop; ++i) {
            MonitoredItemStack stack = (MonitoredItemStack)stacks.get(i);
            int current = i - start;
            int xLevel = (int)((double)current - Math.floor(current / xSlots) * (double)xSlots);
            int yLevel = (int)Math.floor(current / xSlots);
            GlStateManager.func_179094_E();
            GL11.glTranslated((double)((double)xLevel * 22.7), (double)((double)yLevel * 22.7), (double)0.0);
            GlStateManager.func_179139_a((double)1.0, (double)1.0, (double)0.04);
            GlStateManager.func_179140_f();
            InfoRenderer.renderItemModelIntoGUI(stack.getItemStack(), 0, 0);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179118_c();
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179084_k();
        RenderHelper.textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179094_E();
        float scaleFactor = 0.5f;
        float inverseScaleFactor = 2.0f;
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        for (int i = start; i < stop; ++i) {
            MonitoredItemStack stack = (MonitoredItemStack)stacks.get(i);
            int current = i - start;
            int xLevel = (int)((double)current - Math.floor(current / xSlots) * (double)xSlots);
            int yLevel = (int)Math.floor(current / xSlots);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((double)xLevel * 22.7 * 2.0), (double)((double)yLevel * 22.7 * 2.0), (double)0.0);
            String s = "" + stack.getStored();
            int X = (int)((15.0f - (float)RenderHelper.fontRenderer.func_78256_a(s) * 0.5f) * 2.0f);
            int Y = 23;
            RenderHelper.fontRenderer.func_175063_a(s, (float)X, 23.0f, 0xFFFFFF);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)true);
        RenderHelper.restoreBlendState();
        GlStateManager.func_179121_F();
    }

    public static void renderItemModelIntoGUI(ItemStack stack, int x, int y) {
        InfoRenderer.renderItemModelIntoGUI(stack, x, y, BlockModelsCache.INSTANCE.getOrLoadModel(stack));
    }

    public static void renderItemModelIntoGUI(ItemStack stack, int x, int y, IBakedModel bakedmodel) {
        RenderHelper.textureManager.func_110577_a(TextureMap.field_110575_b);
        RenderHelper.setupGuiTransform((int)x, (int)y, (boolean)bakedmodel.func_177556_c());
        bakedmodel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedmodel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        RenderHelper.itemRender.func_180454_a(stack, bakedmodel);
    }
}

