/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.helpers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.SonarCore;
import sonar.core.api.SonarAPI;
import sonar.core.api.StorageSize;
import sonar.core.api.inventories.ISonarInventoryHandler;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.utils.ActionType;
import sonar.core.helpers.FluidHelper;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.InventoryHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.network.PacketInvUpdate;
import sonar.core.network.PacketStackUpdate;
import sonar.core.utils.Pair;
import sonar.core.utils.SortingDirection;
import sonar.logistics.api.PL2API;
import sonar.logistics.api.filters.ITransferFilteredTile;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.networks.ILogisticsNetwork;
import sonar.logistics.api.tiles.nodes.BlockConnection;
import sonar.logistics.api.tiles.nodes.EntityConnection;
import sonar.logistics.api.tiles.nodes.NodeConnection;
import sonar.logistics.api.tiles.nodes.NodeTransferMode;
import sonar.logistics.api.tiles.readers.IListReader;
import sonar.logistics.api.tiles.readers.IWirelessStorageReader;
import sonar.logistics.api.tiles.readers.InventoryReader;
import sonar.logistics.api.utils.CacheType;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.api.wrappers.ItemWrapper;
import sonar.logistics.connections.channels.ItemNetworkChannels;
import sonar.logistics.helpers.NetworkHelper;
import sonar.logistics.info.types.MonitoredItemStack;

public class ItemHelper
extends ItemWrapper {
    @Override
    public StoredItemStack transferItems(ILogisticsNetwork network, StoredItemStack add, NodeTransferMode mode, ActionType action, InventoryHelper.IInventoryFilter filter) {
        if (!ItemHelper.validStack(add)) {
            return add;
        }
        return NetworkHelper.forEachTileEntity(network, CacheType.ALL, c -> c.canTransferItem((NodeConnection)c, add, mode), this.getTileAction(add, mode, action, filter)) ? add : null;
    }

    private BiPredicate<BlockConnection, TileEntity> getTileAction(StoredItemStack stack, NodeTransferMode mode, ActionType action, InventoryHelper.IInventoryFilter filter) {
        return (c, t) -> stack.setStackSize(this.transfer(mode, (TileEntity)t, stack, c.face, action)).getStackSize() != 0L;
    }

    private StoredItemStack transfer(NodeTransferMode mode, TileEntity tile, StoredItemStack stack, EnumFacing dir, ActionType action) {
        List handlers = SonarCore.inventoryHandlers;
        for (ISonarInventoryHandler handler : handlers) {
            if (!handler.canHandleItems(tile, dir)) continue;
            StoredItemStack copy = stack.copy().setStackSize(stack);
            stack = mode.shouldRemove() ? handler.removeStack(copy, tile, dir, action) : handler.addStack(stack, tile, dir, action);
            return stack;
        }
        return null;
    }

    public static boolean validStack(StoredItemStack stack) {
        return stack != null && stack.getStackSize() != 0L;
    }

    @Override
    public StorageSize getTileInventory(List<StoredItemStack> storedStacks, StorageSize storage, List<BlockConnection> connections) {
        for (BlockConnection entry : connections) {
            storage = this.getTileInventory(storedStacks, storage, entry);
        }
        return storage;
    }

    public StorageSize getTileInventory(List<StoredItemStack> storedStacks, StorageSize storage, BlockConnection entry) {
        TileEntity tile = entry.coords.getTileEntity();
        if (tile == null) {
            return storage;
        }
        boolean specialProvider = false;
        for (ISonarInventoryHandler provider : SonarCore.inventoryHandlers) {
            StorageSize size;
            if (!provider.canHandleItems(tile, entry.face) || specialProvider || (size = provider.getItems(storedStacks, tile, entry.face)) == StorageSize.EMPTY) continue;
            specialProvider = true;
            storage.add(size);
        }
        return storage;
    }

    @Override
    public StorageSize getEntityInventory(List<StoredItemStack> storedStacks, StorageSize storage, List<Entity> entityList) {
        for (Entity entity : entityList) {
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)entity;
            StorageSize size = SonarAPI.getItemHelper().addInventoryToList(storedStacks, (IInventory)player.field_71071_by);
            storage.add(size);
        }
        return storage;
    }

    @Override
    public long getItemCount(ItemStack stack, ILogisticsNetwork network) {
        if (network.isValid()) {
            ItemNetworkChannels channels = network.getNetworkChannels(ItemNetworkChannels.class);
            channels.updateLargeInventory = true;
            channels.updateAllChannels();
            channels.updateLargeInventory = false;
            MonitoredList updateList = MonitoredList.newMonitoredList(network.getNetworkID());
            for (Map.Entry entry : channels.channels.entrySet()) {
                if (entry.getValue() == null || ((MonitoredList)entry.getValue()).isEmpty()) continue;
                for (MonitoredItemStack coordInfo : (MonitoredList)entry.getValue()) {
                    updateList.addInfoToList(coordInfo.copy(), (MonitoredList)entry.getValue());
                }
            }
            Pair<Boolean, IInfo> stored = updateList.getLatestInfo(new MonitoredItemStack(new StoredItemStack(stack).setStackSize(1L)));
            if (((Boolean)stored.a).booleanValue()) {
                return ((MonitoredItemStack)stored.b).getStored();
            }
        }
        return 0L;
    }

    public void addItemsFromPlayer(StoredItemStack add, EntityPlayer player, ILogisticsNetwork network, ActionType action, InventoryHelper.IInventoryFilter filter) {
        InventoryPlayer inv = player.field_71071_by;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            StoredItemStack perform;
            StoredItemStack toAdd;
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || stack.field_77994_a == 0 || !add.equalStack(stack) || (toAdd = new StoredItemStack(stack.func_77946_l())).equals((Object)(perform = this.transferItems(network, toAdd.copy(), NodeTransferMode.ADD, ActionType.PERFORM, filter)))) continue;
            inv.func_70299_a(i, StoredItemStack.getActualStack((StoredItemStack)perform));
            inv.func_70296_d();
        }
    }

    public static StoredItemStack getEntityStack(EntityConnection connection, int slot) {
        if (connection.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)connection.entity;
            InventoryPlayer inv = player.field_71071_by;
            if (slot < inv.func_70302_i_()) {
                ItemStack stack = inv.func_70301_a(slot);
                if (stack == null) {
                    return null;
                }
                return new StoredItemStack(stack);
            }
        }
        return null;
    }

    public static StoredItemStack getTileStack(BlockConnection connection, int slot) {
        for (ISonarInventoryHandler provider : SonarCore.inventoryHandlers) {
            TileEntity tile = connection.coords.getTileEntity();
            if (tile == null || !provider.canHandleItems(tile, connection.face)) continue;
            return provider.getStack(slot, tile, connection.face);
        }
        return null;
    }

    @Override
    public StoredItemStack addStackToPlayer(StoredItemStack add, EntityPlayer player, boolean enderChest, ActionType action) {
        if (add == null) {
            return null;
        }
        InventoryPlayer inv = null;
        int size = 0;
        if (!enderChest) {
            inv = player.field_71071_by;
            size = player.field_71071_by.field_70462_a.length;
        } else {
            inv = player.func_71005_bN();
            size = inv.func_70302_i_();
        }
        if (inv == null || size == 0) {
            return add;
        }
        ArrayList empty = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack != null) {
                if (stack.field_77994_a >= stack.func_77976_d() || !add.equalStack(stack) || stack.field_77994_a >= inv.func_70297_j_()) continue;
                long used = Math.min((long)add.item.func_77976_d(), Math.min(add.stored, (long)(inv.func_70297_j_() - stack.field_77994_a)));
                stack.field_77994_a = (int)((long)stack.field_77994_a + used);
                add.stored -= used;
                if (used != 0L && !action.shouldSimulate()) {
                    inv.func_70299_a(i, stack);
                    if (!enderChest) {
                        SonarCore.network.sendTo((IMessage)new PacketInvUpdate(i, stack), (EntityPlayerMP)player);
                    }
                }
                if (add.stored != 0L) continue;
                return null;
            }
            empty.add(i);
        }
        for (Integer slot : empty) {
            int used;
            ItemStack stack = add.item.func_77946_l();
            if (!inv.func_94041_b(slot.intValue(), stack)) continue;
            stack.field_77994_a = used = (int)Math.min(add.stored, (long)inv.func_70297_j_());
            add.stored -= (long)used;
            if (!action.shouldSimulate()) {
                inv.func_70299_a(slot.intValue(), stack);
                if (!enderChest) {
                    SonarCore.network.sendTo((IMessage)new PacketInvUpdate(slot.intValue(), stack), (EntityPlayerMP)player);
                }
            }
            if (add.stored != 0L) continue;
            return null;
        }
        return add;
    }

    @Override
    public StoredItemStack removeStackFromPlayer(StoredItemStack remove, EntityPlayer player, boolean enderChest, ActionType action) {
        if (remove == null) {
            return null;
        }
        InventoryPlayer inv = null;
        int size = 0;
        inv = !enderChest ? player.field_71071_by : player.func_71005_bN();
        int n = size = !enderChest ? player.field_71071_by.field_70462_a.length : inv.func_70302_i_();
        if (inv == null || size == 0) {
            return remove;
        }
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || !remove.equalStack(stack)) continue;
            stack = stack.func_77946_l();
            long used = Math.min(remove.stored, (long)Math.min(inv.func_70297_j_(), stack.field_77994_a));
            stack.field_77994_a = (int)((long)stack.field_77994_a - used);
            remove.stored -= used;
            if (!action.shouldSimulate()) {
                if (stack.field_77994_a == 0) {
                    stack = null;
                }
                inv.func_70299_a(i, stack);
            }
            if (remove.stored != 0L) continue;
            return null;
        }
        return remove;
    }

    @Override
    public StoredItemStack removeToPlayerInventory(StoredItemStack stack, long extractSize, ILogisticsNetwork network, EntityPlayer player, ActionType type) {
        StoredItemStack simulate = SonarAPI.getItemHelper().getStackToAdd(extractSize, stack, this.transferItems(network, stack.copy().setStackSize(extractSize), NodeTransferMode.REMOVE, type, null));
        if (simulate == null) {
            return null;
        }
        StoredItemStack returned = SonarAPI.getItemHelper().getStackToAdd(stack.stored, simulate, this.addStackToPlayer(simulate.copy(), player, false, type));
        return returned;
    }

    @Override
    public StoredItemStack addFromPlayerInventory(StoredItemStack stack, long extractSize, ILogisticsNetwork network, EntityPlayer player, ActionType type) {
        StoredItemStack simulate = SonarAPI.getItemHelper().getStackToAdd(extractSize, stack, this.removeStackFromPlayer(stack.copy().setStackSize(extractSize), player, false, type));
        if (simulate == null) {
            return null;
        }
        StoredItemStack returned = SonarAPI.getItemHelper().getStackToAdd(stack.stored, simulate, this.transferItems(network, simulate.copy(), NodeTransferMode.ADD, type, null));
        return returned;
    }

    @Override
    public StoredItemStack extractItem(ILogisticsNetwork cache, StoredItemStack stack) {
        if (stack != null && stack.stored != 0L) {
            StoredItemStack extract = this.transferItems(cache, stack.copy(), NodeTransferMode.REMOVE, ActionType.PERFORM, null);
            StoredItemStack toAdd = SonarAPI.getItemHelper().getStackToAdd(stack.getStackSize(), stack, extract);
            return toAdd;
        }
        return null;
    }

    @Override
    public long insertInventoryFromPlayer(EntityPlayer player, ILogisticsNetwork cache, int slotID) {
        ItemStack add = null;
        add = slotID == -1 ? player.field_71071_by.func_70445_o() : player.field_71071_by.func_70301_a(slotID);
        if (add == null) {
            return 0L;
        }
        StoredItemStack stack = new StoredItemStack(add).setStackSize(0L);
        InventoryPlayer inv = player.field_71071_by;
        ArrayList slots = Lists.newArrayList();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack item = inv.func_70301_a(i);
            if (!stack.equalStack(item)) continue;
            stack.add(item);
            slots.add(i);
        }
        StoredItemStack remainder = this.transferItems(cache, stack.copy(), NodeTransferMode.ADD, ActionType.PERFORM, null);
        StoredItemStack toAdd = SonarAPI.getItemHelper().getStackToAdd(stack.getStackSize(), stack, remainder);
        PL2API.getItemHelper().removeStackFromPlayer(toAdd.copy(), player, false, ActionType.PERFORM);
        return toAdd.getStackSize();
    }

    @Override
    public long insertItemFromPlayer(EntityPlayer player, ILogisticsNetwork cache, int slot) {
        ItemStack add = player.field_71071_by.func_70301_a(slot);
        if (add == null) {
            return 0L;
        }
        int original = add.field_77994_a;
        StoredItemStack stack = this.transferItems(cache, new StoredItemStack(add), NodeTransferMode.ADD, ActionType.PERFORM, null);
        ItemStack returned = StoredItemStack.getActualStack((StoredItemStack)stack);
        if (!ItemStack.func_77989_b((ItemStack)returned, (ItemStack)player.field_71071_by.func_70301_a(slot))) {
            player.field_71071_by.func_70299_a(slot, returned);
            return returned == null ? original : original - returned.field_77994_a;
        }
        FontHelper.sendMessage((String)(TextFormatting.BLUE + "Logistics: " + TextFormatting.RESET + "The item cannot be inserted"), (World)player.func_130014_f_(), (EntityPlayer)player);
        return 0L;
    }

    @Override
    public boolean dumpInventoryFromPlayer(EntityPlayer player, ILogisticsNetwork cache) {
        boolean change = false;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack add = player.field_71071_by.func_70301_a(i);
            if (add == null || add.func_77973_b() instanceof IWirelessStorageReader) continue;
            StoredItemStack stack = this.transferItems(cache, new StoredItemStack(add), NodeTransferMode.ADD, ActionType.PERFORM, null);
            if (stack == null || stack.stored == 0L) {
                add = null;
            } else {
                add.field_77994_a = (int)stack.stored;
            }
            if (ItemStack.func_77989_b((ItemStack)add, (ItemStack)player.field_71071_by.func_70301_a(i))) continue;
            change = true;
            player.field_71071_by.func_70299_a(i, add);
        }
        return change;
    }

    @Override
    public void dumpNetworkToPlayer(MonitoredList<MonitoredItemStack> items, EntityPlayer player, ILogisticsNetwork cache) {
        for (MonitoredItemStack stack : items) {
            StoredItemStack returned = this.removeToPlayerInventory(stack.getStoredStack(), stack.getStored(), cache, player, ActionType.SIMULATE);
            if (returned == null) continue;
            this.removeToPlayerInventory(stack.getStoredStack(), returned.stored, cache, player, ActionType.PERFORM);
        }
    }

    public static void transferItems(NodeTransferMode mode, BlockConnection filter, BlockConnection connection, InventoryHelper.ITransferOverride override) {
        TileEntity filterTile = filter.coords.getTileEntity();
        TileEntity netTile = connection.coords.getTileEntity();
        if (filterTile != null && netTile != null) {
            EnumFacing dirFrom = mode.shouldRemove() ? filter.face : connection.face;
            EnumFacing dirTo = !mode.shouldRemove() ? filter.face : connection.face;
            TileEntity from = mode.shouldRemove() ? filterTile : netTile;
            TileEntity to = !mode.shouldRemove() ? filterTile : netTile;
            ConnectionFilters filters = new ConnectionFilters(override, filter, connection);
            SonarAPI.getItemHelper().transferItems(from, to, dirFrom.func_176734_d(), dirTo.func_176734_d(), (InventoryHelper.IInventoryFilter)filters);
        }
    }

    public static void onNetworkItemInteraction(IListReader reader, ILogisticsNetwork network, MonitoredList<MonitoredItemStack> items, EntityPlayer player, ItemStack selected, int button) {
        if (button == 3) {
            PL2API.getItemHelper().dumpInventoryFromPlayer(player, network);
        } else if (button == 4) {
            PL2API.getItemHelper().dumpNetworkToPlayer(items, player, network);
        } else if (button == 2) {
            if (selected == null) {
                return;
            }
            PL2API.getItemHelper().removeToPlayerInventory(new StoredItemStack(selected), 64L, network, player, ActionType.PERFORM);
        } else if (player.field_71071_by.func_70445_o() != null) {
            StoredItemStack add = new StoredItemStack(player.field_71071_by.func_70445_o().func_77946_l());
            int stackSize = Math.min(button == 1 ? 1 : 64, add.getValidStackSize());
            StoredItemStack stack = PL2API.getItemHelper().transferItems(network, add.copy().setStackSize((long)stackSize), NodeTransferMode.ADD, ActionType.PERFORM, null);
            StoredItemStack remove = SonarAPI.getItemHelper().getStackToAdd((long)stackSize, add, stack);
            ItemStack actualStack = add.copy().setStackSize(add.stored - SonarAPI.getItemHelper().getStackToAdd((long)((long)stackSize), (StoredItemStack)add, (StoredItemStack)stack).stored).getActualStack();
            if (actualStack == null || (long)actualStack.field_77994_a != add.stored && actualStack.field_77994_a > 0 && !ItemStack.func_77989_b((ItemStack)StoredItemStack.getActualStack((StoredItemStack)stack), (ItemStack)player.field_71071_by.func_70445_o())) {
                player.field_71071_by.func_70437_b(actualStack);
                SonarCore.network.sendTo((IMessage)new PacketStackUpdate(actualStack), (EntityPlayerMP)player);
            }
        } else if (player.field_71071_by.func_70445_o() == null) {
            if (selected == null) {
                return;
            }
            ItemStack stack = selected;
            StoredItemStack toAdd = new StoredItemStack(stack.func_77946_l()).setStackSize((long)Math.min(stack.func_77976_d(), 64));
            StoredItemStack removed = PL2API.getItemHelper().transferItems(network, toAdd.copy(), NodeTransferMode.REMOVE, ActionType.SIMULATE, null);
            StoredItemStack simulate = SonarAPI.getItemHelper().getStackToAdd(toAdd.stored, toAdd, removed);
            if (simulate != null && simulate.stored != 0L) {
                StoredItemStack storedStack;
                if (button == 1 && simulate.stored != 1L) {
                    simulate.setStackSize((long)Math.ceil(simulate.getStackSize() / 2L));
                }
                if ((storedStack = SonarAPI.getItemHelper().getStackToAdd(simulate.stored, simulate, PL2API.getItemHelper().transferItems(network, simulate.copy(), NodeTransferMode.REMOVE, ActionType.PERFORM, null))) != null && storedStack.stored != 0L) {
                    player.field_71071_by.func_70437_b(storedStack.getFullStack());
                    SonarCore.network.sendTo((IMessage)new PacketStackUpdate(storedStack.getFullStack()), (EntityPlayerMP)player);
                }
            }
        }
        ItemNetworkChannels channels = network.getNetworkChannels(ItemNetworkChannels.class);
        if (channels != null) {
            channels.sendLocalRapidUpdate(reader, player);
        }
    }

    public static void sortItemList(List<MonitoredItemStack> info, final SortingDirection dir, InventoryReader.SortingType type) {
        info.sort(new Comparator<MonitoredItemStack>(){

            @Override
            public int compare(MonitoredItemStack str1, MonitoredItemStack str2) {
                StoredItemStack item1 = str1.getStoredStack();
                StoredItemStack item2 = str2.getStoredStack();
                return SonarHelper.compareStringsWithDirection((String)item1.getItemStack().func_82833_r(), (String)item2.getItemStack().func_82833_r(), (SortingDirection)dir);
            }
        });
        switch (type) {
            case STORED: {
                info.sort(new Comparator<MonitoredItemStack>(){

                    @Override
                    public int compare(MonitoredItemStack str1, MonitoredItemStack str2) {
                        StoredItemStack item1 = str1.getStoredStack();
                        StoredItemStack item2 = str2.getStoredStack();
                        return SonarHelper.compareWithDirection((long)item1.stored, (long)item2.stored, (SortingDirection)dir);
                    }
                });
                break;
            }
            case MODID: {
                info.sort(new Comparator<MonitoredItemStack>(){

                    @Override
                    public int compare(MonitoredItemStack str1, MonitoredItemStack str2) {
                        StoredItemStack item1 = str1.getStoredStack();
                        StoredItemStack item2 = str2.getStoredStack();
                        String modid1 = item1.getItemStack().func_77973_b().getRegistryName().func_110624_b();
                        String modid2 = item2.getItemStack().func_77973_b().getRegistryName().func_110624_b();
                        return SonarHelper.compareStringsWithDirection((String)modid1, (String)modid2, (SortingDirection)dir);
                    }
                });
            }
        }
    }

    public static class ConnectionFilters
    implements InventoryHelper.IInventoryFilter,
    FluidHelper.ITankFilter,
    InventoryHelper.ITransferOverride {
        InventoryHelper.ITransferOverride override;
        NodeConnection[] connections;

        public ConnectionFilters(InventoryHelper.ITransferOverride override, NodeConnection ... connections) {
            this.override = override;
            this.connections = connections;
        }

        public boolean allowed(ItemStack stack) {
            for (NodeConnection connection : this.connections) {
                ITransferFilteredTile tile;
                if (!connection.isFiltered || (tile = (ITransferFilteredTile)connection.source).allowed(stack)) continue;
                return false;
            }
            return true;
        }

        public boolean allowed(FluidStack stack) {
            for (NodeConnection connection : this.connections) {
                ITransferFilteredTile tile;
                if (!connection.isFiltered || (tile = (ITransferFilteredTile)connection.source).allowed(stack)) continue;
                return false;
            }
            return true;
        }

        public void reset() {
            this.override.reset();
        }

        public void add(long added) {
            this.override.add(added);
        }

        public void remove(long removed) {
            this.override.remove(removed);
        }

        public long getMaxRemove() {
            return this.override.getMaxRemove();
        }

        public long getMaxAdd() {
            return this.override.getMaxAdd();
        }

        public InventoryHelper.ITransferOverride copy() {
            return new ConnectionFilters(this.override.copy(), this.connections);
        }
    }
}

