/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.helpers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mcmultipart.multipart.ISlottedPart;
import mcmultipart.multipart.PartSlot;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import sonar.core.listener.ISonarListener;
import sonar.logistics.PL2;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.info.render.IInfoContainer;
import sonar.logistics.api.networks.ILogisticsNetwork;
import sonar.logistics.api.operator.IOperatorTool;
import sonar.logistics.api.tiles.INetworkTile;
import sonar.logistics.api.tiles.displays.IDisplay;
import sonar.logistics.api.tiles.nodes.BlockConnection;
import sonar.logistics.api.tiles.nodes.EntityConnection;
import sonar.logistics.api.tiles.nodes.INode;
import sonar.logistics.api.tiles.nodes.NodeConnection;
import sonar.logistics.api.tiles.readers.IInfoProvider;
import sonar.logistics.api.viewers.ILogicListenable;
import sonar.logistics.api.wireless.IDataReceiver;
import sonar.logistics.api.wireless.IEntityTransceiver;
import sonar.logistics.api.wireless.ITileTransceiver;
import sonar.logistics.common.multiparts.AbstractDisplayPart;
import sonar.logistics.connections.CacheHandler;
import sonar.logistics.helpers.CableHelper;

public class LogisticsHelper {
    public static boolean isPlayerUsingOperator(EntityPlayer player) {
        if (player.func_184614_ca() != null) {
            return player.func_184614_ca().func_77973_b() instanceof IOperatorTool;
        }
        return false;
    }

    public static List<ILogisticsNetwork> getNetworks(List<Integer> ids) {
        ArrayList networks = Lists.newArrayList();
        ids.forEach(id -> {
            ILogisticsNetwork network = PL2.getNetworkManager().getNetwork((int)id);
            if (network != null && network.isValid()) {
                networks.add(network);
            }
        });
        return networks;
    }

    public static Map<CacheHandler, List> getCachesMap() {
        HashMap connections = Maps.newHashMap();
        CacheHandler.handlers.forEach(classType -> {
            List cfr_ignored_0 = connections.put(classType, Lists.newArrayList());
        });
        return connections;
    }

    public static <T> T getChannelInstance(Class<T> channelType, ILogisticsNetwork network) {
        try {
            return channelType.getConstructor(ILogisticsNetwork.class).newInstance(network);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static NodeConnection getTransceiverNode(INetworkTile source, ItemStack stack) {
        IEntityTransceiver trans;
        UUID uuid;
        if (stack.func_77973_b() instanceof ITileTransceiver) {
            ITileTransceiver trans2 = (ITileTransceiver)stack.func_77973_b();
            return new BlockConnection(source, trans2.getCoords(stack), trans2.getDirection(stack));
        }
        if (stack.func_77973_b() instanceof IEntityTransceiver && (uuid = (trans = (IEntityTransceiver)stack.func_77973_b()).getEntityUUID(stack)) != null) {
            for (Entity entity : source.getCoords().getWorld().func_72910_y()) {
                if (!entity.getPersistentID().equals(uuid)) continue;
                return new EntityConnection(source, entity);
            }
        }
        return null;
    }

    public List<InfoUUID> getConnectedUUIDS(List<IDisplay> displays) {
        ArrayList ids = Lists.newArrayList();
        for (IDisplay display : displays) {
            IInfoContainer container = display.container();
            container.forEachValidUUID(id -> {
                if (!ids.contains(id)) {
                    ids.add(id);
                }
            });
        }
        return ids;
    }

    public List<IInfo> getInfoFromUUIDs(List<InfoUUID> ids) {
        ArrayList infoList = Lists.newArrayList();
        for (InfoUUID id : ids) {
            IInfo info;
            ILogicListenable monitor = CableHelper.getMonitorFromIdentity(id.getIdentity(), false);
            if (monitor == null || !(monitor instanceof IInfoProvider) || (info = ((IInfoProvider)monitor).getMonitorInfo(id.channelID)) == null) continue;
            infoList.add(info);
        }
        return infoList;
    }

    public static List<ILogicListenable> getLocalProviders(List<ILogicListenable> viewables, AbstractDisplayPart part) {
        ILogisticsNetwork networkCache = part.getNetwork();
        ISlottedPart connectedPart = part.getContainer().getPartInSlot(PartSlot.getFaceSlot((EnumFacing)part.face));
        if (connectedPart != null && connectedPart instanceof IInfoProvider) {
            if (!viewables.contains((IInfoProvider)connectedPart)) {
                viewables.add((IInfoProvider)connectedPart);
            }
        } else {
            for (IInfoProvider monitor : networkCache.getLocalInfoProviders()) {
                if (viewables.contains(monitor)) continue;
                viewables.add(monitor);
            }
        }
        return viewables;
    }

    public static void addConnectedNetworks(ILogisticsNetwork main, IDataReceiver receiver) {
        List<Integer> connected = receiver.getConnectedNetworks();
        connected.iterator().forEachRemaining(networkID -> {
            ILogisticsNetwork sub = PL2.getNetworkManager().getNetwork((int)networkID);
            if (sub.getNetworkID() != main.getNetworkID() && sub.isValid()) {
                sub.getListenerList().addListener((ISonarListener)main, new int[]{1});
            }
        });
    }

    public static List<NodeConnection> sortNodeConnections(List<NodeConnection> channels, List<INode> nodes) {
        nodes.stream().filter(n -> n.isValid()).forEach(n -> n.addConnections(channels));
        return NodeConnection.sortConnections(channels);
    }
}

