/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.helpers;

import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.tileentity.TileEntity;
import sonar.logistics.api.networks.ILogisticsNetwork;
import sonar.logistics.api.tiles.nodes.BlockConnection;
import sonar.logistics.api.tiles.nodes.NodeConnection;
import sonar.logistics.api.utils.CacheType;

public class NetworkHelper {
    public static boolean forEachTileEntity(ILogisticsNetwork network, CacheType type, Predicate<NodeConnection> canUse, BiPredicate<BlockConnection, TileEntity> canContinue) {
        List<NodeConnection> connections = network.getConnections(type);
        for (NodeConnection entry : connections) {
            boolean bool;
            if (!canUse.test(entry) || !(entry instanceof BlockConnection)) continue;
            BlockConnection connection = (BlockConnection)entry;
            TileEntity tile = connection.coords.getTileEntity();
            if (tile == null || (bool = canContinue.test(connection, tile))) continue;
            return false;
        }
        return true;
    }
}

