/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.helpers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.helpers.NBTHelper;
import sonar.core.listener.ListenableList;
import sonar.core.listener.PlayerListener;
import sonar.logistics.PL2;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.tiles.displays.ConnectedDisplay;
import sonar.logistics.api.tiles.displays.ILargeDisplay;
import sonar.logistics.api.tiles.readers.ClientLocalProvider;
import sonar.logistics.api.tiles.readers.IInfoProvider;
import sonar.logistics.api.tiles.readers.INetworkReader;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.api.viewers.ILogicListenable;
import sonar.logistics.api.viewers.ListenerType;
import sonar.logistics.common.multiparts.AbstractDisplayPart;
import sonar.logistics.common.multiparts.LogisticsPart;
import sonar.logistics.helpers.InfoHelper;
import sonar.logistics.helpers.LogisticsHelper;
import sonar.logistics.managers.WirelessManager;
import sonar.logistics.network.PacketClientEmitters;
import sonar.logistics.network.PacketInfoUpdates;
import sonar.logistics.network.PacketLocalProviders;
import sonar.logistics.network.PacketMonitoredList;

public class PacketHelper {
    public static void sendLocalProvidersFromScreen(AbstractDisplayPart part, EntityPlayer player) {
        List<ILogicListenable> providers = new ArrayList<ILogicListenable>();
        int identity = part.getIdentity();
        if (part instanceof ILargeDisplay) {
            ConnectedDisplay display = ((ILargeDisplay)((Object)part)).getDisplayScreen();
            if (display != null && display.getTopLeftScreen() != null) {
                identity = ((AbstractDisplayPart)((Object)display.getTopLeftScreen())).getIdentity();
            }
            providers = display != null ? display.getLocalProviders(providers) : LogisticsHelper.getLocalProviders(providers, part);
        } else {
            providers = LogisticsHelper.getLocalProviders(providers, part);
        }
        ArrayList clientMonitors = Lists.newArrayList();
        providers.forEach(provider -> {
            provider.getListenerList().addListener(player, new Enum[]{ListenerType.TEMPORARY});
            clientMonitors.add(new ClientLocalProvider((ILogicListenable)provider));
        });
        PL2.network.sendTo((IMessage)new PacketLocalProviders(clientMonitors, identity), (EntityPlayerMP)player);
    }

    public static void sendLocalProviders(LogisticsPart part, int identity, EntityPlayer player) {
        List<IInfoProvider> providers = part.getNetwork().getLocalInfoProviders();
        ArrayList clientProviders = Lists.newArrayList();
        providers.forEach(provider -> {
            provider.getListenerList().addListener(player, new Enum[]{ListenerType.TEMPORARY});
            clientProviders.add(new ClientLocalProvider((ILogicListenable)provider));
        });
        PL2.network.sendTo((IMessage)new PacketLocalProviders(clientProviders, identity), (EntityPlayerMP)player);
    }

    public static void addInfoUpdatesToList(Map<PlayerListener, NBTTagList> listenerPackets, List<PlayerListener> listeners, NBTTagCompound updateTag, NBTTagCompound saveTag, boolean fullPacket) {
        for (PlayerListener listener : listeners) {
            NBTTagList list = listenerPackets.get(listener);
            if (list == null) {
                listenerPackets.put(listener, new NBTTagList());
                list = listenerPackets.get(listener);
            }
            list.func_74742_a((NBTBase)(fullPacket ? saveTag.func_74737_b() : updateTag.func_74737_b()));
        }
    }

    public static void sendInfoUpdatePacket(PlayerListener listener, NBTTagList list, NBTHelper.SyncType type) {
        if (list.func_82582_d()) {
            return;
        }
        NBTTagCompound packetTag = new NBTTagCompound();
        packetTag.func_74782_a("infoList", (NBTBase)list);
        PL2.network.sendTo((IMessage)new PacketInfoUpdates(packetTag, type), listener.player);
    }

    public static void receiveInfoUpdate(NBTTagCompound packetTag, NBTHelper.SyncType type) {
        NBTTagList packetList = packetTag.func_150295_c("infoList", 10);
        boolean save = type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE});
        for (int i = 0; i < packetList.func_74745_c(); ++i) {
            NBTTagCompound infoTag = packetList.func_150305_b(i);
            InfoUUID id = (InfoUUID)NBTHelper.instanceNBTSyncable(InfoUUID.class, (NBTTagCompound)infoTag);
            if (save) {
                PL2.getClientManager().setInfo(id, InfoHelper.readInfoFromNBT(infoTag));
                continue;
            }
            IInfo currentInfo = PL2.getClientManager().getInfoFromUUID(id);
            if (currentInfo == null) continue;
            currentInfo.readData(infoTag, type);
            PL2.getClientManager().setInfo(id, currentInfo);
        }
    }

    public static void sendDataEmittersToPlayer(EntityPlayer player) {
        PL2.network.sendTo((IMessage)new PacketClientEmitters(WirelessManager.getClientEmitters(player)), (EntityPlayerMP)player);
    }

    public static void sendNormalProviderInfo(IInfoProvider monitor) {
        PacketHelper.sendReaderToListeners(monitor, null, null, new InfoUUID(monitor.getIdentity(), 0));
    }

    public static void sendReaderFullInfo(List<PlayerListener> listeners, ILogicListenable monitor, MonitoredList saveList, InfoUUID uuid) {
        NBTTagCompound saveTag;
        NBTTagCompound nBTTagCompound = saveTag = saveList != null ? InfoHelper.writeMonitoredList(new NBTTagCompound(), true, saveList, NBTHelper.SyncType.DEFAULT_SYNC) : null;
        if (saveTag.func_82582_d()) {
            return;
        }
        listeners.forEach(listener -> PL2.network.sendTo((IMessage)new PacketMonitoredList(monitor.getIdentity(), uuid, monitor.getNetworkID(), saveTag, NBTHelper.SyncType.DEFAULT_SYNC), listener.player));
    }

    public static void sendReaderToListeners(ILogicListenable reader, MonitoredList saveList, MonitoredList lastList, InfoUUID uuid) {
        ListenableList list = reader.getListenerList();
        block5: for (ListenerType type : ListenerType.ALL) {
            List tallies = list.getTallies(new Enum[]{type});
            if (tallies.isEmpty()) continue;
            switch (type) {
                case FULL_INFO: {
                    NBTTagCompound saveTag;
                    if (saveList == null || (saveTag = InfoHelper.writeMonitoredList(new NBTTagCompound(), true, saveList, NBTHelper.SyncType.DEFAULT_SYNC)) == null || saveTag.func_82582_d()) continue block5;
                    tallies.forEach(tally -> {
                        PL2.network.sendTo((IMessage)new PacketMonitoredList(reader.getIdentity(), uuid, reader.getNetworkID(), saveTag, NBTHelper.SyncType.DEFAULT_SYNC), ((PlayerListener)tally.listener).player);
                        tally.removeTallies(1, new Enum[]{ListenerType.FULL_INFO});
                        tally.addTallies(1, new Enum[]{ListenerType.INFO});
                        tally.source.updateState();
                    });
                    list.updateState();
                    continue block5;
                }
                case INFO: {
                    NBTTagCompound tag;
                    if (saveList == null || (tag = InfoHelper.writeMonitoredList(new NBTTagCompound(), lastList.isEmpty(), saveList, NBTHelper.SyncType.SPECIAL)).func_82582_d() || saveList.changed.isEmpty() && saveList.removed.isEmpty()) continue block5;
                    tallies.forEach(tally -> PL2.network.sendTo((IMessage)new PacketMonitoredList(reader.getIdentity(), uuid, reader.getNetworkID(), tag, NBTHelper.SyncType.SPECIAL), ((PlayerListener)tally.listener).player));
                    continue block5;
                }
                case TEMPORARY: {
                    if (saveList == null) continue block5;
                    NBTTagCompound saveTag = InfoHelper.writeMonitoredList(new NBTTagCompound(), lastList.isEmpty(), saveList, NBTHelper.SyncType.DEFAULT_SYNC);
                    NBTTagList tagList = new NBTTagList();
                    if (reader instanceof INetworkReader) {
                        INetworkReader r = (INetworkReader)reader;
                        for (int i = 0; i < r.getMaxInfo(); ++i) {
                            InfoUUID infoID = new InfoUUID(reader.getIdentity(), i);
                            IInfo info = PL2.getServerManager().getInfoFromUUID(infoID);
                            if (info == null) continue;
                            NBTTagCompound nbt = InfoHelper.writeInfoToNBT(new NBTTagCompound(), info, NBTHelper.SyncType.SAVE);
                            nbt = infoID.writeData(nbt, NBTHelper.SyncType.SAVE);
                            tagList.func_74742_a((NBTBase)nbt);
                        }
                    }
                    tallies.forEach(tally -> {
                        PL2.network.sendTo((IMessage)new PacketMonitoredList(reader.getIdentity(), uuid, saveList.networkID, saveTag, NBTHelper.SyncType.DEFAULT_SYNC), ((PlayerListener)tally.listener).player);
                        tally.removeTallies(1, new Enum[]{ListenerType.TEMPORARY});
                        PacketHelper.sendInfoUpdatePacket((PlayerListener)tally.listener, tagList, NBTHelper.SyncType.SAVE);
                    });
                    continue block5;
                }
            }
        }
    }
}

