/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Loader;
import sonar.core.utils.Pair;
import sonar.logistics.PL2;
import sonar.logistics.api.info.IProvidableInfo;
import sonar.logistics.api.info.handlers.IEntityInfoProvider;
import sonar.logistics.api.info.handlers.ITileInfoProvider;
import sonar.logistics.api.info.register.IInfoRegistry;
import sonar.logistics.api.info.register.IMasterInfoRegistry;
import sonar.logistics.api.register.CapabilityMethod;
import sonar.logistics.api.register.InvField;
import sonar.logistics.api.register.LogicPath;
import sonar.logistics.api.register.RegistryType;
import sonar.logistics.api.register.TileHandlerMethod;
import sonar.logistics.api.tiles.nodes.BlockConnection;
import sonar.logistics.api.tiles.nodes.EntityConnection;
import sonar.logistics.api.tiles.nodes.NodeConnection;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.info.types.LogicInfo;

public class LogicInfoRegistry
implements IMasterInfoRegistry {
    public static LogicInfoRegistry INSTANCE = new LogicInfoRegistry();
    public Map<Class<?>, List<Method>> cachedMethods = Maps.newLinkedHashMap();
    public Map<Class<?>, List<Field>> cachedFields = Maps.newLinkedHashMap();
    public List<IInfoRegistry> infoRegistries = Lists.newArrayList();
    public List<ITileInfoProvider> tileProviders = Lists.newArrayList();
    public List<IEntityInfoProvider> entityProviders = Lists.newArrayList();
    public List<Class<?>> validReturns = Lists.newArrayList();
    public List<Capability> validCapabilities = Lists.newArrayList();
    public Map<RegistryType, Map<Class<?>, List<Method>>> validMethods = Maps.newLinkedHashMap();
    public Map<RegistryType, Map<Class<?>, List<Field>>> validFields = Maps.newLinkedHashMap();
    public Map<Class<?>, Map<String, Integer>> validInvFields = Maps.newLinkedHashMap();
    public Map<String, Pair<String, String>> infoAdjustments = Maps.newLinkedHashMap();
    public Map<String, String> clientAdjustments = Maps.newLinkedHashMap();
    public List<Class<?>> acceptedReturns = RegistryType.buildList();
    public List<Class<?>> defaultReturns = Lists.newArrayList((Object[])new Class[]{String.class});

    public void init() {
        this.infoRegistries.forEach(registry -> {
            try {
                registry.registerBaseReturns(this);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
        this.infoRegistries.forEach(registry -> {
            try {
                registry.registerBaseMethods(this);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
        this.infoRegistries.forEach(registry -> {
            try {
                registry.registerAllFields(this);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
        this.infoRegistries.forEach(registry -> {
            try {
                registry.registerAdjustments(this);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
    }

    public void reload() {
        this.validReturns.clear();
        this.validMethods.clear();
        this.validFields.clear();
        this.validInvFields.clear();
        this.infoAdjustments.clear();
        this.clientAdjustments.clear();
        this.init();
        this.cachedFields.clear();
        this.cachedMethods.clear();
    }

    @Override
    public void registerInfoRegistry(String modid, IInfoRegistry handler) {
        if (Loader.isModLoaded((String)modid)) {
            this.infoRegistries.add(handler);
        }
    }

    @Override
    public void registerCapability(Capability capability) {
        this.validCapabilities.add(capability);
    }

    @Override
    public void registerValidReturn(Class<?> classType) {
        this.validReturns.add(classType);
    }

    @Override
    public void registerMethods(Class<?> classType, RegistryType type) {
        this.registerMethods(classType, type, Lists.newArrayList(), true);
    }

    @Override
    public void registerMethods(Class<?> classType, RegistryType type, List<String> methodNames) {
        this.registerMethods(classType, type, methodNames, false);
    }

    @Override
    public void registerMethods(Class<?> classType, RegistryType type, List<String> methodNames, boolean exclude) {
        Method[] methods;
        this.validMethods.putIfAbsent(type, Maps.newLinkedHashMap());
        this.validMethods.get((Object)type).putIfAbsent(classType, Lists.newArrayList());
        ArrayList used = Lists.newArrayList();
        for (Method method : methods = classType.getMethods()) {
            if (used.contains(method.getName()) || !methodNames.isEmpty() && !(exclude ? !methodNames.contains(method.getName()) : methodNames.contains(method.getName()))) continue;
            boolean validParams = this.validateParameters(method.getParameterTypes());
            boolean validReturns = this.isValidReturnType(method.getReturnType());
            if (validParams && validReturns) {
                this.validMethods.get((Object)type).get(classType).add(method);
                used.add(method.getName());
                continue;
            }
            PL2.logger.error(String.format("Failed to load method: %s, Valid Parameters: %s, Valid Returns %s,", method.toString(), validParams, validReturns));
        }
    }

    @Override
    public void registerClientNames(String fieldName, List<String> fieldNames) {
        for (String name : fieldNames) {
            this.clientAdjustments.put(name, fieldName);
        }
    }

    @Override
    public void registerFields(Class<?> classType, RegistryType type) {
        this.registerFields(classType, type, Lists.newArrayList(), true);
    }

    @Override
    public void registerFields(Class<?> classType, RegistryType type, List<String> fieldNames) {
        this.registerFields(classType, type, fieldNames, false);
    }

    @Override
    public void registerFields(Class<?> classType, RegistryType type, List<String> fieldNames, boolean exclude) {
        Field[] fields;
        this.validFields.putIfAbsent(type, Maps.newLinkedHashMap());
        this.validFields.get((Object)type).putIfAbsent(classType, Lists.newArrayList());
        for (Field field : fields = classType.getDeclaredFields()) {
            boolean validReturns;
            if (!fieldNames.isEmpty() && !(exclude ? !fieldNames.contains(field.getName()) : fieldNames.contains(field.getName()))) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (validReturns = this.isValidReturnType(field.getType())) {
                this.validFields.get((Object)type).get(classType).add(field);
                continue;
            }
            PL2.logger.error(String.format("Failed to load field: %s, Valid Returns: %s,", field.toString(), validReturns));
        }
    }

    @Override
    public void registerInvFields(Class<?> inventoryClass, Map<String, Integer> fields) {
        this.validInvFields.put(inventoryClass, fields);
    }

    @Override
    public void registerInfoAdjustments(List<String> identifiers, String prefix, String suffix) {
        identifiers.forEach(identifier -> this.infoAdjustments.put((String)identifier, (Pair<String, String>)new Pair((Object)prefix, (Object)suffix)));
    }

    @Override
    public void registerInfoAdjustments(String identifier, String prefix, String suffix) {
        this.infoAdjustments.put(identifier, (Pair<String, String>)new Pair((Object)prefix, (Object)suffix));
    }

    @Override
    public boolean containsAssignableType(Class<?> toCheck, List<Class<?>> classes) {
        for (Class<?> cls : classes) {
            if (!cls.isAssignableFrom(toCheck) && !toCheck.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidReturnType(Class<?> returnType) {
        return returnType.isPrimitive() || this.containsAssignableType(returnType, this.defaultReturns) || this.containsAssignableType(returnType, this.validReturns) || this.containsAssignableType(returnType, this.acceptedReturns);
    }

    @Override
    public boolean validateParameters(Class<?>[] parameters) {
        if (parameters.length == 0) {
            return true;
        }
        for (Class<?> param : parameters) {
            if (this.containsAssignableType(param, this.acceptedReturns)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Method> getAssignableMethods(Class<?> obj, RegistryType type) {
        ArrayList methods = this.cachedMethods.get(obj);
        if (methods == null) {
            methods = Lists.newArrayList();
            Map map = this.validMethods.computeIfAbsent(type, m -> Maps.newLinkedHashMap());
            if (type == RegistryType.NONE) {
                map.putAll(this.validMethods.get((Object)RegistryType.NONE));
            }
            for (Map.Entry classTypes : map.entrySet()) {
                if (!((Class)classTypes.getKey()).isAssignableFrom(obj) && !obj.isAssignableFrom((Class)classTypes.getKey())) continue;
                methods.addAll((Collection)classTypes.getValue());
            }
            this.cachedMethods.put(obj, methods);
        }
        return methods;
    }

    @Override
    public List<Field> getAccessibleFields(Class<?> obj, RegistryType type) {
        ArrayList fields = this.cachedFields.get(obj);
        if (fields == null) {
            fields = Lists.newArrayList();
            Map map = this.validFields.computeIfAbsent(type, m -> Maps.newLinkedHashMap());
            if (type == RegistryType.NONE) {
                map.putAll(this.validFields.get((Object)RegistryType.NONE));
            }
            for (Map.Entry classTypes : map.entrySet()) {
                if (!((Class)classTypes.getKey()).isAssignableFrom(obj)) continue;
                fields.addAll((Collection)classTypes.getValue());
            }
            this.cachedFields.put(obj, fields);
        }
        return fields;
    }

    @Override
    public Object invokeMethod(Object obj, Method method, Object ... available) {
        Class<?>[] params = method.getParameterTypes();
        Object[] inputs = new Object[params.length];
        block2: for (int i = 0; i < params.length; ++i) {
            Class<?> param = params[i];
            for (Object arg : available) {
                if (!param.isInstance(arg)) continue;
                inputs[i] = arg;
                continue block2;
            }
        }
        for (Object input : inputs) {
            if (input != null) continue;
            return null;
        }
        try {
            return method.invoke(obj, inputs);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            PL2.logger.error("COULDN'T INVOKE METHOD! " + method + " on object " + obj);
            return null;
        }
    }

    @Override
    public void getClassInfo(List<IProvidableInfo> infoList, LogicPath currentPath, RegistryType type, Object obj, Method method, Object ... available) {
        Object returned = this.invokeMethod(obj, method, available);
        if (returned == null) {
            return;
        }
        Class<?> returnedClass = returned.getClass();
        currentPath.addObject(method);
        if (!returnedClass.isPrimitive() && !this.containsAssignableType(returnedClass, this.defaultReturns) && this.containsAssignableType(returnedClass, this.validReturns)) {
            this.getAssignableMethods(returnedClass, type).forEach(returnMethod -> this.getClassInfo(infoList, currentPath.dupe(), type, returned, (Method)returnMethod, available));
        } else {
            this.buildInfo(infoList, currentPath, this.getValidClassName(method.getDeclaringClass(), obj), method.getName(), type, returned);
        }
    }

    @Override
    public void getFieldInfo(List<IProvidableInfo> infoList, LogicPath currentPath, RegistryType type, Object obj, Field field, Object ... available) {
        Object fieldObj = this.getField(obj, field);
        if (fieldObj == null) {
            return;
        }
        Class<?> returnedClass = fieldObj.getClass();
        currentPath.addObject(field);
        if (!returnedClass.isPrimitive() && !this.containsAssignableType(returnedClass, this.defaultReturns) && this.containsAssignableType(returnedClass, this.validReturns)) {
            this.getAssignableMethods(returnedClass, type).forEach(returnMethod -> this.getClassInfo(infoList, currentPath.dupe(), type, fieldObj, (Method)returnMethod, available));
            this.getAccessibleFields(returnedClass, type).forEach(subField -> this.getFieldInfo(infoList, currentPath.dupe(), type, fieldObj, (Field)subField, available));
        } else {
            this.buildInfo(infoList, currentPath.dupe(), this.getValidClassName(field.getDeclaringClass(), obj), field.getName(), type, fieldObj);
        }
    }

    public String getValidClassName(Class declared, Object obj) {
        if (declared == Enum.class) {
            return obj.getClass().getSimpleName();
        }
        return declared.getSimpleName();
    }

    @Override
    public void buildInfo(List<IProvidableInfo> infoList, LogicPath path, String className, String fieldName, RegistryType type, Object object) {
        path.setRegistryType(type);
        LogicInfo info = (LogicInfo)LogicInfo.buildDirectInfo(className + "." + fieldName, type, object).setPath(path);
        if (info != null) {
            infoList.add(info);
        }
    }

    @Override
    public Object getField(Object obj, Field field) {
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field.get(obj);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<IProvidableInfo> getEntityInfo(List<IProvidableInfo> infoList, Entity entity) {
        Class<?> argClass;
        if (entity != null && this.containsAssignableType(argClass = entity.getClass(), this.acceptedReturns)) {
            LogicPath logicPath = new LogicPath();
            logicPath.setStart(entity);
            EnumFacing currentFace = null;
            RegistryType type = RegistryType.getRegistryType(argClass);
            this.getAssignableMethods(argClass, type).forEach(method -> this.getClassInfo(infoList, logicPath.dupe(), type, entity, (Method)method, new Object[0]));
            this.getAccessibleFields(argClass, type).forEach(field -> this.getFieldInfo(infoList, logicPath.dupe(), type, entity, (Field)field, new Object[0]));
            this.addCapabilities(infoList, logicPath.dupe(), entity, currentFace, new Object[0]);
        }
        return infoList;
    }

    @Override
    public List<IProvidableInfo> getTileInfo(List<IProvidableInfo> infoList, EnumFacing currentFace, Object ... available) {
        for (Object arg : available) {
            Map<String, Integer> fields;
            Class<?> argClass;
            if (arg == null || !this.containsAssignableType(argClass = arg.getClass(), this.acceptedReturns)) continue;
            LogicPath currentPath = new LogicPath();
            currentPath.setStart(arg);
            RegistryType type = RegistryType.getRegistryType(argClass);
            this.getAssignableMethods(argClass, type).forEach(method -> this.getClassInfo(infoList, currentPath.dupe(), type, arg, (Method)method, available));
            this.getAccessibleFields(argClass, type).forEach(field -> this.getFieldInfo(infoList, currentPath.dupe(), type, arg, (Field)field, new Object[0]));
            if (arg instanceof IInventory && (fields = this.validInvFields.get(argClass)) != null && !fields.isEmpty()) {
                fields.entrySet().forEach(field -> {
                    LogicPath invPath = currentPath.dupe();
                    invPath.addObject(new InvField((String)field.getKey(), (Integer)field.getValue(), type));
                    invPath.setRegistryType(type);
                    infoList.add((IProvidableInfo)LogicInfo.buildDirectInfo(argClass.getSimpleName() + "." + (String)field.getKey(), type, ((IInventory)arg).func_174887_a_(((Integer)field.getValue()).intValue())).setPath(invPath));
                });
            }
            this.addCapabilities(infoList, currentPath.dupe(), arg, currentFace, available);
        }
        return infoList;
    }

    @Override
    public void addCapabilities(List<IProvidableInfo> infoList, LogicPath path, Object obj, EnumFacing currentFace, Object ... available) {
        if (obj instanceof ICapabilityProvider && !this.validCapabilities.isEmpty()) {
            ICapabilityProvider provider = (ICapabilityProvider)obj;
            ArrayList capabilities = Lists.newArrayList();
            for (Capability cap : this.validCapabilities) {
                Capability providedCap;
                if (!provider.hasCapability(cap, currentFace) || (providedCap = (Capability)provider.getCapability(cap, currentFace)) == null) continue;
                capabilities.add(cap);
            }
            for (Capability cap : capabilities) {
                LogicPath logicPath = path.dupe();
                logicPath.addObject(new CapabilityMethod(cap));
                this.getAssignableMethods(cap.getClass(), RegistryType.CAPABILITY).forEach(method -> this.getClassInfo(infoList, logicPath.dupe(), RegistryType.CAPABILITY, cap, (Method)method, available));
                this.getAccessibleFields(cap.getClass(), RegistryType.CAPABILITY).forEach(field -> this.getFieldInfo(infoList, logicPath.dupe(), RegistryType.CAPABILITY, cap, (Field)field, new Object[0]));
            }
        }
    }

    @Override
    public <T extends IProvidableInfo> Pair<Boolean, T> getLatestInfo(MonitoredList updateInfo, List<NodeConnection> connections, T monitorInfo) {
        if (monitorInfo == null) {
            return null;
        }
        Object newPaired = null;
        if (!connections.isEmpty()) {
            IProvidableInfo latestInfo;
            Object latest;
            T info = monitorInfo;
            if (info.getPath() == null && (latest = updateInfo.getLatestInfo(info).b) != null && latest instanceof IProvidableInfo && (latestInfo = (IProvidableInfo)latest).getPath() != null) {
                info.setPath(latestInfo.getPath().dupe());
            }
            newPaired = this.getLatestInfo(info, connections.get(0));
        }
        if (newPaired == null) {
            newPaired = updateInfo.getLatestInfo(monitorInfo);
        }
        return newPaired;
    }

    @Override
    public <T extends IProvidableInfo> Pair<Boolean, T> getLatestInfo(T info, NodeConnection entry) {
        World world;
        NodeConnection connection;
        if (info.getPath() == null) {
            return null;
        }
        Object returned = null;
        if (entry instanceof BlockConnection) {
            connection = (BlockConnection)entry;
            EnumFacing face = connection.face.func_176734_d();
            world = connection.coords.getWorld();
            IBlockState state = connection.coords.getBlockState(world);
            BlockPos pos = connection.coords.getBlockPos();
            Block block = state.func_177230_c();
            TileEntity tile = connection.coords.getTileEntity(world);
            returned = this.getInfoFromPath(info, info.getPath(), face, world, state, pos, face, block, tile);
        }
        if (entry instanceof EntityConnection) {
            connection = (EntityConnection)entry;
            Entity entity = ((EntityConnection)connection).entity;
            world = entity.func_130014_f_();
            returned = this.getInfoFromPath(info, info.getPath(), EnumFacing.NORTH, entity, world);
        }
        if (returned != null) {
            return new Pair((Object)true, returned);
        }
        return null;
    }

    @Override
    public <T extends IProvidableInfo> T getInfoFromPath(T info, LogicPath logicPath, EnumFacing currentFace, Object ... available) {
        Object returned = logicPath.getStart(available);
        if (returned.equals(TileHandlerMethod.class)) {
            TileHandlerMethod method = (TileHandlerMethod)logicPath.startObj;
            LogicPath path = logicPath.dupe();
            ArrayList infolist = Lists.newArrayList();
            method.handler.provide(this, infolist, path, method.bitCode, (World)available[0], (IBlockState)available[1], (BlockPos)available[2], (EnumFacing)available[3], (Block)available[4], (TileEntity)available[5]);
            for (IProvidableInfo logicInfo : infolist) {
                if (!logicInfo.isValid() || !logicInfo.isMatchingType(info) || !logicInfo.isMatchingInfo(info)) continue;
                return (T)logicInfo;
            }
        }
        for (Object arg : logicPath.path) {
            if (returned == null) {
                return null;
            }
            if (arg instanceof Method) {
                returned = this.invokeMethod(returned, (Method)arg, available);
                continue;
            }
            if (arg instanceof Field) {
                returned = this.getField(returned, (Field)arg);
                continue;
            }
            if (arg instanceof CapabilityMethod) {
                if (returned instanceof ICapabilityProvider) {
                    returned = ((ICapabilityProvider)returned).getCapability(((CapabilityMethod)arg).cap, currentFace);
                    continue;
                }
                return null;
            }
            if (!(arg instanceof InvField) || !(returned instanceof IInventory)) continue;
            InvField field = (InvField)arg;
            info.setFromReturn(logicPath, ((IInventory)returned).func_174887_a_(field.value.intValue()));
            return info;
        }
        if (returned != null) {
            info.setFromReturn(logicPath, returned);
        }
        return info;
    }
}

