/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.providers;

import appeng.api.AEApi;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.tile.storage.TileDrive;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sonar.logistics.api.asm.TileInfoProvider;
import sonar.logistics.api.info.IProvidableInfo;
import sonar.logistics.api.info.handlers.ITileInfoProvider;
import sonar.logistics.api.info.register.IMasterInfoRegistry;
import sonar.logistics.api.register.LogicPath;
import sonar.logistics.info.types.AE2DriveInfo;

@TileInfoProvider(handlerID="ae2-drive", modid="appliedenergistics2")
public class AE2DriveProvider
implements ITileInfoProvider {
    @Override
    public boolean canProvide(World world, IBlockState state, BlockPos pos, EnumFacing dir, TileEntity tile, Block block) {
        return tile instanceof TileDrive;
    }

    @Override
    public void provide(IMasterInfoRegistry registry, List<IProvidableInfo> infoList, LogicPath currentPath, Integer methodCode, World world, IBlockState state, BlockPos pos, EnumFacing dir, Block block, TileEntity tile) {
        TileDrive drives = (TileDrive)tile;
        ArrayList allInfo = Lists.newArrayList();
        long totalBytes = 0L;
        long usedBytes = 0L;
        long totalTypes = 0L;
        long usedTypes = 0L;
        long itemCount = 0L;
        for (int i = 0; i < drives.getInternalInventory().func_70302_i_(); ++i) {
            ItemStack is = drives.getInternalInventory().func_70301_a(i);
            List<Object> handlers = Lists.newArrayList();
            if (is != null) {
                IMEInventoryHandler itemInventory = AEApi.instance().registries().cell().getCellInventory(is, null, StorageChannel.ITEMS);
                IMEInventoryHandler fluidInventory = AEApi.instance().registries().cell().getCellInventory(is, null, StorageChannel.FLUIDS);
                handlers = Arrays.asList(itemInventory, fluidInventory);
            }
            AE2DriveInfo info = (AE2DriveInfo)new AE2DriveInfo(handlers, i + 1).setPath(currentPath.dupe());
            totalBytes += ((Long)info.totalBytes.getObject()).longValue();
            usedBytes += ((Long)info.usedBytes.getObject()).longValue();
            totalTypes += ((Long)info.totalTypes.getObject()).longValue();
            usedTypes += ((Long)info.usedTypes.getObject()).longValue();
            itemCount += ((Long)info.itemCount.getObject()).longValue();
            allInfo.add(info);
        }
        AE2DriveInfo driveInfo = (AE2DriveInfo)new AE2DriveInfo().setPath(currentPath.dupe());
        driveInfo.totalBytes.setObject((Object)totalBytes);
        driveInfo.usedBytes.setObject((Object)usedBytes);
        driveInfo.totalTypes.setObject((Object)totalTypes);
        driveInfo.usedTypes.setObject((Object)usedTypes);
        driveInfo.itemCount.setObject((Object)itemCount);
        infoList.add(driveInfo);
        infoList.addAll(allInfo);
    }
}

