/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.providers;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sonar.logistics.api.asm.TileInfoProvider;
import sonar.logistics.api.info.IProvidableInfo;
import sonar.logistics.api.info.handlers.ITileInfoProvider;
import sonar.logistics.api.info.register.IMasterInfoRegistry;
import sonar.logistics.api.register.LogicPath;
import sonar.logistics.api.register.RegistryType;
import sonar.logistics.info.types.LogicInfo;

@TileInfoProvider(handlerID="immersiveengineering-progress", modid="immersiveengineering")
public class ImmersiveEngineeringProvider
implements ITileInfoProvider {
    @Override
    public boolean canProvide(World world, IBlockState state, BlockPos pos, EnumFacing dir, TileEntity tile, Block block) {
        return tile instanceof IEBlockInterfaces.IProcessTile;
    }

    @Override
    public void provide(IMasterInfoRegistry registry, List<IProvidableInfo> infoList, LogicPath currentPath, Integer methodCode, World world, IBlockState state, BlockPos pos, EnumFacing dir, Block block, TileEntity tile) {
        IEBlockInterfaces.IProcessTile process = (IEBlockInterfaces.IProcessTile)tile;
        int[] steps = process.getCurrentProcessesStep();
        int[] maxs = process.getCurrentProcessesMax();
        for (int i = 0; i < steps.length; ++i) {
            int step = steps[i];
            int max = maxs[i];
            infoList.add((IProvidableInfo)LogicInfo.buildDirectInfo("Default.CurrentProcessTime", i, RegistryType.TILE, step).setPath(currentPath.dupe()));
            infoList.add((IProvidableInfo)LogicInfo.buildDirectInfo("Default.ProcessTime", i, RegistryType.TILE, max).setPath(currentPath.dupe()));
        }
    }
}

