/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.registries;

import com.google.common.collect.Lists;
import sonar.flux.api.EnergyStats;
import sonar.flux.api.IFlux;
import sonar.flux.api.IFluxCommon;
import sonar.flux.api.INetworkStatistics;
import sonar.logistics.api.asm.InfoRegistry;
import sonar.logistics.api.info.register.IInfoRegistry;
import sonar.logistics.api.info.register.IMasterInfoRegistry;
import sonar.logistics.api.register.RegistryType;

@InfoRegistry(modid="FluxNetworks")
public class FluxNetworksRegistry
extends IInfoRegistry {
    @Override
    public void registerBaseReturns(IMasterInfoRegistry registry) {
        registry.registerValidReturn(IFluxCommon.class);
        registry.registerValidReturn(IFlux.ConnectionType.class);
        registry.registerValidReturn(IFluxCommon.AccessType.class);
        registry.registerValidReturn(INetworkStatistics.class);
        registry.registerValidReturn(EnergyStats.class);
    }

    @Override
    public void registerBaseMethods(IMasterInfoRegistry registry) {
        registry.registerMethods(IFlux.class, RegistryType.TILE, Lists.newArrayList((Object[])new String[]{"getCoords", "getNetwork", "getConnectionType", "getTransferLimit", "getCurrentTransferLimit", "getCurrentPriority", "getCustomName"}), false);
        registry.registerMethods(IFluxCommon.class, RegistryType.TILE, Lists.newArrayList((Object[])new String[]{"getAccessType", "getNetworkID", "getNetworkName", "getCachedPlayerName", "getEnergyAvailable", "getMaxEnergyStored", "getStatistics"}), false);
        registry.registerMethods(IFluxCommon.AccessType.class, RegistryType.TILE, Lists.newArrayList((Object[])new String[]{"name"}), false);
        registry.registerMethods(INetworkStatistics.class, RegistryType.TILE, Lists.newArrayList((Object[])new String[]{"getLatestStats"}), false);
        registry.registerMethods(EnergyStats.class, RegistryType.TILE, Lists.newArrayList((Object[])new String[]{"getLatestStats"}), false);
    }

    @Override
    public void registerAllFields(IMasterInfoRegistry registry) {
        registry.registerFields(EnergyStats.class, RegistryType.TILE, Lists.newArrayList((Object[])new String[]{"transfer", "maxSent", "maxReceived"}));
    }

    @Override
    public void registerAdjustments(IMasterInfoRegistry registry) {
        registry.registerInfoAdjustments(Lists.newArrayList((Object[])new String[]{"EnergyStats.transfer", "EnergyStats.maxSent", "EnergyStats.maxReceived", "IFlux.getTransferLimit", "IFlux.getCurrentTransferLimit"}), "", "RF/t");
        registry.registerInfoAdjustments(Lists.newArrayList((Object[])new String[]{"IFluxCommon.getEnergyAvailable", "IFluxCommon.getMaxEnergyStored"}), "", "RF");
        registry.registerClientNames("Default.Priority", Lists.newArrayList((Object[])new String[]{"IFlux.getCurrentPriority"}));
    }
}

