/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.GL11;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.logistics.api.asm.LogicInfoType;
import sonar.logistics.api.info.IComparableInfo;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.INameableInfo;
import sonar.logistics.api.info.IProvidableInfo;
import sonar.logistics.api.info.render.IDisplayInfo;
import sonar.logistics.api.info.render.InfoContainer;
import sonar.logistics.api.networks.INetworkHandler;
import sonar.logistics.api.register.LogicPath;
import sonar.logistics.api.register.RegistryType;
import sonar.logistics.api.tiles.signaller.ComparableObject;
import sonar.logistics.connections.handlers.InfoNetworkHandler;
import sonar.logistics.helpers.InfoRenderer;
import sonar.logistics.info.types.BaseInfo;

@LogicInfoType(id="ae2-drive-info", modid="appliedenergistics2")
public class AE2DriveInfo
extends BaseInfo<AE2DriveInfo>
implements IProvidableInfo<AE2DriveInfo>,
INameableInfo<AE2DriveInfo>,
IComparableInfo<AE2DriveInfo> {
    public static final String id = "ae2-drive-info";
    public SyncTagType.LONG totalBytes = new SyncTagType.LONG(1);
    public SyncTagType.LONG usedBytes = new SyncTagType.LONG(2);
    public SyncTagType.LONG totalTypes = new SyncTagType.LONG(3);
    public SyncTagType.LONG usedTypes = new SyncTagType.LONG(4);
    public SyncTagType.LONG itemCount = new SyncTagType.LONG(5);
    public SyncTagType.INT driveNum = new SyncTagType.INT(5);

    public AE2DriveInfo() {
        this.syncList.addParts(new IDirtyPart[]{this.totalBytes, this.usedBytes, this.totalTypes, this.usedTypes, this.itemCount, this.driveNum});
    }

    public AE2DriveInfo(int driveNum) {
        this.syncList.addParts(new IDirtyPart[]{this.totalBytes, this.usedBytes, this.totalTypes, this.usedTypes, this.itemCount, this.driveNum});
        this.driveNum.setObject((Object)driveNum);
    }

    public AE2DriveInfo(List<IMEInventoryHandler> invHandlers, int driveNum) {
        this(driveNum);
        for (IMEInventoryHandler handler : invHandlers) {
            ICellInventoryHandler cell;
            ICellInventory cellInventory;
            if (!(handler instanceof ICellInventoryHandler) || (cellInventory = (cell = (ICellInventoryHandler)handler).getCellInv()) == null) continue;
            SyncTagType.LONG lONG = this.totalBytes;
            Long.valueOf((Long)lONG.current + cellInventory.getTotalBytes());
            lONG.current = lONG.current;
            lONG = this.usedBytes;
            Long.valueOf((Long)lONG.current + cellInventory.getUsedBytes());
            lONG.current = lONG.current;
            lONG = this.totalTypes;
            Long.valueOf((Long)lONG.current + cellInventory.getTotalItemTypes());
            lONG.current = lONG.current;
            lONG = this.usedTypes;
            Long.valueOf((Long)lONG.current + cellInventory.getStoredItemTypes());
            lONG.current = lONG.current;
            lONG = this.itemCount;
            Long.valueOf((Long)lONG.current + cellInventory.getStoredItemCount());
            lONG.current = lONG.current;
        }
    }

    @Override
    public String getID() {
        return id;
    }

    @Override
    public boolean isIdenticalInfo(AE2DriveInfo info) {
        return info.totalBytes.getObject() == this.totalBytes.getObject() && info.usedBytes.getObject() == this.usedBytes.getObject() && info.totalTypes.getObject() == this.totalTypes.getObject() && info.usedTypes.getObject() == this.usedTypes.getObject() && info.itemCount.getObject() == this.itemCount.getObject();
    }

    @Override
    public boolean isMatchingInfo(AE2DriveInfo info) {
        return info.driveNum.getObject() == this.driveNum.getObject();
    }

    @Override
    public boolean isMatchingType(IInfo info) {
        return info instanceof AE2DriveInfo;
    }

    @Override
    public INetworkHandler getHandler() {
        return InfoNetworkHandler.INSTANCE;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public AE2DriveInfo copy() {
        AE2DriveInfo newInfo = new AE2DriveInfo();
        newInfo.syncList.copyFrom(this.syncList);
        newInfo.setPath(this.getPath().dupe());
        return newInfo;
    }

    @Override
    public void renderInfo(InfoContainer container, IDisplayInfo displayInfo, double width, double height, double scale, int infoPos) {
        GL11.glPushMatrix();
        GL11.glPushMatrix();
        GlStateManager.func_179140_f();
        GL11.glTranslated((double)-1.0, (double)-0.75, (double)0.004);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(InfoContainer.getColour(infoPos));
        InfoRenderer.renderProgressBar(width, height, scale, ((Long)this.usedBytes.getObject()).longValue(), ((Long)this.totalBytes.getObject()).longValue());
        GlStateManager.func_179145_e();
        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.001);
        GL11.glPopMatrix();
        ArrayList strings = Lists.newArrayList();
        strings.add("Bytes: " + this.usedBytes.getObject() + "/" + this.totalBytes.getObject());
        strings.add("Types: " + this.usedTypes.getObject() + "/" + this.totalTypes.getObject());
        InfoRenderer.renderNormalInfo(container.display.getDisplayType(), width, height, scale, strings);
        GL11.glPopMatrix();
    }

    @Override
    public List<ComparableObject> getComparableObjects(List<ComparableObject> objects) {
        objects.add(new ComparableObject(this, "total bytes", this.totalBytes.getObject()));
        objects.add(new ComparableObject(this, "used bytes", this.usedBytes.getObject()));
        objects.add(new ComparableObject(this, "total types", this.totalTypes.getObject()));
        objects.add(new ComparableObject(this, "used types", this.usedTypes.getObject()));
        objects.add(new ComparableObject(this, "item count", this.itemCount.getObject()));
        objects.add(new ComparableObject(this, "drive number", this.driveNum.getObject()));
        return null;
    }

    @Override
    public String getClientIdentifier() {
        return (Integer)this.driveNum.getObject() == 0 ? "ME DRIVE" : "ME CELL " + this.driveNum.getObject();
    }

    @Override
    public String getClientObject() {
        return "Bytes[" + this.usedBytes.getObject() + "/" + this.totalBytes.getObject() + "]";
    }

    @Override
    public String getClientType() {
        return (Integer)this.driveNum.getObject() == 0 ? "ME drive" : "ME cell";
    }

    @Override
    public RegistryType getRegistryType() {
        return RegistryType.TILE;
    }

    @Override
    public AE2DriveInfo setRegistryType(RegistryType type) {
        return this;
    }

    @Override
    public void setFromReturn(LogicPath path, Object returned) {
        Object obj = returned;
    }
}

