/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import java.util.ArrayList;
import sonar.core.network.sync.BaseSyncListPart;
import sonar.core.network.sync.ICheckableSyncPart;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.ISyncableListener;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.render.IDisplayInfo;
import sonar.logistics.api.info.render.InfoContainer;
import sonar.logistics.api.register.LogicPath;

public abstract class BaseInfo<T extends IInfo>
extends BaseSyncListPart
implements IInfo<T>,
ISyncableListener {
    private LogicPath path;
    public boolean setInfoRenderSize = false;

    @Override
    public LogicPath getPath() {
        return this.path;
    }

    @Override
    public T setPath(LogicPath path) {
        this.path = path;
        return (T)this;
    }

    @Override
    public boolean isHeader() {
        return false;
    }

    @Override
    public void onInfoStored() {
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof IInfo) {
            IInfo info = (IInfo)object;
            return info.isHeader() && this.isHeader() || this.isMatchingType(info) && this.isMatchingInfo(info) && this.isIdenticalInfo(info);
        }
        return false;
    }

    @Override
    public void renderInfo(InfoContainer container, IDisplayInfo displayInfo, double width, double height, double scale, int infoPos) {
        if (!this.setInfoRenderSize) {
            this.renderSizeChanged(container, displayInfo, width, height, scale, infoPos);
            this.setInfoRenderSize = true;
        }
    }

    @Override
    public void renderSizeChanged(InfoContainer container, IDisplayInfo displayInfo, double width, double height, double scale, int infoPos) {
    }

    @Override
    public void identifyChanges(T newInfo) {
        ArrayList parts = this.syncList.getStandardSyncParts();
        ArrayList infoParts = this.syncList.getStandardSyncParts();
        for (int i = 0; i < parts.size(); ++i) {
            ISyncPart toCheck = (ISyncPart)infoParts.get(i);
            if (toCheck instanceof ICheckableSyncPart) {
                if (((ICheckableSyncPart)parts.get(i)).equalPart(toCheck)) continue;
                toCheck.getListener().markChanged((IDirtyPart)toCheck);
                continue;
            }
            toCheck.getListener().markChanged((IDirtyPart)toCheck);
        }
    }
}

