/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.GL11;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.logistics.api.asm.LogicInfoType;
import sonar.logistics.api.info.IComparableInfo;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.INameableInfo;
import sonar.logistics.api.info.render.IDisplayInfo;
import sonar.logistics.api.info.render.InfoContainer;
import sonar.logistics.api.networks.INetworkHandler;
import sonar.logistics.api.tiles.signaller.ComparableObject;
import sonar.logistics.connections.handlers.InfoNetworkHandler;
import sonar.logistics.helpers.InfoRenderer;
import sonar.logistics.info.types.BaseInfo;

@LogicInfoType(id="clock", modid="practicallogistics2")
public class ClockInfo
extends BaseInfo<ClockInfo>
implements IInfo<ClockInfo>,
INBTSyncable,
INameableInfo<ClockInfo>,
IComparableInfo<ClockInfo> {
    public static final String id = "clock";
    public int compare;
    public SyncTagType.DOUBLE firstNum = new SyncTagType.DOUBLE(1);
    public SyncTagType.DOUBLE secondNum = new SyncTagType.DOUBLE(2);
    public SyncTagType.STRING clockString = new SyncTagType.STRING(3);

    public ClockInfo() {
        this.syncList.addParts(new IDirtyPart[]{this.firstNum, this.secondNum, this.clockString});
    }

    public ClockInfo(double firstNum, double secondNum, String clockString) {
        this.syncList.addParts(new IDirtyPart[]{this.firstNum, this.secondNum, this.clockString});
        this.firstNum.setObject((Object)firstNum);
        this.secondNum.setObject((Object)secondNum);
        this.clockString.setObject((Object)clockString);
    }

    @Override
    public String getClientIdentifier() {
        return "Time";
    }

    @Override
    public String getClientObject() {
        if (!this.isValid()) {
            return "ERROR";
        }
        return (String)this.clockString.getObject();
    }

    @Override
    public String getClientType() {
        return "time";
    }

    @Override
    public boolean isIdenticalInfo(ClockInfo info) {
        return info.firstNum.getObject() == this.firstNum.getObject() && info.secondNum.getObject() == this.secondNum.getObject();
    }

    @Override
    public boolean isMatchingInfo(ClockInfo info) {
        return true;
    }

    @Override
    public boolean isMatchingType(IInfo info) {
        return info instanceof ClockInfo;
    }

    @Override
    public boolean isHeader() {
        return false;
    }

    @Override
    public INetworkHandler getHandler() {
        return InfoNetworkHandler.INSTANCE;
    }

    @Override
    public boolean isValid() {
        return this.firstNum.getObject() != null && this.firstNum.getObject() != null && this.clockString.getObject() != null;
    }

    @Override
    public String getID() {
        return id;
    }

    @Override
    public ClockInfo copy() {
        return new ClockInfo((Double)this.firstNum.getObject(), (Double)this.secondNum.getObject(), (String)this.clockString.getObject());
    }

    @Override
    public void renderInfo(InfoContainer container, IDisplayInfo displayInfo, double displayWidth, double displayHeight, double displayScale, int infoPos) {
        GL11.glPushMatrix();
        GL11.glPushMatrix();
        GlStateManager.func_179140_f();
        GL11.glTranslated((double)-1.0, (double)-0.75, (double)0.004);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(InfoContainer.getColour(infoPos));
        InfoRenderer.renderProgressBar(displayWidth, displayHeight, displayScale, this.compare == 1 ? ((Double)this.secondNum.getObject()).doubleValue() : ((Double)this.firstNum.getObject()).doubleValue(), this.compare == 1 ? ((Double)this.firstNum.getObject()).doubleValue() : ((Double)this.secondNum.getObject()).doubleValue());
        GlStateManager.func_179145_e();
        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.001);
        GL11.glPopMatrix();
        InfoRenderer.renderNormalInfo(container.display.getDisplayType(), displayWidth, displayHeight, displayScale, displayInfo.getFormattedStrings());
        GL11.glPopMatrix();
    }

    @Override
    public List<ComparableObject> getComparableObjects(List<ComparableObject> objects) {
        objects.add(new ComparableObject(this, "isEmitting", this.firstNum.getObject() == this.secondNum.getObject()));
        return objects;
    }
}

