/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import net.minecraft.nbt.NBTTagCompound;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.api.asm.LogicInfoType;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.render.IDisplayInfo;
import sonar.logistics.api.info.render.InfoContainer;
import sonar.logistics.api.networks.INetworkHandler;
import sonar.logistics.api.register.LogicPath;
import sonar.logistics.api.tiles.displays.DisplayConstants;
import sonar.logistics.helpers.InfoRenderer;

@LogicInfoType(id="error", modid="practicallogistics2")
public class InfoError
implements IInfo<InfoError> {
    public static final InfoError noData = new InfoError("NO DATA");
    public static final InfoError noMonitor = new InfoError("NO MONITOR");
    public static final InfoError noItem = new InfoError("NO ITEMSTACK");
    public static final String id = "error";
    public String error;

    public InfoError() {
    }

    public InfoError(String error) {
        this.error = FontHelper.translate((String)(error == null ? "" : error));
    }

    @Override
    public String getID() {
        return id;
    }

    @Override
    public boolean isIdenticalInfo(InfoError info) {
        return info.error.equals(this.error);
    }

    @Override
    public boolean isMatchingInfo(InfoError info) {
        return true;
    }

    @Override
    public boolean isMatchingType(IInfo info) {
        return info instanceof InfoError;
    }

    @Override
    public boolean isHeader() {
        return false;
    }

    @Override
    public INetworkHandler getHandler() {
        return null;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public InfoError copy() {
        return new InfoError(this.error);
    }

    @Override
    public void renderInfo(InfoContainer container, IDisplayInfo displayInfo, double width, double height, double scale, int infoPos) {
        InfoRenderer.renderNormalInfo(container.display.getDisplayType(), width, height, scale, DisplayConstants.formatText(this.error, displayInfo));
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        return nbt;
    }

    @Override
    public void identifyChanges(InfoError newInfo) {
    }

    @Override
    public LogicPath getPath() {
        return null;
    }

    @Override
    public InfoError setPath(LogicPath path) {
        return this;
    }

    @Override
    public void renderSizeChanged(InfoContainer container, IDisplayInfo displayInfo, double width, double height, double scale, int infoPos) {
    }

    @Override
    public void onInfoStored() {
    }
}

