/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import java.util.List;
import sonar.core.helpers.FontHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.ObjectType;
import sonar.core.network.sync.SyncEnum;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.sync.SyncUnidentifiedObject;
import sonar.core.utils.Pair;
import sonar.logistics.PL2;
import sonar.logistics.api.asm.LogicInfoType;
import sonar.logistics.api.info.IComparableInfo;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.INameableInfo;
import sonar.logistics.api.info.IProvidableInfo;
import sonar.logistics.api.info.ISuffixable;
import sonar.logistics.api.info.render.IDisplayInfo;
import sonar.logistics.api.info.render.InfoContainer;
import sonar.logistics.api.networks.INetworkHandler;
import sonar.logistics.api.register.LogicPath;
import sonar.logistics.api.register.RegistryType;
import sonar.logistics.api.tiles.signaller.ComparableObject;
import sonar.logistics.connections.handlers.InfoNetworkHandler;
import sonar.logistics.helpers.InfoRenderer;
import sonar.logistics.info.LogicInfoRegistry;
import sonar.logistics.info.types.BaseInfo;

@LogicInfoType(id="logic", modid="practicallogistics2")
public class LogicInfo
extends BaseInfo<LogicInfo>
implements IProvidableInfo<LogicInfo>,
INameableInfo<LogicInfo>,
ISuffixable,
IComparableInfo<LogicInfo> {
    public static final String id = "logic";
    private String suffix;
    private String prefix;
    public SyncTagType.STRING iden = new SyncTagType.STRING(1);
    public SyncTagType.INT idenNum = (SyncTagType.INT)new SyncTagType.INT(2).setDefault((Object)-1);
    public SyncEnum<RegistryType> regType = new SyncEnum((Enum[])RegistryType.values(), 3);
    public SyncUnidentifiedObject obj = new SyncUnidentifiedObject(4);
    public SyncTagType.BOOLEAN isCategory = new SyncTagType.BOOLEAN(5);
    public boolean markDirty = false;

    public LogicInfo() {
        this.syncList.addParts(new IDirtyPart[]{this.iden, this.idenNum, this.regType, this.obj, this.isCategory});
    }

    public static LogicInfo buildCategoryInfo(RegistryType type) {
        LogicInfo info = new LogicInfo();
        info.regType.setObject((Enum)type);
        info.isCategory.setObject((Object)true);
        return info;
    }

    public static LogicInfo buildDirectInfo(String identifier, RegistryType type, Object obj) {
        return LogicInfo.buildDirectInfo(identifier, -1, type, obj);
    }

    public static LogicInfo buildDirectInfo(String identifier, int identifierNum, RegistryType type, Object obj) {
        LogicInfo info = new LogicInfo();
        info.obj.set(obj, ObjectType.getInfoType((Object)obj));
        info.regType.setObject((Enum)type);
        info.iden.setObject((Object)identifier);
        info.idenNum.setObject((Object)identifierNum);
        if (info.obj.objType == ObjectType.NONE) {
            PL2.logger.error(String.format("Invalid Info: %s with object %s", identifier, obj));
            return null;
        }
        return info;
    }

    @Override
    public INetworkHandler getHandler() {
        return InfoNetworkHandler.INSTANCE;
    }

    @Override
    public boolean isIdenticalInfo(LogicInfo info) {
        return this.markDirty ? false : this.obj.get().equals(info.obj.get());
    }

    @Override
    public boolean isMatchingInfo(LogicInfo info) {
        if (((Boolean)this.isCategory.getObject()).booleanValue()) {
            return (Boolean)info.isCategory.getObject() != false && ((RegistryType)this.regType.getObject()).equals(info.regType.getObject());
        }
        return this.obj.objType != null && this.obj.objType.equals((Object)info.obj.objType) && ((String)this.iden.getObject()).equals(info.iden.getObject()) && ((RegistryType)this.regType.getObject()).equals(info.regType.getObject()) && ((Integer)this.idenNum.getObject()).equals(info.idenNum.getObject());
    }

    @Override
    public RegistryType getRegistryType() {
        return (RegistryType)this.regType.getObject();
    }

    @Override
    public LogicInfo setRegistryType(RegistryType type) {
        this.regType.setObject((Enum)type);
        return this;
    }

    @Override
    public String getClientIdentifier() {
        String newMethod = LogicInfoRegistry.INSTANCE.clientAdjustments.get(this.iden.getObject());
        if (newMethod != null) {
            return FontHelper.translate((String)("pl." + newMethod));
        }
        return FontHelper.translate((String)("pl." + this.iden)) + ((Integer)this.idenNum.getObject() != -1 ? " " + this.idenNum.getObject() : "");
    }

    public Pair<String, String> updateAdjustments(boolean forceUpdate) {
        if (forceUpdate || this.prefix == null || this.suffix == null) {
            this.prefix = "";
            this.suffix = "";
            Pair<String, String> adjustment = LogicInfoRegistry.INSTANCE.infoAdjustments.get(this.iden.getObject());
            if (adjustment != null) {
                if (!((String)adjustment.a).isEmpty()) {
                    this.prefix = (String)adjustment.a + " ";
                }
                if (!((String)adjustment.b).isEmpty()) {
                    this.suffix = " " + (String)adjustment.b;
                }
            }
        }
        return new Pair((Object)this.prefix, (Object)this.suffix);
    }

    @Override
    public String getClientObject() {
        if (((String)this.iden.getObject()).equals("Block.getUnlocalizedName")) {
            return FontHelper.translate((String)(this.obj.get().toString() + ".name"));
        }
        this.updateAdjustments(false);
        return this.prefix + this.obj.get().toString() + this.suffix;
    }

    @Override
    public String getClientType() {
        return this.obj.objType.toString().toLowerCase();
    }

    public Object getInfo() {
        return this.obj.get();
    }

    public ObjectType getInfoType() {
        return this.obj.objType;
    }

    @Override
    public boolean isHeader() {
        return (Boolean)this.isCategory.getObject();
    }

    @Override
    public boolean isMatchingType(IInfo info) {
        return info instanceof LogicInfo;
    }

    @Override
    public boolean isValid() {
        return ((Boolean)this.isCategory.getObject()).booleanValue() ? this.regType != null : this.obj.get() != null && this.obj.objType != null;
    }

    @Override
    public String getID() {
        return id;
    }

    @Override
    public LogicInfo copy() {
        return (LogicInfo)LogicInfo.buildDirectInfo((String)this.iden.getObject(), (RegistryType)this.regType.getObject(), this.obj.get()).setPath(this.getPath() != null ? this.getPath().dupe() : null);
    }

    @Override
    public void renderInfo(InfoContainer container, IDisplayInfo displayInfo, double width, double height, double scale, int infoPos) {
        InfoRenderer.renderNormalInfo(container.display.getDisplayType(), width, height, scale, displayInfo.getFormattedStrings());
    }

    @Override
    public String getSuffix() {
        this.updateAdjustments(false);
        return this.suffix;
    }

    @Override
    public String getPrefix() {
        this.updateAdjustments(false);
        return this.prefix;
    }

    @Override
    public String getRawData() {
        if (((String)this.iden.getObject()).equals("Block.getUnlocalizedName")) {
            return FontHelper.translate((String)(this.obj.get().toString() + ".name"));
        }
        return this.obj.get().toString();
    }

    @Override
    public List<ComparableObject> getComparableObjects(List<ComparableObject> objects) {
        objects.add(new ComparableObject(this, "raw info", this.obj.get()));
        objects.add(new ComparableObject(this, "object type", this.obj.objType));
        objects.add(new ComparableObject(this, "identifier", this.iden.getObject()));
        return objects;
    }

    public String toString() {
        return this.getClientIdentifier() + ": " + this.getClientObject();
    }

    @Override
    public void setFromReturn(LogicPath path, Object returned) {
        if (returned == null && this.obj.obj == null) {
            return;
        }
        if (this.obj.obj == null || !this.obj.obj.equals(returned)) {
            this.obj.obj = returned;
            this.markDirty = true;
        }
    }

    @Override
    public void onInfoStored() {
        this.markDirty = false;
    }
}

