/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import com.google.common.collect.Lists;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import sonar.core.api.utils.BlockInteractionType;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RenderHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.utils.CustomColour;
import sonar.logistics.PL2;
import sonar.logistics.api.asm.LogicInfoType;
import sonar.logistics.api.info.IAdvancedClickableInfo;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.INameableInfo;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.info.render.IDisplayInfo;
import sonar.logistics.api.info.render.InfoContainer;
import sonar.logistics.api.networks.INetworkHandler;
import sonar.logistics.api.tiles.displays.DisplayInteractionEvent;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.client.RenderBlockSelection;
import sonar.logistics.helpers.CableHelper;
import sonar.logistics.helpers.InfoHelper;
import sonar.logistics.helpers.InfoRenderer;
import sonar.logistics.info.types.BaseInfo;
import sonar.logistics.info.types.MonitoredEnergyStack;
import sonar.logistics.info.types.MonitoredFluidStack;
import sonar.logistics.info.types.MonitoredItemStack;

@LogicInfoType(id="logiclist", modid="practicallogistics2")
public class LogicInfoList
extends BaseInfo<LogicInfoList>
implements INameableInfo<LogicInfoList>,
IAdvancedClickableInfo {
    public static final String ITEM_CLICK = "ITEM_CLICK";
    public static final String id = "logiclist";
    public final SyncTagType.INT networkID = (SyncTagType.INT)new SyncTagType.INT(2).setDefault((Object)-1);
    public SyncTagType.INT identity = new SyncTagType.INT(0);
    public SyncTagType.STRING infoID = new SyncTagType.STRING(1);
    public MonitoredList<?> cachedList = null;
    public boolean listChanged = true;
    public boolean wasRefreshed = false;
    public int pageCount = 0;
    public int xSlots;
    public int ySlots;
    public int perPage = 0;
    public Type type = Type.ITEM;

    public LogicInfoList() {
        this.syncList.addParts(new IDirtyPart[]{this.identity, this.infoID, this.networkID});
        this.setType();
    }

    public LogicInfoList(int identity, String infoID, int networkID) {
        this.syncList.addParts(new IDirtyPart[]{this.identity, this.infoID, this.networkID});
        this.identity.setObject((Object)identity);
        this.infoID.setObject((Object)infoID);
        this.networkID.setObject((Object)networkID);
        this.setType();
    }

    public void setType() {
        String infoID = (String)this.infoID.getObject();
        if (infoID == null || infoID.isEmpty()) {
            return;
        }
        if (infoID.equals("item")) {
            this.type = Type.ITEM;
        } else if (infoID.equals("fluid")) {
            this.type = Type.FLUID;
        } else if (infoID.equals("energy")) {
            this.type = Type.ENERGY;
        }
    }

    @Override
    public String getID() {
        return id;
    }

    @Override
    public boolean isIdenticalInfo(LogicInfoList info) {
        return ((Integer)this.identity.getObject()).equals(info.identity.getObject());
    }

    @Override
    public boolean isMatchingInfo(LogicInfoList info) {
        return ((String)this.infoID.getObject()).equals(info.infoID.getObject());
    }

    @Override
    public boolean isMatchingType(IInfo info) {
        return info instanceof LogicInfoList;
    }

    @Override
    public INetworkHandler getHandler() {
        return null;
    }

    @Override
    public boolean isValid() {
        return (Integer)this.identity.getObject() != -1;
    }

    @Override
    public LogicInfoList copy() {
        return new LogicInfoList((Integer)this.identity.getObject(), (String)this.infoID.getObject(), (Integer)this.networkID.getObject());
    }

    public MonitoredList<?> getCachedList(InfoUUID id) {
        if (this.cachedList == null || this.listChanged) {
            this.listChanged = false;
            MonitoredList list = PL2.getClientManager().getMonitoredList((Integer)this.networkID.getObject(), id);
            this.cachedList = list == null ? MonitoredList.newMonitoredList((Integer)this.networkID.getObject()) : (MonitoredList)list.cloneInfo();
            this.setType();
            if (this.cachedList.size() < this.perPage * this.pageCount - 1) {
                this.pageCount = 0;
            }
        }
        return this.cachedList;
    }

    public void setCachedList(MonitoredList list, InfoUUID id) {
        this.cachedList = list;
    }

    @Override
    public void renderInfo(InfoContainer container, IDisplayInfo displayInfo, double width, double height, double scale, int infoPos) {
        super.renderInfo(container, displayInfo, width, height, scale, infoPos);
        this.cachedList = this.getCachedList(displayInfo.getInfoUUID());
        if (this.cachedList.isEmpty()) {
            return;
        }
        switch (this.type) {
            case ITEM: {
                this.xSlots = (int)Math.ceil(width * 2.0);
                this.ySlots = (int)Math.round(height * 2.0);
                this.perPage = this.xSlots * this.ySlots;
                InfoRenderer.renderInventory(this.cachedList, this.perPage * this.pageCount, Math.min(this.perPage + this.perPage * this.pageCount, this.cachedList.size()), this.xSlots, this.ySlots);
                break;
            }
            case FLUID: {
                this.xSlots = (int)Math.round(width);
                this.ySlots = (int)Math.round(height);
                this.perPage = this.xSlots * this.ySlots;
                MonitoredList<?> fluids = this.cachedList;
                int start = this.perPage * this.pageCount;
                int finish = Math.min(this.perPage + this.perPage * this.pageCount, fluids.size());
                for (int i = start; i < finish; ++i) {
                    MonitoredFluidStack fluid = (MonitoredFluidStack)fluids.get(i);
                    FluidStack stack = fluid.getStoredStack().fluid;
                    if (stack == null) continue;
                    int current = i - start;
                    int xLevel = (int)((double)current - Math.floor(current / this.xSlots) * (double)this.xSlots);
                    int yLevel = (int)Math.floor(current / this.xSlots);
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)xLevel, (double)yLevel, (double)0.0);
                    GL11.glPushMatrix();
                    GL11.glPushMatrix();
                    GlStateManager.func_179140_f();
                    GL11.glTranslated((double)-1.0, (double)-0.75, (double)0.004);
                    TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().getTextureExtry(stack.getFluid().getStill().toString());
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                    InfoRenderer.renderProgressBarWithSprite(sprite, 0.875, 0.875, 0.012, fluid.getStored(), fluid.getStoredStack().capacity);
                    GlStateManager.func_179145_e();
                    GL11.glTranslated((double)0.0, (double)0.0, (double)-0.001);
                    GL11.glPopMatrix();
                    InfoRenderer.renderNormalInfo(container.display.getDisplayType(), 0.875, 0.9375, 0.012, fluid.getClientIdentifier(), fluid.getClientObject());
                    GL11.glPopMatrix();
                    GL11.glPopMatrix();
                }
                break;
            }
            case ENERGY: {
                this.xSlots = 1;
                this.ySlots = (int)((double)Math.round(height) / 0.4375);
                this.perPage = this.xSlots * this.ySlots;
                MonitoredList<?> energy = this.cachedList;
                double spacing = 0.4375;
                GL11.glTranslated((double)-1.0, (double)-0.75, (double)0.0);
                int end = Math.min(this.perPage + this.perPage * this.pageCount, energy.size());
                for (int i = this.perPage * this.pageCount; i < end; ++i) {
                    MonitoredEnergyStack info = (MonitoredEnergyStack)energy.get(i);
                    int current = i - this.perPage * this.pageCount;
                    int xLevel = (int)((double)current - Math.floor(current / this.xSlots) * (double)this.xSlots);
                    int yLevel = (int)Math.floor(current / this.xSlots);
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)((double)xLevel * spacing), (double)((double)yLevel * spacing), (double)0.0);
                    double l = (double)info.getEnergyStack().stored * width / (double)info.getEnergyStack().capacity;
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderHelper.saveBlendState();
                    GlStateManager.func_179140_f();
                    boolean isHighlighted = false;
                    if (!RenderBlockSelection.positions.isEmpty() && RenderBlockSelection.isPositionRenderered(info.getMonitoredCoords().getCoords())) {
                        isHighlighted = true;
                    }
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(InfoContainer.getColour(2));
                    InfoRenderer.renderProgressBar(width, 0.375, scale, l, width);
                    RenderHelper.restoreBlendState();
                    GL11.glTranslated((double)0.0, (double)0.0, (double)-0.00625);
                    GL11.glTranslated((double)1.0, (double)0.78125, (double)0.0);
                    InfoRenderer.renderNormalInfo(container.display.getDisplayType(), width, 0.375, scale / 3.0, isHighlighted ? new CustomColour(20, 100, 180).getRGB() : -1, Lists.newArrayList((Object[])new String[]{info.getMonitoredCoords().getClientIdentifier() + " - " + info.getMonitoredCoords().getClientObject(), info.getClientIdentifier() + " - " + info.getClientObject()}));
                    GL11.glPopMatrix();
                }
                break;
            }
        }
    }

    @Override
    public NBTTagCompound onClientClick(DisplayInteractionEvent event, IDisplayInfo renderInfo, EntityPlayer player, ItemStack stack, InfoContainer container) {
        NBTTagCompound clickTag = new NBTTagCompound();
        if (event.type == BlockInteractionType.SHIFT_RIGHT) {
            MonitoredList<?> list = this.getCachedList(renderInfo.getInfoUUID());
            this.pageCount = list.size() > this.perPage * (this.pageCount + 1) ? ++this.pageCount : 0;
            player.func_146105_b((ITextComponent)new TextComponentTranslation(TextFormatting.BLUE + "Logistics: " + TextFormatting.RESET + "PAGE " + (this.pageCount + 1) + " of " + Math.round((double)list.size() / (double)Math.max(this.perPage, 1)), new Object[0]));
            return clickTag;
        }
        if (((String)this.infoID.getObject()).equals("item") && event.hit != null) {
            int slot = this.perPage * this.pageCount + CableHelper.getSlot(container.getDisplay(), renderInfo.getRenderProperties(), event.hit.field_72307_f, 2, 2);
            MonitoredList<?> list = this.getCachedList(renderInfo.getInfoUUID());
            if (list != null) {
                MonitoredItemStack itemStack;
                boolean hasItem = false;
                if (slot >= 0 && slot < list.size() && (itemStack = (MonitoredItemStack)list.get(slot)) != null) {
                    itemStack.writeData(clickTag, NBTHelper.SyncType.SAVE);
                    hasItem = true;
                }
                clickTag.func_74757_a(ITEM_CLICK, hasItem);
                return clickTag;
            }
        } else if (((String)this.infoID.getObject()).equals("fluid") && event.hit != null) {
            int slot = this.perPage * this.pageCount + CableHelper.getSlot(container.getDisplay(), renderInfo.getRenderProperties(), event.hit.field_72307_f, 1, 1);
            MonitoredList<?> list = this.getCachedList(renderInfo.getInfoUUID());
            if (list != null && slot >= 0 && slot < list.size()) {
                MonitoredFluidStack fluidStack = (MonitoredFluidStack)list.get(slot);
                if (fluidStack != null) {
                    fluidStack.writeData(clickTag, NBTHelper.SyncType.SAVE);
                }
                return clickTag;
            }
        } else if (((String)this.infoID.getObject()).equals("energy") && event.hit != null) {
            int slot = this.perPage * this.pageCount + CableHelper.getListSlot(container.getDisplay(), renderInfo.getRenderProperties(), event.hit.field_72307_f, 0.375, 0.0625, this.perPage);
            MonitoredList<?> list = this.getCachedList(renderInfo.getInfoUUID());
            if (list != null && slot >= 0 && slot < list.size()) {
                MonitoredEnergyStack energyStack = (MonitoredEnergyStack)list.get(slot);
                if (energyStack != null && event.type == BlockInteractionType.RIGHT) {
                    RenderBlockSelection.addPosition(energyStack.getMonitoredCoords().getCoords(), false);
                    player.func_146105_b((ITextComponent)new TextComponentTranslation(TextFormatting.BLUE + "Logistics: " + TextFormatting.RESET + "'" + energyStack.getMonitoredCoords().getClientIdentifier() + "' has been highlighted", new Object[0]));
                }
                return clickTag;
            }
        }
        return clickTag;
    }

    @Override
    public void onClickEvent(InfoContainer container, IDisplayInfo displayInfo, DisplayInteractionEvent event, NBTTagCompound clickTag) {
        if (((String)this.infoID.getObject()).equals("item")) {
            MonitoredItemStack clicked = clickTag.func_74767_n(ITEM_CLICK) ? (MonitoredItemStack)NBTHelper.instanceNBTSyncable(MonitoredItemStack.class, (NBTTagCompound)clickTag) : null;
            InfoHelper.screenItemStackClicked(clicked == null ? null : clicked.getStoredStack(), (Integer)this.networkID.getObject(), event.type, event.doubleClick, displayInfo.getRenderProperties(), event.player, event.hand, event.player.func_184586_b(event.hand), event.hit);
        } else if (((String)this.infoID.getObject()).equals("fluid")) {
            MonitoredFluidStack clicked = (MonitoredFluidStack)NBTHelper.instanceNBTSyncable(MonitoredFluidStack.class, (NBTTagCompound)clickTag);
            InfoHelper.screenFluidStackClicked(clicked.getStoredStack(), (Integer)this.networkID.getObject(), event.type, event.doubleClick, displayInfo.getRenderProperties(), event.player, event.hand, event.player.func_184586_b(event.hand), event.hit);
        }
    }

    @Override
    public String getClientIdentifier() {
        return "List: " + ((String)this.infoID.getObject()).toLowerCase();
    }

    @Override
    public String getClientObject() {
        return "LIST";
    }

    @Override
    public String getClientType() {
        return "list";
    }

    public static enum Type {
        ITEM,
        FLUID,
        ENERGY;

    }
}

