/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import java.util.List;
import sonar.core.api.utils.BlockCoords;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncCoords;
import sonar.core.network.sync.SyncTagType;
import sonar.logistics.api.asm.LogicInfoType;
import sonar.logistics.api.info.IComparableInfo;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.INameableInfo;
import sonar.logistics.api.info.render.IDisplayInfo;
import sonar.logistics.api.info.render.InfoContainer;
import sonar.logistics.api.networks.INetworkHandler;
import sonar.logistics.api.tiles.signaller.ComparableObject;
import sonar.logistics.helpers.InfoRenderer;
import sonar.logistics.info.types.BaseInfo;

@LogicInfoType(id="coords", modid="practicallogistics2")
public class MonitoredBlockCoords
extends BaseInfo<MonitoredBlockCoords>
implements INameableInfo<MonitoredBlockCoords>,
IComparableInfo<MonitoredBlockCoords> {
    public static final String id = "coords";
    private SyncCoords syncCoords = new SyncCoords(1);
    private SyncTagType.STRING unlocalizedName = new SyncTagType.STRING(2);

    public MonitoredBlockCoords() {
        this.syncList.addParts(new IDirtyPart[]{this.syncCoords, this.unlocalizedName});
    }

    public MonitoredBlockCoords(BlockCoords coords, String unlocalizedName) {
        this.syncList.addParts(new IDirtyPart[]{this.syncCoords, this.unlocalizedName});
        this.syncCoords.setCoords(coords);
        this.unlocalizedName.setObject((Object)unlocalizedName);
    }

    @Override
    public boolean isIdenticalInfo(MonitoredBlockCoords info) {
        return true;
    }

    @Override
    public boolean isMatchingInfo(MonitoredBlockCoords info) {
        return info.syncCoords.getCoords().equals((Object)this.syncCoords.getCoords());
    }

    @Override
    public boolean isMatchingType(IInfo info) {
        return info instanceof MonitoredBlockCoords;
    }

    @Override
    public String getClientIdentifier() {
        return (String)this.unlocalizedName.getObject();
    }

    @Override
    public String getClientObject() {
        return this.syncCoords.getCoords().toString();
    }

    @Override
    public String getClientType() {
        return "position";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MonitoredBlockCoords) {
            MonitoredBlockCoords monitoredCoords = (MonitoredBlockCoords)obj;
            return monitoredCoords.getCoords().equals((Object)this.getCoords()) && monitoredCoords.getUnlocalizedName().equals(this.getUnlocalizedName());
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.getCoords() != null;
    }

    @Override
    public String getID() {
        return id;
    }

    @Override
    public MonitoredBlockCoords copy() {
        return new MonitoredBlockCoords(this.getCoords(), (String)this.unlocalizedName.getObject());
    }

    public BlockCoords getCoords() {
        return this.syncCoords.getCoords();
    }

    public String getUnlocalizedName() {
        return (String)this.unlocalizedName.getObject();
    }

    @Override
    public void renderInfo(InfoContainer container, IDisplayInfo displayInfo, double width, double height, double scale, int infoPos) {
        InfoRenderer.renderNormalInfo(container.display.getDisplayType(), width, height, scale, this.getClientIdentifier(), this.getClientObject());
    }

    @Override
    public List<ComparableObject> getComparableObjects(List<ComparableObject> objects) {
        BlockCoords coords = this.syncCoords.getCoords();
        objects.add(new ComparableObject(this, "x", coords.getX()));
        objects.add(new ComparableObject(this, "y", coords.getY()));
        objects.add(new ComparableObject(this, "z", coords.getZ()));
        return objects;
    }

    @Override
    public INetworkHandler getHandler() {
        return null;
    }
}

