/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.energy.StoredEnergyStack;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.FontHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncNBTAbstract;
import sonar.logistics.api.asm.LogicInfoType;
import sonar.logistics.api.info.IComparableInfo;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.IJoinableInfo;
import sonar.logistics.api.info.INameableInfo;
import sonar.logistics.api.info.render.IDisplayInfo;
import sonar.logistics.api.info.render.InfoContainer;
import sonar.logistics.api.tiles.signaller.ComparableObject;
import sonar.logistics.connections.handlers.EnergyNetworkHandler;
import sonar.logistics.helpers.InfoRenderer;
import sonar.logistics.info.types.BaseInfo;
import sonar.logistics.info.types.MonitoredBlockCoords;
import sonar.logistics.network.sync.SyncMonitoredType;

@LogicInfoType(id="energy", modid="practicallogistics2")
public class MonitoredEnergyStack
extends BaseInfo<MonitoredEnergyStack>
implements IJoinableInfo<MonitoredEnergyStack>,
INameableInfo<MonitoredEnergyStack>,
IComparableInfo<MonitoredEnergyStack> {
    public static final String id = "energy";
    private SyncNBTAbstract<StoredEnergyStack> energyStack = new SyncNBTAbstract(StoredEnergyStack.class, 0);
    private SyncMonitoredType<MonitoredBlockCoords> coords = new SyncMonitoredType(1);
    private final SyncNBTAbstract<StoredItemStack> dropStack = new SyncNBTAbstract(StoredItemStack.class, 3);

    public MonitoredEnergyStack() {
        this.syncList.addParts(new IDirtyPart[]{this.energyStack, this.coords, this.dropStack});
    }

    public MonitoredEnergyStack(StoredEnergyStack stack, MonitoredBlockCoords coords, StoredItemStack dropstack) {
        this.syncList.addParts(new IDirtyPart[]{this.energyStack, this.coords, this.dropStack});
        this.energyStack.setObject((INBTSyncable)stack);
        this.coords.setInfo(coords);
        this.dropStack.setObject((INBTSyncable)dropstack);
    }

    public MonitoredEnergyStack(StoredEnergyStack stack, MonitoredBlockCoords coords) {
        this.syncList.addParts(new IDirtyPart[]{this.energyStack, this.coords, this.dropStack});
        this.energyStack.setObject((INBTSyncable)stack);
        this.coords.setInfo(coords);
        Item item = Item.func_150898_a((Block)coords.getCoords().getBlockState().func_177230_c());
        if (item != null) {
            this.dropStack.setObject((INBTSyncable)new StoredItemStack(new ItemStack(item, 1)));
        }
    }

    @Override
    public boolean isIdenticalInfo(MonitoredEnergyStack info) {
        return ((StoredEnergyStack)this.energyStack.getObject()).equals((Object)info.energyStack.getObject()) && this.coords.getMonitoredInfo().isIdenticalInfo(info.coords.getMonitoredInfo());
    }

    @Override
    public boolean isMatchingInfo(MonitoredEnergyStack info) {
        return this.coords.getMonitoredInfo().isMatchingInfo(info.coords.getMonitoredInfo());
    }

    @Override
    public boolean isMatchingType(IInfo info) {
        return info instanceof MonitoredEnergyStack;
    }

    @Override
    public EnergyNetworkHandler getHandler() {
        return EnergyNetworkHandler.INSTANCE;
    }

    @Override
    public boolean canJoinInfo(MonitoredEnergyStack info) {
        return false;
    }

    @Override
    public IJoinableInfo joinInfo(MonitoredEnergyStack info) {
        ((StoredEnergyStack)this.energyStack.getObject()).add((StoredEnergyStack)info.energyStack.getObject());
        this.energyStack.markChanged();
        return this;
    }

    @Override
    public boolean isValid() {
        return this.energyStack.getObject() != null && ((StoredEnergyStack)this.energyStack.getObject()).energyType != null && this.coords.getMonitoredInfo() != null;
    }

    @Override
    public String getID() {
        return id;
    }

    @Override
    public MonitoredEnergyStack copy() {
        return new MonitoredEnergyStack(((StoredEnergyStack)this.energyStack.getObject()).copy(), this.coords.getMonitoredInfo().copy(), ((StoredItemStack)this.dropStack.getObject()).copy());
    }

    @Override
    public void renderInfo(InfoContainer container, IDisplayInfo displayInfo, double width, double height, double scale, int infoPos) {
        GL11.glPushMatrix();
        GL11.glPushMatrix();
        GlStateManager.func_179140_f();
        GL11.glTranslated((double)-1.0, (double)-0.75, (double)0.004);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(InfoContainer.getColour(infoPos));
        InfoRenderer.renderProgressBar(width, height, scale, ((StoredEnergyStack)this.energyStack.obj).stored, ((StoredEnergyStack)this.energyStack.obj).capacity);
        GlStateManager.func_179145_e();
        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.001);
        GL11.glPopMatrix();
        InfoRenderer.renderNormalInfo(container.display.getDisplayType(), width, height, scale, displayInfo.getFormattedStrings());
        GL11.glPopMatrix();
    }

    @Override
    public String getClientIdentifier() {
        return this.energyStack.getObject() != null && ((StoredEnergyStack)this.energyStack.getObject()).energyType != null ? ((StoredEnergyStack)this.energyStack.getObject()).energyType.getName() : "ENERGYSTACK";
    }

    @Override
    public String getClientObject() {
        return this.energyStack.getObject() != null ? "" + FontHelper.formatStorage((EnergyType)((StoredEnergyStack)this.energyStack.obj).energyType, (long)((StoredEnergyStack)this.energyStack.getObject()).stored) + " / " + FontHelper.formatStorage((EnergyType)((StoredEnergyStack)this.energyStack.obj).energyType, (long)((StoredEnergyStack)this.energyStack.getObject()).capacity) : "ERROR";
    }

    @Override
    public String getClientType() {
        return id;
    }

    public MonitoredBlockCoords getMonitoredCoords() {
        return this.coords.getMonitoredInfo();
    }

    public StoredEnergyStack getEnergyStack() {
        return (StoredEnergyStack)this.energyStack.getObject();
    }

    public StoredItemStack getDropStack() {
        return (StoredItemStack)this.dropStack.getObject();
    }

    @Override
    public List<ComparableObject> getComparableObjects(List<ComparableObject> objects) {
        BlockCoords blockCoords = this.getMonitoredCoords().getCoords();
        StoredEnergyStack stack = this.getEnergyStack();
        objects.add(new ComparableObject(this, "x", blockCoords.getX()));
        objects.add(new ComparableObject(this, "y", blockCoords.getY()));
        objects.add(new ComparableObject(this, "z", blockCoords.getZ()));
        objects.add(new ComparableObject(this, "input", stack.input));
        objects.add(new ComparableObject(this, "output", stack.output));
        objects.add(new ComparableObject(this, "stored", stack.stored));
        objects.add(new ComparableObject(this, "capacity", stack.capacity));
        objects.add(new ComparableObject(this, "types", stack.energyType.toString()));
        return objects;
    }
}

