/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import java.util.List;
import mcmultipart.raytrace.PartMOP;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import sonar.core.api.fluids.StoredFluidStack;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.api.utils.BlockInteractionType;
import sonar.core.helpers.FontHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncNBTAbstract;
import sonar.core.network.sync.SyncTagType;
import sonar.logistics.api.asm.LogicInfoType;
import sonar.logistics.api.info.IBasicClickableInfo;
import sonar.logistics.api.info.IComparableInfo;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.IJoinableInfo;
import sonar.logistics.api.info.INameableInfo;
import sonar.logistics.api.info.render.IDisplayInfo;
import sonar.logistics.api.info.render.InfoContainer;
import sonar.logistics.api.tiles.signaller.ComparableObject;
import sonar.logistics.connections.handlers.FluidNetworkHandler;
import sonar.logistics.helpers.InfoHelper;
import sonar.logistics.helpers.InfoRenderer;
import sonar.logistics.info.types.BaseInfo;

@LogicInfoType(id="fluid", modid="practicallogistics2")
public class MonitoredFluidStack
extends BaseInfo<MonitoredFluidStack>
implements IJoinableInfo<MonitoredFluidStack>,
INameableInfo<MonitoredFluidStack>,
IBasicClickableInfo,
IComparableInfo<MonitoredFluidStack> {
    public static final String id = "fluid";
    private SyncNBTAbstract<StoredFluidStack> fluidStack = new SyncNBTAbstract(StoredFluidStack.class, 0);
    private final SyncTagType.INT networkID = (SyncTagType.INT)new SyncTagType.INT(1).setDefault((Object)-1);

    public MonitoredFluidStack() {
        this.syncList.addParts(new IDirtyPart[]{this.fluidStack, this.networkID});
    }

    public MonitoredFluidStack(StoredFluidStack stack) {
        this.syncList.addParts(new IDirtyPart[]{this.fluidStack, this.networkID});
        this.fluidStack.setObject((INBTSyncable)stack);
    }

    public MonitoredFluidStack(StoredFluidStack stack, int networkID) {
        this.syncList.addParts(new IDirtyPart[]{this.fluidStack, this.networkID});
        this.fluidStack.setObject((INBTSyncable)stack);
        this.networkID.setObject((Object)networkID);
    }

    @Override
    public boolean isIdenticalInfo(MonitoredFluidStack info) {
        return this.getStoredStack().equals((Object)info.getStoredStack()) && ((Integer)this.networkID.getObject()).equals(info.networkID.getObject());
    }

    @Override
    public boolean isMatchingInfo(MonitoredFluidStack info) {
        return this.getStoredStack().equalStack(info.getFluidStack());
    }

    @Override
    public boolean isMatchingType(IInfo info) {
        return info instanceof MonitoredFluidStack;
    }

    @Override
    public FluidNetworkHandler getHandler() {
        return FluidNetworkHandler.INSTANCE;
    }

    @Override
    public boolean canJoinInfo(MonitoredFluidStack info) {
        return this.isMatchingInfo(info);
    }

    @Override
    public IJoinableInfo joinInfo(MonitoredFluidStack info) {
        ((StoredFluidStack)this.fluidStack.getObject()).add((StoredFluidStack)info.fluidStack.getObject());
        return this;
    }

    @Override
    public boolean isValid() {
        return this.fluidStack.getObject() != null && ((StoredFluidStack)this.fluidStack.getObject()).fluid != null;
    }

    @Override
    public String getID() {
        return id;
    }

    @Override
    public MonitoredFluidStack copy() {
        return new MonitoredFluidStack(((StoredFluidStack)this.fluidStack.getObject()).copy(), (Integer)this.networkID.getObject());
    }

    @Override
    public void renderInfo(InfoContainer container, IDisplayInfo displayInfo, double width, double height, double scale, int infoPos) {
        FluidStack stack = ((StoredFluidStack)this.fluidStack.getObject()).fluid;
        if (stack != null) {
            GL11.glPushMatrix();
            GL11.glPushMatrix();
            GlStateManager.func_179140_f();
            GL11.glTranslated((double)-1.0, (double)-0.75, (double)0.004);
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().getTextureExtry(stack.getFluid().getStill().toString());
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            InfoRenderer.renderProgressBarWithSprite(sprite, width, height, scale, ((StoredFluidStack)this.fluidStack.getObject()).stored, ((StoredFluidStack)this.fluidStack.getObject()).capacity);
            GlStateManager.func_179145_e();
            GL11.glTranslated((double)0.0, (double)0.0, (double)-0.001);
            GL11.glPopMatrix();
            InfoRenderer.renderNormalInfo(container.display.getDisplayType(), width, height, scale, displayInfo.getFormattedStrings());
            GL11.glPopMatrix();
        }
    }

    @Override
    public String getClientIdentifier() {
        return this.fluidStack.getObject() != null && ((StoredFluidStack)this.fluidStack.getObject()).fluid != null ? ((StoredFluidStack)this.fluidStack.getObject()).fluid.getLocalizedName() : "FLUIDSTACK";
    }

    @Override
    public String getClientObject() {
        return this.fluidStack.getObject() != null ? "" + FontHelper.formatFluidSize((long)((StoredFluidStack)this.fluidStack.getObject()).stored) : "ERROR";
    }

    @Override
    public String getClientType() {
        return id;
    }

    @Override
    public boolean onStandardClick(BlockInteractionType type, boolean doubleClick, IDisplayInfo renderInfo, EntityPlayer player, EnumHand hand, ItemStack stack, PartMOP hit, InfoContainer container) {
        if (InfoHelper.canBeClickedStandard(renderInfo.getRenderProperties(), player, hand, stack, hit)) {
            if (!player.func_130014_f_().field_72995_K) {
                InfoHelper.screenFluidStackClicked((StoredFluidStack)this.fluidStack.getObject(), (Integer)this.networkID.getObject(), type, doubleClick, renderInfo.getRenderProperties(), player, hand, stack, hit);
            }
            return true;
        }
        return false;
    }

    @Override
    public List<ComparableObject> getComparableObjects(List<ComparableObject> objects) {
        StoredFluidStack stack = (StoredFluidStack)this.fluidStack.getObject();
        objects.add(new ComparableObject(this, "Stored", stack.stored));
        objects.add(new ComparableObject(this, "Capacity", stack.capacity));
        return objects;
    }

    public String toString() {
        return ((StoredFluidStack)this.fluidStack.getObject()).toString();
    }

    public FluidStack getFluidStack() {
        return ((StoredFluidStack)this.fluidStack.getObject()).getFullStack();
    }

    public StoredFluidStack getStoredStack() {
        return (StoredFluidStack)this.fluidStack.getObject();
    }

    public long getStored() {
        return ((StoredFluidStack)this.fluidStack.getObject()).stored;
    }
}

