/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import java.util.List;
import mcmultipart.raytrace.PartMOP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import org.lwjgl.opengl.GL11;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.api.utils.BlockInteractionType;
import sonar.core.helpers.RenderHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncNBTAbstract;
import sonar.core.network.sync.SyncTagType;
import sonar.logistics.api.asm.LogicInfoType;
import sonar.logistics.api.info.IBasicClickableInfo;
import sonar.logistics.api.info.IComparableInfo;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.IJoinableInfo;
import sonar.logistics.api.info.INameableInfo;
import sonar.logistics.api.info.IProvidableInfo;
import sonar.logistics.api.info.render.IDisplayInfo;
import sonar.logistics.api.info.render.InfoContainer;
import sonar.logistics.api.register.LogicPath;
import sonar.logistics.api.register.RegistryType;
import sonar.logistics.api.tiles.displays.DisplayType;
import sonar.logistics.api.tiles.signaller.ComparableObject;
import sonar.logistics.connections.handlers.ItemNetworkHandler;
import sonar.logistics.helpers.InfoHelper;
import sonar.logistics.info.types.BaseInfo;

@LogicInfoType(id="item", modid="practicallogistics2")
public class MonitoredItemStack
extends BaseInfo<MonitoredItemStack>
implements IProvidableInfo<MonitoredItemStack>,
IJoinableInfo<MonitoredItemStack>,
IBasicClickableInfo,
INameableInfo<MonitoredItemStack>,
IComparableInfo<MonitoredItemStack> {
    public static final String id = "item";
    private final SyncNBTAbstract<StoredItemStack> itemStack = new SyncNBTAbstract(StoredItemStack.class, 0);
    private final SyncTagType.INT networkID = (SyncTagType.INT)new SyncTagType.INT(1).setDefault((Object)-1);

    public MonitoredItemStack() {
        this.syncList.addParts(new IDirtyPart[]{this.itemStack, this.networkID});
    }

    public MonitoredItemStack(StoredItemStack stack, int networkID) {
        this(stack);
        this.networkID.setObject((Object)networkID);
    }

    public MonitoredItemStack(StoredItemStack stack) {
        this.syncList.addParts(new IDirtyPart[]{this.itemStack, this.networkID});
        this.itemStack.setObject((INBTSyncable)stack);
    }

    @Override
    public boolean isIdenticalInfo(MonitoredItemStack info) {
        return this.getStoredStack().equals((Object)info.getStoredStack());
    }

    @Override
    public boolean isMatchingInfo(MonitoredItemStack info) {
        return this.getStoredStack().equalStack(info.getStoredStack().getItemStack());
    }

    @Override
    public boolean isMatchingType(IInfo info) {
        return info instanceof MonitoredItemStack;
    }

    @Override
    public ItemNetworkHandler getHandler() {
        return ItemNetworkHandler.INSTANCE;
    }

    @Override
    public boolean canJoinInfo(MonitoredItemStack info) {
        return this.isMatchingInfo(info);
    }

    @Override
    public IJoinableInfo joinInfo(MonitoredItemStack info) {
        ((StoredItemStack)this.itemStack.getObject()).add((StoredItemStack)info.itemStack.getObject());
        return this;
    }

    @Override
    public boolean isValid() {
        return this.itemStack.getObject() != null && ((StoredItemStack)this.itemStack.getObject()).item != null;
    }

    @Override
    public String getID() {
        return id;
    }

    public String toString() {
        if (this.itemStack.getObject() != null) {
            return ((StoredItemStack)this.itemStack.getObject()).toString();
        }
        return super.toString() + " : NULL";
    }

    public ItemStack getItemStack() {
        return ((StoredItemStack)this.itemStack.getObject()).getItemStack();
    }

    public StoredItemStack getStoredStack() {
        return (StoredItemStack)this.itemStack.getObject();
    }

    public long getStored() {
        return ((StoredItemStack)this.itemStack.getObject()).stored;
    }

    public int getNetworkSource() {
        return (Integer)this.networkID.getObject();
    }

    public void setNetworkSource(int id) {
        this.networkID.setObject((Object)id);
    }

    @Override
    public MonitoredItemStack copy() {
        return new MonitoredItemStack(((StoredItemStack)this.itemStack.getObject()).copy(), (Integer)this.networkID.getObject());
    }

    @Override
    public void renderInfo(InfoContainer container, IDisplayInfo displayInfo, double width, double height, double scale, int infoPos) {
        if (this.itemStack.getObject() != null) {
            DisplayType type = container.display.getDisplayType();
            StoredItemStack stack = (StoredItemStack)this.itemStack.getObject();
            ItemStack item = stack.item;
            GlStateManager.func_179123_a();
            GL11.glPushMatrix();
            GlStateManager.func_179126_j();
            GL11.glTranslated((double)(-(1.0 - width / 2.0 - 0.0625)), (double)(-0.68 + height / 2.0), (double)0.0);
            GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glScaled((double)-1.0, (double)1.0, (double)1.0);
            double actualScale = type == DisplayType.LARGE ? scale * 3.0 : scale * 2.0;
            GL11.glScaled((double)actualScale, (double)actualScale, (double)0.01);
            double trans = type == DisplayType.SMALL ? 4.0 : -7.0;
            GL11.glTranslated((double)-8.0, (double)-8.0, (double)0.0);
            GlStateManager.func_179140_f();
            GlStateManager.func_179088_q();
            GlStateManager.func_179136_a((float)-1.0f, (float)-1.0f);
            GlStateManager.func_179089_o();
            RenderHelper.renderItemIntoGUI((ItemStack)item, (int)0, (int)0);
            GlStateManager.func_179113_r();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)2.0f);
            GlStateManager.func_179132_a((boolean)false);
            RenderHelper.renderStoredItemStackOverlay((ItemStack)item, (long)0L, (int)0, (int)0, (String)("" + stack.stored), (boolean)false);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179097_i();
            GL11.glPopMatrix();
            GlStateManager.func_179099_b();
        }
    }

    @Override
    public boolean onStandardClick(BlockInteractionType type, boolean doubleClick, IDisplayInfo renderInfo, EntityPlayer player, EnumHand hand, ItemStack stack, PartMOP hit, InfoContainer container) {
        if (InfoHelper.canBeClickedStandard(renderInfo.getRenderProperties(), player, hand, stack, hit)) {
            if (!player.func_130014_f_().field_72995_K) {
                InfoHelper.screenItemStackClicked((StoredItemStack)this.itemStack.getObject(), (Integer)this.networkID.getObject(), type, doubleClick, renderInfo.getRenderProperties(), player, hand, stack, hit);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getClientIdentifier() {
        return "Item: " + (this.itemStack.getObject() != null && ((StoredItemStack)this.itemStack.getObject()).getItemStack() != null ? ((StoredItemStack)this.itemStack.getObject()).getItemStack().func_82833_r() : "ITEMSTACK");
    }

    @Override
    public String getClientObject() {
        return this.itemStack.getObject() != null ? "" + ((StoredItemStack)this.itemStack.getObject()).stored : "ERROR";
    }

    @Override
    public String getClientType() {
        return id;
    }

    @Override
    public List<ComparableObject> getComparableObjects(List<ComparableObject> objects) {
        StoredItemStack stack = (StoredItemStack)this.itemStack.getObject();
        objects.add(new ComparableObject(this, "Stored", stack.stored));
        objects.add(new ComparableObject(this, "Damage", stack != null ? stack.getItemDamage() : -1));
        objects.add(new ComparableObject(this, "NBT", stack.item.func_77942_o() ? stack.getTagCompound() : new NBTTagCompound()));
        return objects;
    }

    @Override
    public RegistryType getRegistryType() {
        return RegistryType.TILE;
    }

    @Override
    public MonitoredItemStack setRegistryType(RegistryType type) {
        return this;
    }

    @Override
    public void setFromReturn(LogicPath path, Object returned) {
    }

    public static MonitoredItemStack findItemStack(List<MonitoredItemStack> stacks, ItemStack item) {
        for (MonitoredItemStack i : stacks) {
            if (!i.getStoredStack().equalStack(item)) continue;
            return i;
        }
        return null;
    }
}

