/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.api.asm.LogicInfoType;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.INameableInfo;
import sonar.logistics.api.info.ISuffixable;
import sonar.logistics.api.info.render.IDisplayInfo;
import sonar.logistics.api.info.render.InfoContainer;
import sonar.logistics.api.networks.INetworkHandler;
import sonar.logistics.api.register.LogicPath;
import sonar.logistics.helpers.InfoHelper;
import sonar.logistics.helpers.InfoRenderer;
import sonar.logistics.info.types.LogicInfo;

@LogicInfoType(id="progress", modid="practicallogistics2")
public class ProgressInfo
implements IInfo<ProgressInfo>,
INBTSyncable,
INameableInfo<ProgressInfo>,
ISuffixable {
    public static final String id = "progress";
    public LogicInfo first;
    public LogicInfo second;
    public int compare;
    public double firstNum;
    public double secondNum;

    public ProgressInfo() {
    }

    public ProgressInfo(IInfo first, IInfo second) {
        this.first = (LogicInfo)first;
        this.second = (LogicInfo)second;
        this.checkInfo();
    }

    public static boolean isStorableInfo(IInfo info) {
        return info != null && info instanceof LogicInfo;
    }

    public void checkInfo() {
        if (this.isValid() && this.first.getInfoType().isNumber() && this.second.getInfoType().isNumber()) {
            this.firstNum = Double.valueOf(this.first.getInfo().toString());
            this.secondNum = Double.valueOf(this.second.getInfo().toString());
            this.compare = Double.compare(this.firstNum, this.secondNum);
        }
    }

    @Override
    public String getClientIdentifier() {
        if (!this.isValid()) {
            return "ERROR";
        }
        return (this.compare == 1 ? this.second : this.first).getClientIdentifier();
    }

    @Override
    public String getRawData() {
        if (!this.isValid()) {
            return "ERROR";
        }
        return (this.compare == 1 ? this.second : this.first).getRawData();
    }

    @Override
    public String getClientObject() {
        if (!this.isValid()) {
            return "ERROR";
        }
        return (this.compare == 1 ? this.second : this.first).getClientObject();
    }

    @Override
    public String getClientType() {
        return "Progress";
    }

    @Override
    public String getSuffix() {
        if (!this.isValid()) {
            return "ERROR";
        }
        return (this.compare == 1 ? this.second : this.first).getSuffix();
    }

    @Override
    public String getPrefix() {
        if (!this.isValid()) {
            return "ERROR";
        }
        return (this.compare == 1 ? this.second : this.first).getPrefix();
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.first = (LogicInfo)InfoHelper.loadInfo(InfoHelper.getName("logic"), nbt.func_74775_l("first"));
        this.second = (LogicInfo)InfoHelper.loadInfo(InfoHelper.getName("logic"), nbt.func_74775_l("second"));
        this.checkInfo();
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        nbt.func_74782_a("first", (NBTBase)InfoHelper.writeInfoToNBT(new NBTTagCompound(), this.first, type));
        nbt.func_74782_a("second", (NBTBase)InfoHelper.writeInfoToNBT(new NBTTagCompound(), this.second, type));
        return nbt;
    }

    @Override
    public boolean isIdenticalInfo(ProgressInfo info) {
        return info.first.isIdenticalInfo(this.first) && info.second.isIdenticalInfo(this.second);
    }

    @Override
    public boolean isMatchingInfo(ProgressInfo info) {
        return info.first.isMatchingInfo(this.first) && info.second.isMatchingInfo(this.second);
    }

    @Override
    public boolean isMatchingType(IInfo info) {
        return info instanceof ProgressInfo;
    }

    @Override
    public boolean isHeader() {
        return false;
    }

    @Override
    public INetworkHandler getHandler() {
        return null;
    }

    @Override
    public boolean isValid() {
        return this.first != null && this.second != null && this.first.isValid() && this.second.isValid();
    }

    @Override
    public String getID() {
        return id;
    }

    @Override
    public ProgressInfo copy() {
        return new ProgressInfo(this.first.copy(), this.second.copy());
    }

    @Override
    public void renderInfo(InfoContainer container, IDisplayInfo displayInfo, double displayWidth, double displayHeight, double displayScale, int infoPos) {
        GL11.glPushMatrix();
        GL11.glPushMatrix();
        GlStateManager.func_179140_f();
        GL11.glTranslated((double)-1.0, (double)-0.75, (double)0.004);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(InfoContainer.getColour(infoPos));
        double num1 = this.compare == 1 ? this.secondNum : this.firstNum;
        double num2 = this.compare == 1 ? this.firstNum : this.secondNum;
        InfoRenderer.renderProgressBar(displayWidth, displayHeight, displayScale, num1 < 0.0 ? 0.0 : num1, num2);
        GlStateManager.func_179145_e();
        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.001);
        GL11.glPopMatrix();
        InfoRenderer.renderNormalInfo(container.display.getDisplayType(), displayWidth, displayHeight, displayScale, displayInfo.getFormattedStrings());
        GL11.glPopMatrix();
    }

    @Override
    public void identifyChanges(ProgressInfo newInfo) {
        this.first.identifyChanges(newInfo.first);
        this.second.identifyChanges(newInfo.second);
    }

    @Override
    public LogicPath getPath() {
        return null;
    }

    @Override
    public ProgressInfo setPath(LogicPath path) {
        return this;
    }

    @Override
    public void renderSizeChanged(InfoContainer container, IDisplayInfo displayInfo, double width, double height, double scale, int infoPos) {
    }

    @Override
    public void onInfoStored() {
        this.first.onInfoStored();
        this.second.onInfoStored();
    }
}

