/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.integration;

import java.util.List;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.item.ItemStack;
import sonar.core.helpers.ItemStackHelper;
import sonar.core.integration.jei.IJEIHandler;
import sonar.core.integration.jei.JEICategoryV2;
import sonar.core.integration.jei.JEIHelper;
import sonar.core.integration.jei.JEIRecipeV2;
import sonar.core.recipes.IRecipeHelperV2;
import sonar.logistics.PL2;
import sonar.logistics.PL2Blocks;
import sonar.logistics.client.gui.GuiHammer;
import sonar.logistics.common.containers.ContainerHammer;
import sonar.logistics.common.hammer.HammerRecipes;
import sonar.logistics.integration.ForgingHammerJEI;

@JEIPlugin
public class PracticalLogisticsJEI
extends BlankModPlugin {
    public void register(IModRegistry registry) {
        PL2.logger.info("Starting JEI Integration");
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        for (Handlers handler : Handlers.values()) {
            registry.addRecipes(handler.getJEIRecipes());
            JEICategoryV2 cat = handler.getCategory(guiHelper);
            registry.addRecipeCategories(new IRecipeCategory[]{cat});
            registry.addRecipeHandlers(new IRecipeHandler[]{cat});
            if (handler.getCrafterItemStack() != null) {
                registry.addRecipeCategoryCraftingItem(handler.getCrafterItemStack(), new String[]{handler.getUUID()});
            }
            PL2.logger.info("Registering Recipe Handler: " + handler.getUUID());
        }
        IRecipeTransferRegistry recipeTransferRegistry = registry.getRecipeTransferRegistry();
        registry.addRecipeClickArea(GuiHammer.class, 79, 26, 18, 8, new String[]{Handlers.HAMMER.getUUID()});
        recipeTransferRegistry.addRecipeTransferHandler(ContainerHammer.class, Handlers.HAMMER.getUUID(), 0, 1, 2, 36);
        PL2.logger.info("Finished JEI Integration");
    }

    public static enum Handlers implements IJEIHandler
    {
        HAMMER((IRecipeHelperV2)HammerRecipes.instance(), PL2Blocks.hammer, "hammer", ForgingHammerJEI.Hammer.class);

        public IRecipeHelperV2 helper;
        public String unlocalizedName;
        public String textureName;
        public Class<? extends JEIRecipeV2> recipeClass;
        public ItemStack crafter;

        private Handlers(IRecipeHelperV2 helper, Object stack, String textureName, Class<? extends JEIRecipeV2> recipeClass) {
            this.helper = helper;
            this.crafter = ItemStackHelper.createStack((Object)stack);
            this.unlocalizedName = this.crafter.func_77977_a() + ".name";
            this.textureName = textureName;
            this.recipeClass = recipeClass;
        }

        public JEICategoryV2 getCategory(IGuiHelper guiHelper) {
            switch (this) {
                case HAMMER: {
                    return new ForgingHammerJEI(guiHelper, this);
                }
            }
            return null;
        }

        public String getTextureName() {
            return this.textureName;
        }

        public String getTitle() {
            return this.unlocalizedName;
        }

        public Class<? extends JEIRecipeV2> getRecipeClass() {
            return this.recipeClass;
        }

        public IRecipeHelperV2 getRecipeHelper() {
            return this.helper;
        }

        public List<JEIRecipeV2> getJEIRecipes() {
            return JEIHelper.getJEIRecipes((IRecipeHelperV2)this.helper, this.recipeClass);
        }

        public ItemStack getCrafterItemStack() {
            return this.crafter;
        }

        public String getUUID() {
            return this.helper.getRecipeID();
        }
    }
}

