/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.managers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sonar.core.api.utils.BlockCoords;
import sonar.core.utils.Pair;
import sonar.logistics.PL2;
import sonar.logistics.api.tiles.IConnectable;
import sonar.logistics.api.tiles.cable.ConnectableType;
import sonar.logistics.managers.NetworkManager;

public abstract class AbstractConnectionManager<T extends IConnectable> {
    protected Map<Integer, List<T>> connections = new ConcurrentHashMap<Integer, List<T>>();
    private NetworkManager NetworkManager;

    public void removeAll() {
        this.connections.clear();
    }

    public NetworkManager NetworkManager() {
        if (this.NetworkManager == null) {
            this.NetworkManager = PL2.instance.networkManager;
        }
        return this.NetworkManager;
    }

    public int getNextAvailableID() {
        for (int i = 0; i < this.connections.size(); ++i) {
            if (this.connections.get(i) != null && !this.connections.get(i).isEmpty() && this.connections.get(i).size() != 0) continue;
            return i;
        }
        return this.connections.size();
    }

    /*
     * WARNING - void declaration
     */
    public List<T> getConnections(int registryID) {
        void var2_2;
        List<T> coords;
        return registryID == -1 || (coords = this.connections.get(registryID)) == null ? Lists.newArrayList() : var2_2;
    }

    public void addConnections(int registryID, List<T> connections) {
        connections.forEach(connection -> this.addConnection(registryID, connection, false));
    }

    public int addConnection(T cable) {
        ArrayList connections = Lists.newArrayList();
        int cableID = cable.getRegistryID();
        int lastSize = -1;
        BlockCoords coords = cable.getCoords();
        World world = coords.getWorld();
        BlockPos pos = coords.getBlockPos();
        for (EnumFacing dir : EnumFacing.values()) {
            if (!cable.canConnectOnSide(cable.getRegistryID(), dir, false)) continue;
            Pair<ConnectableType, Integer> connection = this.getConnectionType(cable, world, pos, dir, cable.getConnectableType());
            if (connection.a == ConnectableType.NONE || (Integer)connection.b == -1) continue;
            List<T> cables = this.getConnections((Integer)connection.b);
            if (cables.size() > lastSize) {
                cableID = (Integer)connection.b;
                lastSize = cables.size();
            }
            connections.add(connection);
        }
        cableID = cableID == -1 ? this.getNextAvailableID() : cableID;
        this.addConnection(cableID, cable, true);
        for (Pair connection : connections) {
            if ((Integer)connection.b == cableID) continue;
            this.connectNetworks(cableID, (Integer)connection.b);
        }
        return cableID;
    }

    public void addConnection(int registryID, T connection, boolean refreshCache) {
        if (registryID != -1 && connection != null) {
            List<T> network = this.connections.get(registryID);
            if (network == null) {
                this.connections.put(registryID, Lists.newArrayList());
                network = this.connections.get(registryID);
            }
            if (network != null && network.contains(connection)) {
                return;
            }
            connection.setRegistryID(registryID);
            network.add(connection);
            if (refreshCache) {
                this.onConnectionAdded(registryID, connection);
            }
        }
    }

    public void removeConnection(T connection) {
        int registryID = connection.getRegistryID();
        if (registryID != -1 && connection.getCoords() != null) {
            ArrayList allConnections = this.connections.get(registryID);
            if (allConnections == null) {
                return;
            }
            allConnections.remove(connection);
            this.onConnectionRemoved(registryID, connection);
            int newID = this.getNextAvailableID();
            allConnections = Lists.newArrayList(allConnections);
            this.connections.get(registryID).clear();
            this.connections.remove(registryID);
            ArrayList newNetworks = Lists.newArrayList();
            allConnections.forEach(oldCable -> oldCable.setRegistryID(-1));
            allConnections.forEach(oldCable -> {
                oldCable.addConnection();
                newNetworks.add(oldCable.getRegistryID());
            });
            this.onNetworksDisconnected(newNetworks);
        }
    }

    public void refreshConnections(T cable) {
        BlockCoords coords = cable.getCoords();
        for (EnumFacing dir : EnumFacing.values()) {
            Pair<ConnectableType, Integer> connection = this.getConnectionType(cable, coords.getWorld(), coords.getBlockPos(), dir, cable.getConnectableType());
            boolean canConnect = cable.canConnectOnSide(cable.getRegistryID(), dir, false);
            if (!canConnect && ((ConnectableType)((Object)connection.a)).canConnect(cable.getConnectableType())) {
                cable.removeConnection();
                cable.addConnection();
                continue;
            }
            if (!canConnect || !((ConnectableType)((Object)connection.a)).canConnect(cable.getConnectableType()) || ((Integer)connection.b).intValue() == cable.getRegistryID()) continue;
            this.connectNetworks(cable.getRegistryID(), (Integer)connection.b);
        }
    }

    public abstract Pair<ConnectableType, Integer> getConnectionType(T var1, World var2, BlockPos var3, EnumFacing var4, ConnectableType var5);

    public void connectNetworks(int newID, int secondaryID) {
        List<T> oldConnections = this.connections.get(secondaryID);
        if (oldConnections == null) {
            return;
        }
        this.addConnections(newID, oldConnections);
        oldConnections.clear();
        this.connections.remove(secondaryID);
        this.onNetworksConnected(newID, secondaryID);
    }

    public abstract void onNetworksDisconnected(List<Integer> var1);

    public abstract void onNetworksConnected(int var1, int var2);

    public abstract void onConnectionAdded(int var1, T var2);

    public abstract void onConnectionRemoved(int var1, T var2);
}

