/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.managers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.World;
import sonar.logistics.api.IInfoManager;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.tiles.displays.ConnectedDisplay;
import sonar.logistics.api.tiles.displays.IDisplay;
import sonar.logistics.api.tiles.displays.ILargeDisplay;
import sonar.logistics.api.tiles.readers.ClientLocalProvider;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.api.viewers.ILogicListenable;
import sonar.logistics.api.wireless.ClientDataEmitter;

public class ClientInfoManager
implements IInfoManager {
    public Map<Integer, ConnectedDisplay> connectedDisplays = new ConcurrentHashMap<Integer, ConnectedDisplay>();
    public List<IDisplay> displays = Lists.newArrayList();
    public Map<InfoUUID, IInfo> info = Maps.newLinkedHashMap();
    public Map<Integer, List<Object>> sortedLogicMonitors = new ConcurrentHashMap<Integer, List<Object>>();
    public Map<Integer, List<ClientLocalProvider>> clientLogicMonitors = new ConcurrentHashMap<Integer, List<ClientLocalProvider>>();
    public Map<InfoUUID, MonitoredList<?>> monitoredLists = Maps.newLinkedHashMap();
    public Map<Integer, ILogicListenable> monitors = Maps.newLinkedHashMap();
    public Map<Integer, MonitoredList<IInfo>> channelMap = new ConcurrentHashMap<Integer, MonitoredList<IInfo>>();
    public List<ClientDataEmitter> clientEmitters = new ArrayList<ClientDataEmitter>();

    @Override
    public void removeAll() {
        this.connectedDisplays.clear();
        this.info.clear();
        this.sortedLogicMonitors.clear();
        this.clientLogicMonitors.clear();
        this.monitoredLists.clear();
        this.monitors.clear();
        this.channelMap.clear();
        this.clientEmitters.clear();
    }

    @Override
    public IInfo getInfoFromUUID(InfoUUID uuid) {
        return this.info.get(uuid);
    }

    @Override
    public void setInfo(InfoUUID uuid, IInfo newInfo) {
        this.info.put(uuid, newInfo);
        this.onInfoChanged(uuid, newInfo);
    }

    @Override
    public void addIdentityTile(ILogicListenable infoProvider) {
        if (this.monitors.containsValue(infoProvider) || infoProvider.getIdentity() == -1) {
            return;
        }
        this.monitors.put(infoProvider.getIdentity(), infoProvider);
    }

    @Override
    public void removeIdentityTile(ILogicListenable monitor) {
        this.monitors.remove(monitor.getIdentity());
    }

    @Override
    public void addDisplay(IDisplay display) {
        if (!this.displays.contains(display)) {
            this.displays.add(display);
        }
    }

    @Override
    public void removeDisplay(IDisplay display) {
        this.displays.remove(display);
    }

    @Override
    public Map<Integer, ILogicListenable> getMonitors() {
        return this.monitors;
    }

    @Override
    public Map<InfoUUID, IInfo> getInfoList() {
        return this.info;
    }

    public void onInfoChanged(InfoUUID uuid, IInfo info) {
        for (IDisplay display : this.displays) {
            if (!display.container().isDisplayingUUID(uuid)) continue;
            display.container().onInfoChanged(uuid, info);
        }
    }

    public void onMonitoredListChanged(InfoUUID uuid, MonitoredList list) {
        for (IDisplay display : this.displays) {
            if (!display.container().isDisplayingUUID(uuid)) continue;
            display.container().onMonitoredListChanged(uuid, list);
        }
    }

    @Override
    public <T extends IInfo> MonitoredList<T> getMonitoredList(int networkID, InfoUUID uuid) {
        MonitoredList list = MonitoredList.newMonitoredList(networkID);
        this.monitoredLists.putIfAbsent(uuid, list);
        for (Map.Entry<InfoUUID, MonitoredList<?>> entry : this.monitoredLists.entrySet()) {
            if (entry.getValue().networkID != networkID || !entry.getKey().equals(uuid)) continue;
            return entry.getValue();
        }
        return list;
    }

    @Override
    public ConnectedDisplay getOrCreateDisplayScreen(World world, ILargeDisplay display, int registryID) {
        Map<Integer, ConnectedDisplay> displays = this.getConnectedDisplays();
        ConnectedDisplay toSet = displays.get(registryID);
        if (toSet == null) {
            displays.put(registryID, new ConnectedDisplay(display));
            toSet = displays.get(registryID);
        }
        return toSet;
    }

    @Override
    public Map<Integer, ConnectedDisplay> getConnectedDisplays() {
        return this.connectedDisplays;
    }
}

