/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.managers;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sonar.core.api.utils.BlockCoords;
import sonar.core.utils.Pair;
import sonar.logistics.PL2;
import sonar.logistics.api.PL2API;
import sonar.logistics.api.tiles.cable.ConnectableType;
import sonar.logistics.api.tiles.displays.ConnectedDisplay;
import sonar.logistics.api.tiles.displays.IDisplay;
import sonar.logistics.api.tiles.displays.ILargeDisplay;
import sonar.logistics.managers.AbstractConnectionManager;

public class DisplayManager
extends AbstractConnectionManager<ILargeDisplay> {
    public List<Integer> lockedIDs = Lists.newArrayList();

    @Override
    public int getNextAvailableID() {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.lockedIDs.contains(i)) continue;
            if (i < this.connections.size()) {
                if (this.connections.get(i) != null && !((List)this.connections.get(i)).isEmpty() && ((List)this.connections.get(i)).size() != 0) continue;
                return i;
            }
            return i;
        }
        return -1;
    }

    @Override
    public void onNetworksConnected(int newID, int oldID) {
        ConnectedDisplay screen = PL2.getServerManager().getConnectedDisplays().get(newID);
        PL2.getServerManager().getConnectedDisplays().remove(oldID);
        if (screen != null) {
            screen.setHasChanged();
        } else {
            PL2.logger.error("CONNECTED DISPLAY SCREEN SHOULD NOT BE NULL!");
        }
    }

    @Override
    public void onConnectionAdded(int registryID, ILargeDisplay added) {
        if (registryID != -1) {
            ConnectedDisplay screen = PL2.getServerManager().getConnectedDisplays().get(registryID);
            if (screen == null) {
                screen = new ConnectedDisplay(added);
                PL2.getServerManager().getConnectedDisplays().put(registryID, screen);
            }
            screen.setHasChanged();
        }
    }

    @Override
    public Pair<ConnectableType, Integer> getConnectionType(ILargeDisplay source, World world, BlockPos pos, EnumFacing dir, ConnectableType cableType) {
        ILargeDisplay largeDisplay;
        IDisplay display = PL2API.getCableHelper().getDisplayScreen(new BlockCoords(pos.func_177972_a(dir)), source.getCableFace());
        if (display != null && display instanceof ILargeDisplay && (largeDisplay = (ILargeDisplay)display).getCableFace().equals((Object)source.getCableFace()) && source.canConnectOnSide(largeDisplay.getRegistryID(), dir.func_176734_d(), false) && largeDisplay.canConnectOnSide(source.getRegistryID(), dir, false)) {
            return new Pair((Object)ConnectableType.CONNECTABLE, (Object)largeDisplay.getRegistryID());
        }
        return new Pair((Object)ConnectableType.NONE, (Object)-1);
    }

    public Pair<ConnectableType, Integer> getConnectionTypeFromObject(ILargeDisplay source, Object connection, EnumFacing dir, ConnectableType cableType) {
        return new Pair((Object)ConnectableType.NONE, (Object)-1);
    }

    public void tick() {
        Map<Integer, ConnectedDisplay> connected = PL2.getServerManager().getConnectedDisplays();
        if (!connected.isEmpty()) {
            connected.entrySet().forEach(entry -> ((ConnectedDisplay)entry.getValue()).update((Integer)entry.getKey()));
        }
    }

    @Override
    public void onConnectionRemoved(int registryID, ILargeDisplay added) {
        PL2.getServerManager().removeDisplay(added);
        if (this.getConnections(registryID).isEmpty()) {
            PL2.getServerManager().getConnectedDisplays().remove(registryID);
        } else {
            ConnectedDisplay screen = PL2.getServerManager().getConnectedDisplays().get(registryID);
            screen.setHasChanged();
        }
    }

    @Override
    public void onNetworksDisconnected(List<Integer> newNetworks) {
    }
}

