/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.managers;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import sonar.logistics.PL2;
import sonar.logistics.api.networks.EmptyLogisticsNetwork;
import sonar.logistics.api.networks.ILogisticsNetwork;
import sonar.logistics.api.networks.INetworkListener;
import sonar.logistics.api.tiles.nodes.NodeConnection;
import sonar.logistics.api.utils.CacheType;
import sonar.logistics.connections.CacheHandler;
import sonar.logistics.connections.LogisticsNetwork;

public class NetworkManager {
    public Map<Integer, ILogisticsNetwork> cache = new ConcurrentHashMap<Integer, ILogisticsNetwork>();

    public void removeAll() {
        this.cache.clear();
    }

    public void tick() {
        if (this.cache.isEmpty()) {
            return;
        }
        Set<Map.Entry<Integer, ILogisticsNetwork>> entrySet = this.cache.entrySet();
        Iterator<Map.Entry<Integer, ILogisticsNetwork>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, ILogisticsNetwork> entry = iterator.next();
            ILogisticsNetwork network = entry.getValue();
            if (!network.isValid() || PL2.instance.cableManager.getConnections(network.getNetworkID()).size() == 0) {
                if (network.isValid()) {
                    network.onNetworkRemoved();
                }
                iterator.remove();
                continue;
            }
            network.onNetworkTick();
        }
    }

    public List<NodeConnection> getChannelArray(int networkID) {
        ILogisticsNetwork network = this.getNetwork(networkID);
        return network != null ? network.getConnections(CacheType.GLOBAL) : Lists.newArrayList();
    }

    public ILogisticsNetwork getNetwork(int networkID) {
        ILogisticsNetwork networkCache = this.cache.get(networkID);
        return networkCache != null ? networkCache : EmptyLogisticsNetwork.INSTANCE;
    }

    public ILogisticsNetwork getOrCreateNetwork(int networkID) {
        ILogisticsNetwork networkCache = this.cache.get(networkID);
        if (networkCache == null || !networkCache.isValid()) {
            LogisticsNetwork network = new LogisticsNetwork(networkID);
            this.cache.put(networkID, network);
            networkCache = this.cache.get(networkID);
        }
        return networkCache;
    }

    public void connectNetworks(int oldID, int newID) {
        if (oldID != newID) {
            ILogisticsNetwork oldNet = this.cache.get(oldID);
            if (oldNet == null) {
                return;
            }
            ILogisticsNetwork newNet = this.getOrCreateNetwork(newID);
            List<INetworkListener> tiles = oldNet.getCachedTiles(CacheHandler.TILE, CacheType.LOCAL);
            oldNet.onNetworkRemoved();
            this.cache.remove(oldNet);
            newNet.onCablesChanged();
        }
    }

    public Map<Integer, ILogisticsNetwork> getNetworkCache() {
        return this.cache;
    }
}

