/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.managers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.FunctionHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ISonarListener;
import sonar.core.listener.ListenableList;
import sonar.core.listener.ListenerList;
import sonar.core.listener.PlayerListener;
import sonar.core.utils.Pair;
import sonar.logistics.api.IInfoManager;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.tiles.displays.ConnectedDisplay;
import sonar.logistics.api.tiles.displays.DisplayInteractionEvent;
import sonar.logistics.api.tiles.displays.IDisplay;
import sonar.logistics.api.tiles.displays.ILargeDisplay;
import sonar.logistics.api.tiles.readers.IInfoProvider;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.api.viewers.ILogicListenable;
import sonar.logistics.api.viewers.ListenerType;
import sonar.logistics.helpers.CableHelper;
import sonar.logistics.helpers.InfoHelper;
import sonar.logistics.helpers.PacketHelper;
import sonar.logistics.info.types.InfoError;

public class ServerInfoManager
implements IInfoManager {
    public List<InfoUUID> changedInfo = Lists.newArrayList();
    public List<IDisplay> displays = Lists.newArrayList();
    public boolean markDisplaysDirty = true;
    private Map<InfoUUID, IInfo> info = Maps.newLinkedHashMap();
    public Map<InfoUUID, MonitoredList<?>> monitoredLists = Maps.newLinkedHashMap();
    public Map<Integer, ILogicListenable> identityTiles = Maps.newLinkedHashMap();
    public Map<Integer, ConnectedDisplay> connectedDisplays = new ConcurrentHashMap<Integer, ConnectedDisplay>();
    public Map<Integer, DisplayInteractionEvent> clickEvents = Maps.newHashMap();
    public Map<Integer, List<ChunkPos>> chunksToUpdate = Maps.newHashMap();
    public boolean newChunks = false;
    public int ticks;
    public boolean updateViewingMonitors;

    @Override
    public void removeAll() {
        this.changedInfo.clear();
        this.displays.clear();
        this.monitoredLists.clear();
        this.identityTiles.clear();
        this.info.clear();
        this.connectedDisplays.clear();
        this.clickEvents.clear();
        this.chunksToUpdate.clear();
    }

    public boolean enableEvents() {
        return !this.displays.isEmpty();
    }

    @Override
    public IInfo getInfoFromUUID(InfoUUID uuid) {
        return this.info.get(uuid);
    }

    @Override
    public ConnectedDisplay getOrCreateDisplayScreen(World world, ILargeDisplay display, int registryID) {
        Map<Integer, ConnectedDisplay> displays = this.getConnectedDisplays();
        ConnectedDisplay toSet = displays.get(registryID);
        if (toSet == null) {
            displays.put(registryID, new ConnectedDisplay(display));
            toSet = displays.get(registryID);
        }
        return toSet;
    }

    @Override
    public void addIdentityTile(ILogicListenable infoProvider) {
        if (this.identityTiles.containsValue(infoProvider)) {
            return;
        }
        this.identityTiles.put(infoProvider.getIdentity(), infoProvider);
        this.updateViewingMonitors = true;
    }

    @Override
    public void removeIdentityTile(ILogicListenable monitor) {
        for (int i = 0; i < (monitor instanceof IInfoProvider ? ((IInfoProvider)monitor).getMaxInfo() : 1); ++i) {
            this.info.put(new InfoUUID(monitor.getIdentity(), i), InfoError.noData);
        }
        this.identityTiles.remove(monitor.getIdentity());
        this.updateViewingMonitors = true;
    }

    public ILogicListenable getIdentityTile(int iden) {
        return this.identityTiles.get(iden);
    }

    @Override
    public void addDisplay(IDisplay display) {
        if (!this.displays.contains(display) && this.displays.add(display)) {
            this.addListenersFromDisplay(display);
            this.updateViewingMonitors = true;
        }
    }

    @Override
    public void removeDisplay(IDisplay display) {
        if (this.displays.remove(display)) {
            this.removeListenersFromDisplay(display);
            this.updateViewingMonitors = true;
        }
    }

    public void addListener(ChunkPos chunkPos, EntityPlayerMP player) {
        List<IDisplay> displays = this.getDisplaysInChunk(player.field_71093_bK, chunkPos);
        displays.forEach(d -> d.getListenerList().addListener((EntityPlayer)player, new Enum[]{ListenerType.TEMPORARY, ListenerType.FULL_INFO}));
    }

    public void removeListener(ChunkPos chunkPos, EntityPlayerMP player) {
        List<IDisplay> displays = this.getDisplaysInChunk(player.field_71093_bK, chunkPos);
        displays.forEach(d -> d.getListenerList().removeListener((EntityPlayer)player, true, new Enum[]{ListenerType.INFO}));
    }

    public void addListenersFromDisplay(IDisplay display) {
        BlockCoords coords = display.getCoords();
        WorldServer world = (WorldServer)coords.getWorld();
        this.addChangedChunk(coords.getDimension(), SonarHelper.getChunkFromPos((int)coords.getX(), (int)coords.getZ()));
    }

    public void removeListenersFromDisplay(IDisplay display) {
        List listeners = display.getListenerList().getListeners(new Enum[]{ListenerType.INFO});
        listeners.forEach(pl -> display.getListenerList().removeListener((ISonarListener)pl, true, new Enum[]{ListenerType.INFO}));
    }

    public void addChangedChunk(int dimension, ChunkPos chunkPos) {
        List<ChunkPos> chunks = this.chunksToUpdate.computeIfAbsent(dimension, FunctionHelper.ARRAY);
        if (!chunks.contains(chunkPos)) {
            chunks.add(chunkPos);
            this.newChunks = true;
        }
    }

    public List<IDisplay> getDisplaysInChunk(int dim, ChunkPos pos) {
        ArrayList inChunk = Lists.newArrayList();
        for (IDisplay display : this.displays) {
            BlockCoords coords = display.getCoords();
            if (coords.getDimension() != dim || !coords.insideChunk(pos)) continue;
            inChunk.add(display);
        }
        return inChunk;
    }

    @Nullable
    public Pair<InfoUUID, MonitoredList<?>> getMonitorFromServer(InfoUUID uuid) {
        for (Map.Entry<InfoUUID, MonitoredList<?>> entry : this.monitoredLists.entrySet()) {
            if (!entry.getKey().equals(uuid)) continue;
            return new Pair((Object)entry.getKey(), entry.getValue());
        }
        return null;
    }

    @Override
    public <T extends IInfo> MonitoredList<T> getMonitoredList(int networkID, InfoUUID uuid) {
        MonitoredList list = MonitoredList.newMonitoredList(networkID);
        this.monitoredLists.putIfAbsent(uuid, list);
        for (Map.Entry<InfoUUID, MonitoredList<?>> entry : this.monitoredLists.entrySet()) {
            if (entry.getValue().networkID != networkID || !entry.getKey().equals(uuid)) continue;
            return entry.getValue();
        }
        return list;
    }

    public void updateChunks() {
        for (Map.Entry<Integer, List<ChunkPos>> dims : this.chunksToUpdate.entrySet()) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            WorldServer world = server.func_71218_a(dims.getKey().intValue());
            PlayerChunkMap chunkMap = world.func_184164_w();
            for (ChunkPos chunkPos : dims.getValue()) {
                PlayerChunkMapEntry entry = chunkMap.func_187301_b(chunkPos.field_77276_a, chunkPos.field_77275_b);
                List players = SonarHelper.getPlayersWatchingChunk((PlayerChunkMapEntry)entry);
                if (players.isEmpty()) continue;
                for (IDisplay d : this.getDisplaysInChunk(dims.getKey(), chunkPos)) {
                    ListenableList list = d.getListenerList();
                    players.forEach(arg_0 -> ServerInfoManager.lambda$updateChunks$3((ListenerList)list, arg_0));
                }
            }
        }
        this.chunksToUpdate.clear();
        this.newChunks = false;
    }

    public void onServerTick() {
        if (this.newChunks) {
            this.updateChunks();
        }
        if (this.updateViewingMonitors) {
            this.updateViewingMonitors = false;
            this.identityTiles.values().forEach(tile -> tile.getListenerList().clearSubLists(true));
            this.displays.forEach(display -> display.container().forEachValidUUID(uuid -> {
                ILogicListenable monitor = CableHelper.getMonitorFromIdentity(uuid.getIdentity(), false);
                if (monitor != null && monitor instanceof ILogicListenable) {
                    monitor.getListenerList().addSubListenable((ISonarListenable)display);
                }
            }));
        }
        if (!this.changedInfo.isEmpty() && !this.displays.isEmpty()) {
            HashMap<PlayerListener, NBTTagList> savePackets = new HashMap<PlayerListener, NBTTagList>();
            HashMap<PlayerListener, NBTTagList> syncPackets = new HashMap<PlayerListener, NBTTagList>();
            for (InfoUUID id : this.changedInfo) {
                boolean isSynced = false;
                IInfo monitorInfo = this.getInfoFromUUID(id);
                if (!id.valid() || monitorInfo == null) continue;
                NBTTagCompound updateTag = InfoHelper.writeInfoToNBT(new NBTTagCompound(), monitorInfo, NBTHelper.SyncType.SAVE);
                NBTTagCompound saveTag = InfoHelper.writeInfoToNBT(new NBTTagCompound(), monitorInfo, NBTHelper.SyncType.SAVE);
                boolean shouldUpdate = !updateTag.func_82582_d();
                for (IDisplay display2 : this.displays) {
                    List fullViewers;
                    if (!display2.container().isDisplayingUUID(id)) continue;
                    ListenableList list = display2.getListenerList();
                    if (shouldUpdate) {
                        List listeners = list.getListeners(new Enum[]{ListenerType.INFO});
                        updateTag = id.writeData(updateTag, NBTHelper.SyncType.SAVE);
                        PacketHelper.addInfoUpdatesToList(syncPackets, listeners, updateTag, saveTag, false);
                    }
                    if ((fullViewers = list.getListeners(new Enum[]{ListenerType.FULL_INFO})).isEmpty()) continue;
                    saveTag = id.writeData(saveTag, NBTHelper.SyncType.SAVE);
                    PacketHelper.addInfoUpdatesToList(savePackets, fullViewers, updateTag, saveTag, true);
                    fullViewers.forEach(viewer -> {
                        display2.getListenerList().removeListener((ISonarListener)viewer, true, new Enum[]{ListenerType.FULL_INFO});
                        display2.getListenerList().addListener((ISonarListener)viewer, new Enum[]{ListenerType.INFO});
                    });
                }
            }
            if (!savePackets.isEmpty() || !syncPackets.isEmpty()) {
                savePackets.entrySet().forEach(entry -> PacketHelper.sendInfoUpdatePacket((PlayerListener)entry.getKey(), (NBTTagList)entry.getValue(), NBTHelper.SyncType.SAVE));
                syncPackets.entrySet().forEach(entry -> PacketHelper.sendInfoUpdatePacket((PlayerListener)entry.getKey(), (NBTTagList)entry.getValue(), NBTHelper.SyncType.SAVE));
                this.changedInfo.clear();
            }
        }
    }

    public void changeInfo(InfoUUID id, IInfo info) {
        IInfo last = this.getInfoFromUUID(id);
        if (info == null && last != null) {
            info = InfoError.noData;
            return;
        }
        if (!(info == null || last != null && last.isMatchingType(info) && last.isMatchingInfo(info) && last.isIdenticalInfo(info))) {
            this.setInfo(id, info);
            info.onInfoStored();
            if (!this.changedInfo.contains(id)) {
                this.changedInfo.add(id);
            }
        }
    }

    @Override
    public Map<Integer, ILogicListenable> getMonitors() {
        return this.identityTiles;
    }

    @Override
    public Map<InfoUUID, IInfo> getInfoList() {
        return this.info;
    }

    @Override
    public Map<Integer, ConnectedDisplay> getConnectedDisplays() {
        return this.connectedDisplays;
    }

    @Override
    public void setInfo(InfoUUID uuid, IInfo newInfo) {
        this.info.put(uuid, newInfo);
    }

    private static /* synthetic */ void lambda$updateChunks$3(ListenerList list, EntityPlayerMP p) {
        list.addListener((EntityPlayer)p, new Enum[]{ListenerType.TEMPORARY, ListenerType.FULL_INFO});
    }
}

