/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.managers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import sonar.logistics.PL2;
import sonar.logistics.api.networks.ILogisticsNetwork;
import sonar.logistics.api.wireless.ClientDataEmitter;
import sonar.logistics.api.wireless.IDataEmitter;
import sonar.logistics.api.wireless.IDataReceiver;
import sonar.logistics.connections.CacheHandler;
import sonar.logistics.helpers.PacketHelper;

public class WirelessManager {
    public static List<IDataEmitter> emitters = new ArrayList<IDataEmitter>();
    public static List<IDataReceiver> receivers = new ArrayList<IDataReceiver>();
    public static List<EntityPlayer> viewers = new ArrayList<EntityPlayer>();
    private static boolean dirty;

    public static void removeAll() {
        emitters.clear();
        receivers.clear();
        viewers.clear();
    }

    public static void emitterChanged(IDataEmitter emitter) {
        dirty = true;
        for (ILogisticsNetwork network : PL2.getNetworkManager().cache.values()) {
            network.onCacheChanged(CacheHandler.EMITTERS);
            network.onCacheChanged(CacheHandler.RECEIVERS);
        }
    }

    public static void receiverChanged(IDataReceiver emitter) {
        dirty = true;
        for (ILogisticsNetwork network : PL2.getNetworkManager().cache.values()) {
            network.onCacheChanged(CacheHandler.EMITTERS);
            network.onCacheChanged(CacheHandler.RECEIVERS);
        }
    }

    public static List<IDataEmitter> getEmitters(UUID uuid) {
        ArrayList emitters = Lists.newArrayList();
        for (IDataEmitter emitter : emitters) {
            if (!emitter.canPlayerConnect(uuid)) continue;
            emitters.add(emitter);
        }
        return emitters;
    }

    public static void addEmitter(IDataEmitter emitter) {
        if (!emitters.contains(emitter)) {
            emitters.add(emitter);
            WirelessManager.emitterChanged(emitter);
        }
    }

    public static void removeEmitter(IDataEmitter emitter) {
        if (emitters.remove(emitter)) {
            WirelessManager.emitterChanged(emitter);
        }
    }

    public static void addReceiver(IDataReceiver receiver) {
        if (!receivers.contains(receiver)) {
            receivers.add(receiver);
            WirelessManager.receiverChanged(receiver);
        }
    }

    public static void removeReceiver(IDataReceiver receiver) {
        if (receivers.remove(receiver)) {
            WirelessManager.receiverChanged(receiver);
        }
    }

    public static IDataEmitter getEmitter(int identity) {
        for (IDataEmitter e : emitters) {
            if (e.getIdentity() != identity) continue;
            return e;
        }
        return null;
    }

    public static IDataReceiver getReceiver(int identity) {
        for (IDataReceiver r : receivers) {
            if (r.getIdentity() != identity) continue;
            return r;
        }
        return null;
    }

    public static void addViewer(EntityPlayer player) {
        if (!viewers.contains(player)) {
            viewers.add(player);
            PacketHelper.sendDataEmittersToPlayer(player);
        }
    }

    public static void removeViewer(EntityPlayer player) {
        if (viewers.contains(player)) {
            viewers.remove(player);
        }
    }

    public static void tick() {
        if (dirty) {
            viewers.forEach(player -> PacketHelper.sendDataEmittersToPlayer(player));
            dirty = false;
        }
    }

    public static ArrayList<ClientDataEmitter> getClientEmitters(EntityPlayer player) {
        List<IDataEmitter> emitters = WirelessManager.getEmitters(player.func_146103_bH().getId());
        ArrayList clientEmitters = Lists.newArrayList();
        for (IDataEmitter emitter : WirelessManager.emitters) {
            clientEmitters.add(new ClientDataEmitter(emitter));
        }
        return clientEmitters;
    }
}

