/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.SonarCore;
import sonar.logistics.api.viewers.ILogicListenable;
import sonar.logistics.api.viewers.ListenerType;
import sonar.logistics.helpers.CableHelper;

public class PacketAddListener
implements IMessage {
    public ILogicListenable monitor;
    public ListenerType type;

    public PacketAddListener() {
    }

    public PacketAddListener(ILogicListenable monitor, ListenerType type) {
        this.monitor = monitor;
        this.type = type;
    }

    public void fromBytes(ByteBuf buf) {
        this.monitor = CableHelper.getMonitorFromIdentity(buf.readInt(), false);
        this.type = ListenerType.values()[buf.readInt()];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.monitor.getIdentity());
        buf.writeInt(this.type.ordinal());
    }

    public static class Handler
    implements IMessageHandler<PacketAddListener, IMessage> {
        public IMessage onMessage(final PacketAddListener message, final MessageContext ctx) {
            SonarCore.proxy.getThreadListener(ctx).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayer player = SonarCore.proxy.getPlayerEntity(ctx);
                    if (message.monitor != null && player != null) {
                        message.monitor.getListenerList().addListener(player, new Enum[]{message.type});
                    }
                }
            });
            return null;
        }
    }
}

