/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.PL2;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.helpers.InfoHelper;

public class PacketChannels
implements IMessage {
    public MonitoredList<IInfo> list;
    public NBTTagCompound listTag;
    public int registryID;

    public PacketChannels() {
    }

    public PacketChannels(int registryID, NBTTagCompound listTag) {
        this.listTag = listTag;
        this.registryID = registryID;
    }

    public void fromBytes(ByteBuf buf) {
        this.registryID = buf.readInt();
        this.listTag = ByteBufUtils.readTag((ByteBuf)buf);
        if (this.listTag != null) {
            this.list = InfoHelper.readMonitoredList(this.listTag, PL2.getClientManager().channelMap.getOrDefault(this.registryID, MonitoredList.newMonitoredList(this.registryID)).copyInfo(), NBTHelper.SyncType.DEFAULT_SYNC);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.registryID);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.listTag);
    }

    public static class Handler
    implements IMessageHandler<PacketChannels, IMessage> {
        public IMessage onMessage(final PacketChannels message, MessageContext ctx) {
            SonarCore.proxy.getThreadListener(ctx).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    if (message.list != null) {
                        PL2.getClientManager().channelMap.put(message.registryID, message.list);
                    }
                }
            });
            return null;
        }
    }
}

