/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import sonar.core.SonarCore;
import sonar.core.network.PacketMultipart;
import sonar.core.network.PacketMultipartHandler;
import sonar.logistics.PL2;
import sonar.logistics.api.info.IAdvancedClickableInfo;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.render.DisplayInfo;
import sonar.logistics.api.info.render.InfoContainer;
import sonar.logistics.api.tiles.displays.DisplayInteractionEvent;
import sonar.logistics.common.multiparts.AbstractDisplayPart;
import sonar.logistics.network.PacketClickEventServer;

public class PacketClickEventClient
extends PacketMultipart {
    public DisplayInteractionEvent eventTag;
    public ByteBuf buf;

    public PacketClickEventClient() {
    }

    public PacketClickEventClient(UUID partUUID, BlockPos pos, DisplayInteractionEvent eventTag) {
        super(partUUID, pos);
        this.eventTag = eventTag;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.buf = buf;
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        this.eventTag.writeToBuf(buf);
    }

    public static class Handler
    extends PacketMultipartHandler<PacketClickEventClient> {
        public IMessage processMessage(final PacketClickEventClient message, IMultipartContainer target, final IMultipart part, final MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                SonarCore.proxy.getThreadListener(ctx).func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        EntityPlayer player = SonarCore.proxy.getPlayerEntity(ctx);
                        if (player != null && part instanceof AbstractDisplayPart) {
                            NBTTagCompound eventTag;
                            DisplayInfo displayInfo;
                            IInfo info;
                            DisplayInteractionEvent event = DisplayInteractionEvent.readFromBuf(message.buf, player, (AbstractDisplayPart)part);
                            if (event.hit == null) {
                                return;
                            }
                            InfoContainer container = (InfoContainer)((AbstractDisplayPart)part).container();
                            if (container != null && (info = (displayInfo = container.getDisplayInfo(event.infoPos)).getSidedCachedInfo(true)) != null && info instanceof IAdvancedClickableInfo && info.equals(event.currentInfo) && !(eventTag = ((IAdvancedClickableInfo)((Object)info)).onClientClick(event, displayInfo, player, player.func_184607_cu(), container)).func_82582_d()) {
                                PL2.network.sendToServer((IMessage)new PacketClickEventServer(event.hashCode, eventTag));
                            }
                        }
                    }
                });
            }
            return null;
        }
    }
}

