/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import sonar.core.SonarCore;
import sonar.logistics.PL2;
import sonar.logistics.api.info.IAdvancedClickableInfo;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.render.DisplayInfo;
import sonar.logistics.api.info.render.InfoContainer;
import sonar.logistics.api.tiles.displays.DisplayInteractionEvent;
import sonar.logistics.api.tiles.displays.IDisplay;

public class PacketClickEventServer
implements IMessage {
    public NBTTagCompound eventTag;
    public int hashCode;

    public PacketClickEventServer() {
    }

    public PacketClickEventServer(int hashCode, NBTTagCompound eventTag) {
        this.hashCode = hashCode;
        this.eventTag = eventTag;
    }

    public void fromBytes(ByteBuf buf) {
        this.hashCode = buf.readInt();
        this.eventTag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.hashCode);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.eventTag);
    }

    public static class Handler
    implements IMessageHandler<PacketClickEventServer, IMessage> {
        public IMessage onMessage(final PacketClickEventServer message, final MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                SonarCore.proxy.getThreadListener(ctx).func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        DisplayInteractionEvent event;
                        EntityPlayer player = SonarCore.proxy.getPlayerEntity(ctx);
                        if (player != null && (event = PL2.getServerManager().clickEvents.get(message.hashCode)) != null && event.hit.partHit instanceof IDisplay) {
                            InfoContainer container = (InfoContainer)((IDisplay)event.hit.partHit).container();
                            DisplayInfo displayInfo = container.getDisplayInfo(event.infoPos);
                            IInfo info = displayInfo.getSidedCachedInfo(false);
                            if (info != null && info instanceof IAdvancedClickableInfo && info.equals(event.currentInfo)) {
                                ((IAdvancedClickableInfo)((Object)info)).onClickEvent(container, displayInfo, event, message.eventTag);
                            }
                            PL2.getServerManager().clickEvents.remove(message.hashCode);
                        }
                    }
                });
            }
            return null;
        }
    }
}

