/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.PL2;
import sonar.logistics.api.wireless.ClientDataEmitter;

public class PacketClientEmitters
implements IMessage {
    public List<ClientDataEmitter> emitters;

    public PacketClientEmitters() {
    }

    public PacketClientEmitters(List<ClientDataEmitter> emitters) {
        this.emitters = emitters;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.emitters = Lists.newArrayList();
        if (tag.func_74764_b("emitters")) {
            NBTTagList tagList = tag.func_150295_c("emitters", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.emitters.add((ClientDataEmitter)NBTHelper.instanceNBTSyncable(ClientDataEmitter.class, (NBTTagCompound)tagList.func_150305_b(i)));
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList tagList = new NBTTagList();
        this.emitters.forEach(emitter -> tagList.func_74742_a((NBTBase)emitter.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE)));
        if (!tagList.func_82582_d()) {
            tag.func_74782_a("emitters", (NBTBase)tagList);
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class Handler
    implements IMessageHandler<PacketClientEmitters, IMessage> {
        public IMessage onMessage(final PacketClientEmitters message, MessageContext ctx) {
            SonarCore.proxy.getThreadListener(ctx).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    PL2.getClientManager().clientEmitters = message.emitters;
                }
            });
            return null;
        }
    }
}

