/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import sonar.core.SonarCore;
import sonar.logistics.PL2;
import sonar.logistics.api.tiles.displays.ConnectedDisplay;
import sonar.logistics.api.tiles.displays.ILargeDisplay;

public class PacketConnectedDisplayScreen
implements IMessage {
    public ByteBuf savedBuf;
    public ConnectedDisplay screen;
    public int registryID;

    public PacketConnectedDisplayScreen() {
    }

    public PacketConnectedDisplayScreen(ConnectedDisplay screen, int registryID) {
        this.screen = screen;
        this.registryID = registryID;
    }

    public void fromBytes(ByteBuf buf) {
        this.registryID = buf.readInt();
        this.screen = PL2.getClientManager().connectedDisplays.get(this.registryID);
        this.savedBuf = buf;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.registryID);
        this.screen.writeToBuf(buf);
    }

    public static class Handler
    implements IMessageHandler<PacketConnectedDisplayScreen, IMessage> {
        public IMessage onMessage(final PacketConnectedDisplayScreen message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                SonarCore.proxy.getThreadListener(ctx).func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        if (message.screen == null) {
                            message.screen = new ConnectedDisplay(message.registryID);
                        }
                        message.screen.readFromBuf(message.savedBuf);
                        PL2.getClientManager().connectedDisplays.put(message.registryID, message.screen);
                        ILargeDisplay topLeft = message.screen.getTopLeftScreen();
                        if (topLeft != null) {
                            topLeft.setConnectedDisplay(message.screen);
                        }
                    }
                });
            }
            return null;
        }
    }
}

