/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.UUID;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.SonarCore;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.PacketMultipart;
import sonar.core.network.PacketMultipartHandler;
import sonar.core.network.sync.SyncNBTAbstractList;
import sonar.logistics.api.tiles.signaller.EmitterStatement;
import sonar.logistics.api.tiles.signaller.ILogisticsTile;
import sonar.logistics.api.utils.ListPacket;

public class PacketEmitterStatement
extends PacketMultipart {
    public EmitterStatement statement;
    public ListPacket packetType;

    public PacketEmitterStatement() {
    }

    public PacketEmitterStatement(UUID partUUID, BlockPos pos, ListPacket packetType) {
        super(partUUID, pos);
        this.packetType = packetType;
    }

    public PacketEmitterStatement(UUID partUUID, BlockPos pos, ListPacket packetType, EmitterStatement filter) {
        super(partUUID, pos);
        this.statement = filter;
        this.packetType = packetType;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        if (buf.readBoolean()) {
            this.statement = (EmitterStatement)NBTHelper.instanceNBTSyncable(EmitterStatement.class, (NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buf));
        }
        this.packetType = ListPacket.values()[buf.readInt()];
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.statement != null);
        if (this.statement != null) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.statement.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
        }
        buf.writeInt(this.packetType.ordinal());
    }

    public static class Handler
    extends PacketMultipartHandler<PacketEmitterStatement> {
        public IMessage processMessage(final PacketEmitterStatement message, IMultipartContainer target, final IMultipart part, final MessageContext ctx) {
            SonarCore.proxy.getThreadListener(ctx).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayer player = SonarCore.proxy.getPlayerEntity(ctx);
                    if (player == null || player.func_130014_f_().field_72995_K || !(part instanceof ILogisticsTile)) {
                        return;
                    }
                    ILogisticsTile tile = (ILogisticsTile)part;
                    SyncNBTAbstractList<EmitterStatement> filters = tile.getStatements();
                    switch (message.packetType) {
                        case ADD: {
                            for (EmitterStatement filter : filters.getObjects()) {
                                if (!filter.equals(message.statement)) continue;
                                filter.readData(message.statement.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE), NBTHelper.SyncType.SAVE);
                                filters.markChanged();
                                return;
                            }
                            filters.addObject((INBTSyncable)message.statement);
                            break;
                        }
                        case MOVE_DOWN: {
                            int listPos = -1;
                            for (int i = 0; i < filters.objs.size(); ++i) {
                                EmitterStatement filter = (EmitterStatement)filters.getObjects().get(i);
                                if (!filter.equals(message.statement)) continue;
                                listPos = i;
                            }
                            if (listPos + 1 <= 0 || listPos + 1 >= filters.objs.size()) break;
                            Collections.swap(filters.objs, listPos, listPos + 1);
                            filters.markChanged();
                            break;
                        }
                        case MOVE_UP: {
                            int listPos = -1;
                            for (int i = 0; i < filters.objs.size(); ++i) {
                                EmitterStatement filter = (EmitterStatement)filters.getObjects().get(i);
                                if (!filter.equals(message.statement)) continue;
                                listPos = i;
                            }
                            if (listPos - 1 < 0 || listPos - 1 >= filters.objs.size()) break;
                            Collections.swap(filters.objs, listPos, listPos - 1);
                            filters.markChanged();
                            break;
                        }
                        case REMOVE: {
                            filters.removeObject((INBTSyncable)message.statement);
                            break;
                        }
                        case CLEAR: {
                            filters.objs.clear();
                            filters.markChanged();
                            break;
                        }
                    }
                }
            });
            return null;
        }
    }
}

