/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.SonarCore;
import sonar.core.network.PacketMultipart;
import sonar.core.network.PacketMultipartHandler;
import sonar.logistics.api.networks.ILogisticsNetwork;
import sonar.logistics.common.multiparts.readers.InventoryReaderPart;
import sonar.logistics.helpers.ItemHelper;

public class PacketInventoryReader
extends PacketMultipart {
    public ItemStack selected;
    public int button;

    public PacketInventoryReader() {
    }

    public PacketInventoryReader(UUID partUUID, BlockPos pos, ItemStack selected, int button) {
        super(partUUID, pos);
        this.selected = selected;
        this.button = button;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        if (buf.readBoolean()) {
            this.selected = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
        this.button = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        if (this.selected != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.selected);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeInt(this.button);
    }

    public static class Handler
    extends PacketMultipartHandler<PacketInventoryReader> {
        public IMessage processMessage(final PacketInventoryReader message, IMultipartContainer target, final IMultipart part, final MessageContext ctx) {
            SonarCore.proxy.getThreadListener(ctx).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayer player = SonarCore.proxy.getPlayerEntity(ctx);
                    if (player == null || player.func_130014_f_().field_72995_K || !(part instanceof InventoryReaderPart)) {
                        return;
                    }
                    InventoryReaderPart reader = (InventoryReaderPart)part;
                    ILogisticsNetwork network = reader.getNetwork();
                    if (network.isValid()) {
                        ItemHelper.onNetworkItemInteraction(reader, network, reader.getMonitoredList(), player, message.selected, message.button);
                    }
                }
            });
            return null;
        }
    }
}

