/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.PL2;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.tiles.readers.ClientLocalProvider;
import sonar.logistics.api.tiles.readers.IInfoProvider;
import sonar.logistics.api.viewers.ILogicListenable;

public class PacketLocalProviders
implements IMessage {
    public List<ClientLocalProvider> viewables;
    public int screenIdentity;

    public PacketLocalProviders() {
    }

    public PacketLocalProviders(List<ClientLocalProvider> viewables, int screenIdentity) {
        this.viewables = viewables;
        this.screenIdentity = screenIdentity;
    }

    public void fromBytes(ByteBuf buf) {
        this.screenIdentity = buf.readInt();
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.viewables = Lists.newArrayList();
        if (tag.func_74764_b("monitors")) {
            NBTTagList tagList = tag.func_150295_c("monitors", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.viewables.add((ClientLocalProvider)NBTHelper.instanceNBTSyncable(ClientLocalProvider.class, (NBTTagCompound)tagList.func_150305_b(i)));
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.screenIdentity);
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList tagList = new NBTTagList();
        this.viewables.forEach(emitter -> tagList.func_74742_a((NBTBase)emitter.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE)));
        if (!tagList.func_82582_d()) {
            tag.func_74782_a("monitors", (NBTBase)tagList);
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class Handler
    implements IMessageHandler<PacketLocalProviders, IMessage> {
        public IMessage onMessage(final PacketLocalProviders message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                SonarCore.proxy.getThreadListener(ctx).func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        Map<Integer, List<ClientLocalProvider>> monitors = PL2.getClientManager().clientLogicMonitors;
                        if (monitors.get(message.screenIdentity) == null) {
                            monitors.put(message.screenIdentity, message.viewables);
                        } else {
                            monitors.get(message.screenIdentity).clear();
                            monitors.get(message.screenIdentity).addAll(message.viewables);
                        }
                        ArrayList cache = Lists.newArrayList();
                        for (ClientLocalProvider clientMonitor : message.viewables) {
                            ILogicListenable monitor = clientMonitor.getViewable();
                            if (monitor == null || !(monitor instanceof IInfoProvider)) continue;
                            int hashCode = monitor.getIdentity();
                            cache.add(monitor);
                            for (int i = 0; i < ((IInfoProvider)monitor).getMaxInfo(); ++i) {
                                cache.add(new InfoUUID(hashCode, i));
                            }
                        }
                        Map<Integer, List<Object>> sortedMonitors = PL2.getClientManager().sortedLogicMonitors;
                        if (sortedMonitors.get(message.screenIdentity) == null) {
                            sortedMonitors.put(message.screenIdentity, cache);
                        } else {
                            sortedMonitors.get(message.screenIdentity).clear();
                            sortedMonitors.get(message.screenIdentity).addAll(cache);
                        }
                    }
                });
            }
            return null;
        }
    }
}

