/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.PL2;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.tiles.readers.IListReader;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.api.viewers.ILogicListenable;
import sonar.logistics.helpers.InfoHelper;

public class PacketMonitoredList
implements IMessage {
    public InfoUUID id;
    public int identity;
    public int networkID;
    public MonitoredList list;
    public NBTTagCompound listTag;
    public NBTHelper.SyncType type;

    public PacketMonitoredList() {
    }

    public PacketMonitoredList(int identity, InfoUUID id, int networkID, NBTTagCompound listTag, NBTHelper.SyncType type) {
        this.identity = identity;
        this.id = id;
        this.networkID = networkID;
        this.listTag = listTag;
        this.type = type;
    }

    public void fromBytes(ByteBuf buf) {
        this.identity = buf.readInt();
        this.networkID = buf.readInt();
        this.id = InfoUUID.getUUID(buf);
        this.type = NBTHelper.SyncType.values()[buf.readInt()];
        this.list = InfoHelper.readMonitoredList(ByteBufUtils.readTag((ByteBuf)buf), PL2.getClientManager().getMonitoredList(this.networkID, this.id).copyInfo(), this.type);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.identity);
        buf.writeInt(this.networkID);
        this.id.writeToBuf(buf);
        buf.writeInt(this.type.ordinal());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.listTag);
    }

    public static class Handler
    implements IMessageHandler<PacketMonitoredList, IMessage> {
        public IMessage onMessage(final PacketMonitoredList message, MessageContext ctx) {
            SonarCore.proxy.getThreadListener(ctx).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    if (message.list != null) {
                        ILogicListenable viewable = PL2.getClientManager().monitors.get(message.identity);
                        MonitoredList list = viewable instanceof IListReader ? ((IListReader)viewable).sortMonitoredList(message.list, message.id.channelID) : message.list;
                        PL2.getClientManager().monitoredLists.put(message.id, list);
                        PL2.getClientManager().onMonitoredListChanged(message.id, list);
                    }
                }
            });
            return null;
        }
    }
}

