/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.sync;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.SyncPart;
import sonar.logistics.api.states.TileMessage;
import sonar.logistics.api.tiles.INetworkTile;

public class SyncTileMessages
extends SyncPart {
    public final INetworkTile tile;
    public byte[] states = new byte[TileMessage.values().length];
    public int types;

    public SyncTileMessages(INetworkTile tile, int id) {
        super(id);
        this.tile = tile;
        this.types = TileMessage.values().length;
        this.states = new byte[this.types];
    }

    public boolean isValid(TileMessage message) {
        for (TileMessage m : this.tile.getValidMessages()) {
            if (m != message) continue;
            return true;
        }
        return false;
    }

    public boolean getMessageState(TileMessage message) {
        return this.states[message.ordinal()] != 0;
    }

    public byte getMessageBit(TileMessage message) {
        return this.states[message.ordinal()];
    }

    public void markAllMessages(boolean bool) {
        this.markAllMessages((byte)(bool ? 1 : 0));
    }

    public void markAllMessages(byte bit) {
        for (TileMessage message : TileMessage.values()) {
            if (!this.isValid(message)) continue;
            this.states[message.ordinal()] = bit;
        }
    }

    public void markTileMessage(TileMessage message, boolean bool) {
        this.markTileMessage(message, (byte)(bool ? 1 : 0));
    }

    public void markTileMessage(TileMessage message, byte bit) {
        if (this.isValid(message)) {
            this.states[message.ordinal()] = bit;
        }
    }

    @Nullable
    public TileMessage canOpenGui() {
        for (int i = 0; i < this.types; ++i) {
            if (this.states[i] <= 0 || TileMessage.values()[i].canOpenTile()) continue;
            return TileMessage.values()[i];
        }
        return null;
    }

    public void writeToBuf(ByteBuf buf) {
        for (int i = 0; i < this.types; ++i) {
            buf.writeByte((int)this.states[i]);
        }
    }

    public void readFromBuf(ByteBuf buf) {
        for (int i = 0; i < this.types; ++i) {
            this.states[i] = buf.readByte();
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        nbt.func_74773_a(this.getTagName(), this.states);
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (nbt.func_74764_b(this.getTagName())) {
            this.states = nbt.func_74770_j(this.getTagName());
        }
        return nbt;
    }
}

