/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.block;

import cofh.core.block.ItemBlockCore;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermaldynamics.block.BlockDuct;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.DuctItem;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.duct.energy.GridEnergy;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;

public class ItemBlockDuct
extends ItemBlockCore {
    int offset;

    public ItemBlockDuct(Block block) {
        super(block);
        this.offset = ((BlockDuct)block).offset;
    }

    public String func_77667_c(ItemStack item) {
        return TDDucts.isValid(this.id(item)) ? "tile.thermaldynamics.duct." + TDDucts.getType((int)this.id((ItemStack)item)).unlocalizedName : super.func_77667_c(item);
    }

    public String func_77653_i(ItemStack item) {
        if (TDDucts.isValid(this.id(item))) {
            Duct type = TDDucts.getType(this.id(item));
            String opaqueLocalized = null;
            String modeLocalized = null;
            String unloc = this.func_77657_g(item);
            if (type.opaque) {
                if (StringHelper.canLocalize((String)(unloc + ".opaque.name"))) {
                    unloc = unloc + ".opaque";
                } else {
                    opaqueLocalized = "tile.thermaldynamics.duct.opaque.name";
                }
            }
            if (type instanceof DuctItem && item.func_77978_p() != null) {
                if (item.func_77978_p().func_74771_c("DenseType") == 1) {
                    if (StringHelper.canLocalize((String)(unloc + ".dense.name"))) {
                        unloc = unloc + ".dense";
                    } else {
                        modeLocalized = "tile.thermaldynamics.duct.dense.name";
                    }
                } else if (item.func_77978_p().func_74771_c("DenseType") == 2) {
                    if (StringHelper.canLocalize((String)(unloc + ".vacuum.name"))) {
                        unloc = unloc + ".vacuum";
                    } else {
                        modeLocalized = "tile.thermaldynamics.duct.vacuum.name";
                    }
                }
            }
            String ret = StringHelper.localize((String)(unloc + ".name"));
            if (opaqueLocalized != null) {
                ret = StringHelper.localizeFormat((String)opaqueLocalized, (Object[])new Object[]{ret});
            }
            if (modeLocalized != null) {
                ret = StringHelper.localizeFormat((String)modeLocalized, (Object[])new Object[]{ret});
            }
            return ret;
        }
        return super.func_77653_i(item);
    }

    public int id(ItemStack item) {
        return this.offset + item.func_77952_i();
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        int ductId = this.id(stack);
        if (TDDucts.isValid(ductId)) {
            return TDDucts.getType((int)ductId).rarity;
        }
        return EnumRarity.UNCOMMON;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean extraInfo) {
        super.func_77624_a(stack, player, list, extraInfo);
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            if (ItemHelper.itemsIdentical((ItemStack)stack, (ItemStack)TDDucts.structure.itemStack)) {
                list.add(StringHelper.getInfoText((String)"info.thermaldynamics.duct.cover"));
            }
            return;
        }
        int ductId = this.id(stack);
        if (!TDDucts.isValid(ductId)) {
            return;
        }
        Duct duct = TDDucts.getType(ductId);
        switch (duct.ductType) {
            case ENERGY: {
                list.add(StringHelper.localize((String)"info.thermaldynamics.duct.energy"));
                if (duct != TDDucts.energySuperCond) {
                    list.add(StringHelper.localize((String)"info.thermaldynamics.transfer") + ": " + "\u00a7e" + GridEnergy.NODE_TRANSFER[duct.type] + "\u00a77" + " RF/t.");
                } else {
                    list.add(StringHelper.localize((String)"info.thermaldynamics.transfer") + ": " + "\u00a7b" + StringHelper.localize((String)"info.cofh.infinite") + "\u00a77" + " RF/t.");
                    list.add(StringHelper.getInfoText((String)"tile.thermaldynamics.duct.energySuper.info"));
                }
                list.add(StringHelper.getNoticeText((String)"info.thermaldynamics.transferConnection"));
                break;
            }
            case FLUID: {
                if (duct.type == 0) {
                    list.add(StringHelper.localize((String)"info.thermaldynamics.duct.fluid"));
                    list.add(StringHelper.getInfoText((String)"tile.thermaldynamics.duct.fluidBasic.info"));
                } else if (duct.type == 1) {
                    list.add(StringHelper.localize((String)"info.thermaldynamics.duct.fluid"));
                    list.add(StringHelper.getInfoText((String)"tile.thermaldynamics.duct.fluidHardened.info"));
                } else if (duct.type == 2) {
                    list.add(StringHelper.localize((String)"info.thermaldynamics.duct.fluidEnergy"));
                    list.add(StringHelper.localize((String)"info.thermaldynamics.transfer") + ": " + "\u00a7e" + 4000 + "\u00a77" + " RF/t.");
                    list.add(StringHelper.getInfoText((String)"tile.thermaldynamics.duct.fluidHardened.info"));
                } else if (duct.type == 3) {
                    list.add(StringHelper.localize((String)"info.thermaldynamics.duct.fluid"));
                    list.add(StringHelper.getInfoText((String)"tile.thermaldynamics.duct.fluidSuper.info"));
                }
                if (duct.type == 3) break;
                list.add(StringHelper.getNoticeText((String)"info.thermaldynamics.transferFluid"));
                break;
            }
            case ITEM: {
                if (duct.type == 0) {
                    list.add(StringHelper.localize((String)"info.thermaldynamics.duct.item"));
                } else if (duct.type == 1) {
                    list.add(StringHelper.localize((String)"info.thermaldynamics.duct.item"));
                    list.add(StringHelper.getInfoText((String)"tile.thermaldynamics.duct.itemFast.info"));
                } else if (duct.type == 2) {
                    list.add(StringHelper.localize((String)"info.thermaldynamics.duct.itemEnergy"));
                } else if (duct.type == 3) {
                    list.add(StringHelper.localize((String)"info.thermaldynamics.duct.itemEnergy"));
                    list.add(StringHelper.localize((String)"info.thermaldynamics.transfer") + ": " + "\u00a7e" + 4000 + "\u00a77" + " RF/t.");
                    list.add(StringHelper.getInfoText((String)"tile.thermaldynamics.duct.itemFast.info"));
                }
                if (!stack.func_77942_o()) break;
                byte pathWeight = stack.func_77978_p().func_74771_c("DenseType");
                if (pathWeight == 1) {
                    list.add(StringHelper.getInfoText((String)"info.thermaldynamics.duct.dense"));
                    break;
                }
                if (pathWeight != 2) break;
                list.add(StringHelper.getInfoText((String)"info.thermaldynamics.duct.vacuum"));
                break;
            }
            case STRUCTURAL: {
                if (duct == TDDucts.structure) {
                    list.add(StringHelper.localize((String)"info.thermaldynamics.duct.structure"));
                    list.add(StringHelper.getInfoText((String)"info.thermaldynamics.duct.cover"));
                    break;
                }
                if (duct != TDDucts.lightDuct) break;
                list.add(StringHelper.localize((String)"info.thermaldynamics.duct.structure"));
                list.add(StringHelper.localize((String)"info.thermaldynamics.duct.light"));
                break;
            }
            case TRANSPORT: {
                list.add(StringHelper.localize((String)"info.thermaldynamics.duct.transport"));
                if (duct == TDDucts.transportLongRange) {
                    list.add(StringHelper.getInfoText((String)"info.thermaldynamics.duct.transportLongRange"));
                    break;
                }
                if (duct != TDDucts.transportLinking) break;
                list.add(StringHelper.getInfoText((String)"info.thermaldynamics.duct.transportCrossover"));
                break;
            }
            case CRAFTING: {
                list.add(StringHelper.localize((String)"info.thermaldynamics.duct.crafting"));
                break;
            }
        }
    }
}

