/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.entity;

import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermaldynamics.block.BlockDuct;
import cofh.thermaldynamics.duct.ConnectionType;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.entity.DuctUnitTransportBase;
import cofh.thermaldynamics.duct.entity.DuctUnitTransportLongRange;
import cofh.thermaldynamics.duct.entity.EntityTransport;
import cofh.thermaldynamics.duct.entity.GridTransport;
import cofh.thermaldynamics.duct.item.RouteInfo;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.duct.tiles.IDuctHolder;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.multiblock.IGridTile;
import cofh.thermaldynamics.multiblock.Route;
import cofh.thermaldynamics.multiblock.RouteCache;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DuctUnitTransportLinking
extends DuctUnitTransportBase {
    static final SidedBlockPos clientValue = SidedBlockPos.ORIGIN;
    public static byte CHARGE_TIME = (byte)20;
    final SidedBlockPos[] rangePos = new SidedBlockPos[6];

    public DuctUnitTransportLinking(TileGrid parent, Duct duct) {
        super(parent, duct);
    }

    @Override
    public void handleTileSideUpdate(@Nullable TileEntity tile, @Nullable IDuctHolder holder, byte side, @Nonnull ConnectionType type, byte oppositeSide) {
        SidedBlockPos sidedBlockPos = this.rangePos[side];
        if (sidedBlockPos != null) {
            if (tile != null) {
                if (this.world().func_175667_e(sidedBlockPos.pos)) {
                    TileEntity distantTile = this.world().func_175625_s(sidedBlockPos.pos);
                    DuctUnitTransportBase transportBase = IDuctHolder.getTokenFromTile(distantTile, DuctToken.TRANSPORT);
                    if (transportBase != null && transportBase.isCrossover()) {
                        super.handleTileSideUpdate(distantTile, (IDuctHolder)distantTile, side, type, (byte)sidedBlockPos.side.ordinal());
                        return;
                    }
                    this.rangePos[side] = null;
                }
            } else {
                this.rangePos[side] = null;
            }
        }
        super.handleTileSideUpdate(tile, holder, side, type, oppositeSide);
    }

    @Override
    public boolean isOutput() {
        return false;
    }

    @Override
    public boolean isRoutable() {
        return true;
    }

    @Override
    public boolean isCrossover() {
        return true;
    }

    @Override
    public Route getRoute(Entity entityTransport, int direction, byte step) {
        return null;
    }

    @Override
    public boolean canConnectToOtherDuct(DuctUnit<DuctUnitTransportBase, GridTransport, DuctUnitTransportBase.TransportDestination> adjDuct, byte side, byte oppositeSide) {
        return true;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        if (ServerHelper.isClientWorld((World)this.world())) {
            return true;
        }
        for (byte i = 0; i < 6; i = (byte)((byte)(i + 1))) {
            this.rangePos[i] = null;
            TileEntity adjTileEntitySafe = BlockHelper.getAdjacentTileEntity((TileEntity)this.parent, (int)i);
            DuctUnitTransportBase duct = IDuctHolder.getTokenFromTile(adjTileEntitySafe, DuctToken.TRANSPORT);
            if (duct == null || !duct.isLongRange()) continue;
            player.func_146105_b((ITextComponent)new TextComponentString("Searching on side - " + EnumFacing.field_82609_l[i].toString()));
            DuctUnitTransportLongRange travel = (DuctUnitTransportLongRange)duct;
            IGridTile finalDest = null;
            int dist = 0;
            byte d = travel.nextDirection(i);
            BlockPos pos = travel.pos();
            while (d != -1) {
                pos = pos.func_177972_a(EnumFacing.field_82609_l[d]);
                for (int j = 2; j < 6; ++j) {
                    this.world().func_175726_f(pos.func_177972_a(EnumFacing.field_82609_l[j]));
                }
                DuctUnitTransportBase side = IDuctHolder.getTokenFromTile(this.world().func_175625_s(pos), DuctToken.TRANSPORT);
                if (side == null) break;
                if (side.isCrossover()) {
                    finalDest = (DuctUnitTransportLinking)side;
                    break;
                }
                if (!side.isLongRange()) break;
                travel = (DuctUnitTransportLongRange)side;
                travel.onNeighborBlockChange();
                d = travel.nextDirection(d);
                ++dist;
            }
            if (finalDest != null) {
                player.func_146105_b((ITextComponent)new TextComponentString("Linked to -  (" + finalDest.x() + ", " + finalDest.y() + ", " + finalDest.z() + ")"));
                ((DuctUnitTransportLinking)finalDest).rangePos[d ^ 1] = new SidedBlockPos(this.pos(), EnumFacing.field_82609_l[i].func_176734_d());
                this.rangePos[i] = new SidedBlockPos(((DuctUnit)finalDest).pos(), EnumFacing.field_82609_l[d]);
                if (this.grid != null) {
                    ((GridTransport)this.grid).destroyAndRecreate();
                }
                if (((DuctUnitTransportLinking)finalDest).grid != null && ((DuctUnitTransportLinking)finalDest).grid != this.grid) {
                    ((GridTransport)((DuctUnitTransportLinking)finalDest).grid).destroyAndRecreate();
                }
                ((DuctUnitTransportLinking)finalDest).parent.callBlockUpdate();
                continue;
            }
            player.func_146105_b((ITextComponent)new TextComponentString("Failed after " + dist + " blocks - (" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + ")"));
        }
        this.parent.callBlockUpdate();
        return true;
    }

    @Override
    public IGridTile getPhysicalConnectedSide(byte direction) {
        if (this.rangePos[direction] != null) {
            TileEntity adjacentTileEntity = BlockHelper.getAdjacentTileEntity((TileEntity)this.parent, (int)direction);
            DuctUnitTransportBase ductUnitTransportBase = IDuctHolder.getTokenFromTile(adjacentTileEntity, DuctToken.TRANSPORT);
            if (ductUnitTransportBase instanceof DuctUnitTransportLongRange) {
                return ductUnitTransportBase;
            }
            return null;
        }
        IGridTile physicalConnectedSide = super.getPhysicalConnectedSide(direction);
        if (physicalConnectedSide instanceof DuctUnitTransportLongRange) {
            return null;
        }
        return physicalConnectedSide;
    }

    @Override
    public void advanceToNextTile(EntityTransport t) {
        if (this.rangePos[t.direction] == null) {
            t.advanceTile(this);
        } else if (((DuctUnitTransportBase[])this.ductCache)[t.direction] != null) {
            DuctUnitTransportBase newHome = (DuctUnitTransportBase)this.getPhysicalConnectedSide(t.direction);
            if (!(newHome instanceof DuctUnitTransportLongRange)) {
                t.bouncePassenger(this);
                return;
            }
            if (((DuctUnitTransportBase[])((DuctUnitTransportLongRange)newHome).ductCache)[t.direction ^ 1] != null) {
                t.pos = new BlockPos((Vec3i)newHome.pos());
                t.oldDirection = t.direction;
                t.direction = ((DuctUnitTransportLongRange)newHome).nextDirection(t.direction);
                if (t.direction == -1) {
                    t.dropPassenger();
                }
            } else {
                t.reRoute = true;
            }
        } else if (((DuctUnitTransportBase.TransportDestination[])this.tileCache)[t.direction] != null) {
            t.dropPassenger();
        } else {
            t.bouncePassenger(this);
        }
    }

    @Override
    public void advanceEntity(EntityTransport t) {
        if (t.progress < 50 && t.progress + t.step >= 50 && ((DuctUnitTransportBase[])this.ductCache)[t.direction] != null && this.rangePos[t.direction] != null) {
            t.progress = (byte)50;
            t.pause = CHARGE_TIME;
        }
        super.advanceEntity(t);
    }

    @Override
    public boolean advanceEntityClient(EntityTransport t) {
        if (t.progress < 50 && t.progress + t.step >= 50 && ((DuctUnitTransportBase[])this.ductCache)[t.direction] != null && this.rangePos[t.direction] != null) {
            t.progress = (byte)50;
            t.pause = CHARGE_TIME;
            return true;
        }
        return super.advanceEntityClient(t);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            if (!nbt.func_150297_b("crossover" + i, 10)) continue;
            NBTTagCompound tag = nbt.func_74775_l("crossover" + i);
            this.rangePos[i] = new SidedBlockPos(tag);
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        for (int i = 0; i < 6; ++i) {
            if (this.rangePos[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            this.rangePos[i].writeToNBT(tag);
            nbt.func_74782_a("crossover" + i, (NBTBase)tag);
        }
        return nbt;
    }

    @Override
    public void writeToTilePacket(PacketCoFHBase packet) {
        int rangeMask = 0;
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            if (this.rangePos[i] == null) continue;
            rangeMask |= 1 << i;
        }
        packet.addInt(rangeMask);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        int rangeMask = payload.getInt();
        for (int i = 0; i < this.rangePos.length; ++i) {
            if ((rangeMask & 1 << i) == 0) continue;
            this.rangePos[i] = clientValue;
        }
    }

    @Override
    public int getWeight() {
        return super.getWeight() * 100;
    }

    @Override
    public GridTransport createGrid() {
        return new GridTransport(this.world());
    }

    @Override
    @Nullable
    public DuctUnitTransportBase.TransportDestination cacheTile(@Nonnull TileEntity tile, byte side) {
        return null;
    }

    @Override
    public DuctUnitTransportBase getCachedTile(byte side) {
        if (((DuctUnitTransportBase[])this.ductCache)[side] != null && ((DuctUnitTransportBase[])this.ductCache)[side].isLongRange()) {
            return null;
        }
        return super.getCachedTile(side);
    }

    public RouteCache<DuctUnitTransportBase, GridTransport> getCache() {
        return this.getCache(true);
    }

    public RouteCache<DuctUnitTransportBase, GridTransport> getCache(boolean urgent) {
        assert (this.grid != null);
        return urgent ? ((GridTransport)this.grid).getRoutesFromOutput(this) : ((GridTransport)this.grid).getRoutesFromOutputNonUrgent(this);
    }

    public EntityTransport findRoute(Entity entity, int side, byte speed) {
        Route route = this.getRoute(entity, side, speed);
        return route != null ? new EntityTransport(this, route, (byte)side, speed) : null;
    }

    @Override
    public boolean canStuffItem() {
        return false;
    }

    @Override
    public int getMaxRange() {
        return Integer.MAX_VALUE;
    }

    @Override
    public RouteInfo canRouteItem(ItemStack stack) {
        return RouteInfo.noRoute;
    }

    @Override
    public byte getStuffedSide() {
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            if (!this.isOutput(i)) continue;
            return i;
        }
        return 0;
    }

    @Override
    public boolean acceptingStuff() {
        return false;
    }

    @Override
    public ConnectionType getConnectionType(byte side) {
        if (this.rangePos[side] == null) {
            // empty if block
        }
        return super.getConnectionType(side);
    }

    @Override
    @Nonnull
    protected BlockDuct.ConnectionType getConnectionTypeDuct(DuctUnitTransportBase duct, int side) {
        if (this.rangePos[side] == null && duct.isLongRange()) {
            return BlockDuct.ConnectionType.TILE_CONNECTION;
        }
        return super.getConnectionTypeDuct(duct, side);
    }

    @Override
    @Nonnull
    public Collection<BlockPos> getAdditionalImportantPositions() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SidedBlockPos sidedBlockPos : this.rangePos) {
            builder.add((Object)sidedBlockPos.pos);
        }
        return builder.build();
    }

    public static class SidedBlockPos {
        public static SidedBlockPos ORIGIN = new SidedBlockPos(BlockPos.field_177992_a, EnumFacing.DOWN);
        @Nonnull
        final BlockPos pos;
        @Nonnull
        final EnumFacing side;

        public SidedBlockPos(@Nonnull BlockPos pos, @Nonnull EnumFacing side) {
            this.pos = pos;
            this.side = side;
        }

        public SidedBlockPos(NBTTagCompound tag) {
            this(new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z")), EnumFacing.values()[tag.func_74762_e("s")]);
        }

        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("x", this.pos.func_177958_n());
            tag.func_74768_a("y", this.pos.func_177956_o());
            tag.func_74768_a("z", this.pos.func_177952_p());
            tag.func_74768_a("s", this.side.ordinal());
        }
    }
}

