/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.fluid;

import cofh.core.network.PacketCoFHBase;
import cofh.thermaldynamics.block.BlockDuct;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.fluid.DuctUnitFluid;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DuctUnitFluidOmni
extends DuctUnitFluid {
    byte fluidMask;

    public DuctUnitFluidOmni(TileGrid parent, Duct duct) {
        super(parent, duct);
    }

    @Override
    public void writeToTilePacket(PacketCoFHBase payload) {
        super.writeToTilePacket(payload);
        byte fluidMask = 0;
        for (int i = 0; i < ((DuctUnitFluid[])this.ductCache).length; ++i) {
            if (((DuctUnitFluid[])this.ductCache)[i] == null) continue;
            fluidMask = (byte)(fluidMask | 1 << i);
        }
        payload.addByte(fluidMask);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        super.handleTilePacket(payload);
        this.fluidMask = payload.getByte();
    }

    @Override
    public int[] getRenderFluidConnections() {
        int[] renderFluidConnections = super.getRenderFluidConnections();
        for (int i = 0; i < 6; ++i) {
            if ((this.fluidMask & 1 << i) != 0) continue;
            renderFluidConnections[i] = BlockDuct.ConnectionType.STRUCTURE_CONNECTION.ordinal();
        }
        return renderFluidConnections;
    }
}

