/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.item;

import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.item.DuctUnitItem;
import cofh.thermaldynamics.duct.item.StackMap;
import cofh.thermaldynamics.duct.item.TravelingItem;
import cofh.thermaldynamics.multiblock.IGridTile;
import cofh.thermaldynamics.multiblock.MultiBlockGridWithRoutes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class GridItem
extends MultiBlockGridWithRoutes<DuctUnitItem, GridItem> {
    public int travelingItemsCount = 0;
    public static ArrayList<Attachment> toTick = new ArrayList();
    public HashMap<BlockPos, StackMap> travelingItems = new HashMap();
    public boolean shouldRepoll = true;
    public boolean repoll = false;

    public GridItem(World world) {
        super(world);
    }

    @Override
    public void tickGrid() {
        IGridTile m;
        super.tickGrid();
        this.repoll = this.shouldRepoll;
        if (this.shouldRepoll) {
            if (!this.travelingItems.isEmpty()) {
                this.travelingItems.clear();
            }
            this.travelingItemsCount = 0;
        }
        this.shouldRepoll = false;
        Iterator<Object> iterator = this.nodeSet.iterator();
        while (iterator.hasNext() && (m = (IGridTile)iterator.next()).tickPass(0)) {
        }
        if (this.repoll || this.travelingItemsCount > 0) {
            iterator = this.idleSet.iterator();
            while (iterator.hasNext() && (m = (IGridTile)iterator.next()).tickPass(0)) {
            }
        }
        if (!toTick.isEmpty()) {
            for (Attachment attachment : toTick) {
                attachment.tick(1);
            }
            for (Attachment attachment : toTick) {
                attachment.tick(2);
            }
            toTick.clear();
        }
        super.tickGrid();
    }

    @Override
    public boolean canAddBlock(IGridTile aBlock) {
        return aBlock instanceof DuctUnitItem;
    }

    public void poll(TravelingItem item) {
        ++this.travelingItemsCount;
        if (item.myPath == null) {
            return;
        }
        BlockPos dest = item.getDest();
        StackMap list = this.travelingItems.computeIfAbsent(dest, k -> new StackMap());
        list.addItemEntry(item.getStackEntry(), item.stack.field_77994_a);
    }

    @Override
    public void onMinorGridChange() {
        super.onMinorGridChange();
        this.shouldRepoll = true;
    }

    @Override
    public void onMajorGridChange() {
        super.onMajorGridChange();
        this.shouldRepoll = true;
    }

    @Override
    public void addInfo(List<ITextComponent> info, EntityPlayer player, boolean debug) {
        super.addInfo(info, player, debug);
        this.addInfo(info, "items", this.travelingItemsCount);
    }
}

