/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.item;

import cofh.core.util.nbt.NBTCopyHelper;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Iterator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class StackMap
extends TObjectIntHashMap<ItemEntry> {
    public boolean addItemstack(ItemStack itemStack, int side) {
        this.adjustOrPutValue(new ItemEntry(itemStack, side), itemStack.field_77994_a, itemStack.field_77994_a);
        return true;
    }

    public boolean addItemEntry(ItemEntry entry, int amount) {
        if (entry == null) {
            return false;
        }
        this.adjustOrPutValue(entry, amount, amount);
        return true;
    }

    public IteratorItemstack getItems() {
        return new IteratorItemstack();
    }

    public class IteratorItemstack
    implements Iterator<ItemStack>,
    Iterable<ItemStack> {
        public final TObjectIntIterator<ItemEntry> iterator;

        public IteratorItemstack() {
            this.iterator = StackMap.this.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public ItemStack next() {
            this.iterator.advance();
            return ((ItemEntry)this.iterator.key()).toItemStack(this.iterator.value());
        }

        @Override
        public Iterator<ItemStack> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    public static final class ItemEntry {
        public final Item item;
        public final int metadata;
        public final int side;
        private final int hash;
        public NBTTagCompound tag;

        public ItemEntry(ItemStack item, int side) {
            this(item.func_77973_b(), item.func_77952_i(), item.func_77978_p(), side);
        }

        public ItemEntry(Item item, int metadata, NBTTagCompound tag, int side) {
            this.item = item;
            this.metadata = metadata;
            this.side = side;
            int item_id = this.getId();
            if (tag == null) {
                this.tag = null;
                this.hash = metadata & 0x3FFF | item_id << 14 | side << 28;
            } else {
                NBTCopyHelper.ResultNBT resultNBT = NBTCopyHelper.copyAndHashNBT((NBTTagCompound)tag);
                this.tag = resultNBT.copy;
                this.hash = (metadata & 0x3FFF | item_id << 14 | side << 28) ^ resultNBT.hash;
            }
        }

        public ItemStack toItemStack(int amount) {
            if (this.tag == null) {
                return new ItemStack(this.item, amount, this.metadata);
            }
            ItemStack itemStack = new ItemStack(this.item, amount, this.metadata);
            itemStack.func_77982_d(this.tag.func_74737_b());
            return itemStack;
        }

        protected final int getId() {
            return Item.func_150891_b((Item)this.item);
        }

        public String toString() {
            return "ItemEntry{item=" + this.item + ", hash=" + this.hash + ", metadata=" + this.metadata + ", tag=" + this.tag + ", side=" + this.side + '}';
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ItemEntry)) {
                return false;
            }
            ItemEntry itemEntry = (ItemEntry)o;
            if (this.hash != itemEntry.hash) {
                return false;
            }
            if (this.side != itemEntry.side) {
                return false;
            }
            if (this.metadata != itemEntry.metadata) {
                return false;
            }
            if (!this.item.equals(itemEntry.item)) {
                return false;
            }
            if (this.tag != null) {
                if (itemEntry.tag == null) {
                    return false;
                }
                if (this.tag == itemEntry.tag) return true;
                if (!this.tag.equals((Object)itemEntry.tag)) return false;
                this.tag = itemEntry.tag;
                return true;
            } else {
                if (itemEntry.tag == null) return true;
                return false;
            }
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

