/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.tiles;

import cofh.api.energy.IEnergyReceiver;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.duct.energy.DuctUnitEnergy;
import cofh.thermaldynamics.duct.fluid.DuctUnitFluid;
import cofh.thermaldynamics.duct.fluid.DuctUnitFluidSuper;
import cofh.thermaldynamics.duct.fluid.DuctUnitFluidTemperate;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.TileGridStructureBase;

public abstract class TileDuctFluid
extends TileGridStructureBase {
    public static final int NODE_TRANSFER = 4000;

    public TileDuctFluid(Duct duct) {
        this(duct, true);
    }

    public TileDuctFluid(Duct duct, boolean addDefault) {
        if (addDefault) {
            this.addDuctUnits(DuctToken.FLUID, new DuctUnitFluid(this, duct));
        }
    }

    @Override
    protected DuctToken getPrimaryDuctToken() {
        return DuctToken.FLUID;
    }

    public static class Super
    extends TileDuctFluid {
        public Super(Duct duct) {
            super(duct, false);
            this.addDuctUnits(DuctToken.FLUID, new DuctUnitFluidSuper(this, duct));
        }

        public static class Opaque
        extends Super {
            public Opaque() {
                super(TDDucts.fluidSuperOpaque);
            }
        }

        public static class Transparent
        extends Super {
            public Transparent() {
                super(TDDucts.fluidSuper);
            }
        }
    }

    public static class Energy
    extends TileDuctFluid
    implements IEnergyReceiver {
        public Energy(Duct duct) {
            super(duct);
            this.addDuctUnits(DuctToken.ENERGY, new DuctUnitEnergy(this, duct, 4000, 20000));
        }

        public static class Opaque
        extends Energy {
            public Opaque() {
                super(TDDucts.fluidEnergyOpaque);
            }
        }

        public static class Transparent
        extends Energy {
            public Transparent() {
                super(TDDucts.fluidEnergy);
            }
        }
    }

    public static class Hardened
    extends TileDuctFluid {
        public Hardened(Duct duct) {
            super(duct);
        }

        public static class Opaque
        extends Hardened {
            public Opaque() {
                super(TDDucts.fluidHardenedOpaque);
            }
        }

        public static class Transparent
        extends Hardened {
            public Transparent() {
                super(TDDucts.fluidHardened);
            }
        }
    }

    public static class Basic
    extends TileDuctFluid {
        public Basic(Duct duct) {
            super(duct, false);
            this.addDuctUnits(DuctToken.FLUID, new DuctUnitFluidTemperate(this, duct));
        }

        public static class Opaque
        extends Basic {
            public Opaque() {
                super(TDDucts.fluidBasicOpaque);
            }
        }

        public static class Transparent
        extends Basic {
            public Transparent() {
                super(TDDucts.fluidBasic);
            }
        }
    }
}

