/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.plugins.jei;

import cofh.lib.util.helpers.StringHelper;
import cofh.thermaldynamics.item.ItemCover;
import cofh.thermaldynamics.plugins.jei.CoverRecipeHandler;
import cofh.thermaldynamics.plugins.jei.CoverRecipeWrapper;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class CoverRecipeCategory
extends BlankRecipeCategory<CoverRecipeWrapper> {
    private static final int craftOutputSlot = 0;
    private static final int craftInputSlot1 = 1;
    public static final int width = 116;
    public static final int height = 54;
    private final IDrawableStatic background;
    private final String localizedName;
    private final ICraftingGridHelper craftingGridHelper;

    public static void initialize(IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CoverRecipeCategory(guiHelper)});
        registry.addRecipeHandlers(new IRecipeHandler[]{new CoverRecipeHandler()});
        registry.addRecipes(CoverRecipeCategory.getRecipes());
        registry.addRecipeCategoryCraftingItem(new ItemStack(Blocks.field_150462_ai), new String[]{"thermaldynamics.cover"});
    }

    public static List<CoverRecipeWrapper> getRecipes() {
        LinkedList<CoverRecipeWrapper> recipes = new LinkedList<CoverRecipeWrapper>();
        for (ItemStack stack : ItemCover.getCoverList()) {
            recipes.add(new CoverRecipeWrapper(stack));
        }
        return recipes;
    }

    public CoverRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("minecraft", "textures/gui/container/crafting_table.png");
        this.background = guiHelper.createDrawable(location, 29, 16, 116, 54);
        this.localizedName = StringHelper.localize((String)"recipe.thermaldynamics.covers");
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(1, 0);
    }

    public String getUid() {
        return "thermaldynamics.cover";
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, CoverRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 94, 18);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 1 + x + y * 3;
                guiItemStacks.init(index, true, x * 18, y * 18);
            }
        }
        this.craftingGridHelper.setInputStacks(guiItemStacks, ingredients.getInputs(ItemStack.class));
        this.craftingGridHelper.setOutput(guiItemStacks, ingredients.getOutputs(ItemStack.class));
    }
}

